/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.metadata;

import com.ibm.db2.cmx.annotation.Column;
import com.ibm.db2.cmx.annotation.ColumnOverride;
import com.ibm.db2.cmx.annotation.ColumnOverrides;
import com.ibm.db2.cmx.annotation.JoinColumn;
import com.ibm.db2.cmx.annotation.JoinPoint;
import com.ibm.db2.cmx.annotation.Table;
import com.ibm.db2.cmx.runtime.exception.DataSQLException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.metadata.BeanPropertyInformation;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PropertyIntrospector {
    public List<Field> getFields(Class clazz) {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            Field[] fieldArray = PropertyIntrospector.getDeclaredFieldsForClass(clazz);
            if (fieldArray != null) {
                for (int i10 = 0; i10 < fieldArray.length; ++i10) {
                    if ((fieldArray[i10].getModifiers() & 8) != 0) continue;
                    arrayList.add(fieldArray[i10]);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    public Map<String, String> getColumnOverideAnnotations(Class<?> clazz) throws DataSQLException {
        Object object;
        HashMap<String, String> hashMap = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (clazz.isAnnotationPresent(ColumnOverrides.class)) {
            if (bl3) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_COLOVER", clazz.getCanonicalName()), null, 10122);
            }
            bl2 = true;
            object = clazz.getAnnotation(ColumnOverrides.class).value();
            if (object != null) {
                hashMap = new HashMap<String, String>();
                for (ColumnOverride columnOverride : object) {
                    this.addOverideToMap(hashMap, columnOverride);
                }
            }
        }
        if (clazz.isAnnotationPresent(ColumnOverride.class)) {
            if (bl2) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_COLOVER2", clazz.getCanonicalName()), null, 10123);
            }
            bl3 = true;
            object = clazz.getAnnotation(ColumnOverride.class);
            hashMap = new HashMap();
            this.addOverideToMap(hashMap, (ColumnOverride)object);
        }
        return hashMap;
    }

    private void addOverideToMap(Map<String, String> map, ColumnOverride columnOverride) {
        String string = PropertyIntrospector.getAnnotationValue(columnOverride, "propertyName", "");
        String string2 = PropertyIntrospector.getAnnotationValue(columnOverride, "column", "");
        map.put(string, string2.toLowerCase());
    }

    protected static <T> T getAnnotationValue(Annotation annotation, String string, T t2) {
        try {
            Class<? extends Annotation> clazz = annotation.annotationType();
            Method method = PropertyIntrospector.getMethodByNameForClass(clazz, string, null);
            return (T)method.invoke((Object)annotation, (Object[])null);
        }
        catch (Exception exception) {
            return t2;
        }
    }

    public Field getFieldFromFieldArray(List<Field> list, String string) {
        for (Field field : list) {
            if (!field.getName().equalsIgnoreCase(string)) continue;
            return field;
        }
        return null;
    }

    protected BeanPropertyInformation getColumnAnnotationFromField(Field field, String string) {
        if (field.isAnnotationPresent(Column.class)) {
            Column column = field.getAnnotation(Column.class);
            return PropertyIntrospector.getColumnAnnotations(column, string);
        }
        if (string != null && string.length() > 0 && !field.isAnnotationPresent(JoinPoint.class)) {
            return new BeanPropertyInformation(field.getName(), string);
        }
        return null;
    }

    protected static BeanPropertyInformation getColumnAnnotations(Annotation annotation, String string) {
        String string2 = PropertyIntrospector.getAnnotationValue(annotation, "name", null);
        if (string2 != null) {
            String string3 = PropertyIntrospector.getAnnotationValue(annotation, "table", "*");
            if ("*".equals(string3)) {
                string3 = string;
            }
            if ("".equals(string3)) {
                string3 = null;
            }
            return new BeanPropertyInformation(string2, string3);
        }
        return null;
    }

    public List<Method> getMethods(Class clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Method[] methodArray = PropertyIntrospector.getMethodsForClass(clazz);
        if (methodArray != null) {
            for (int i10 = 0; i10 < methodArray.length; ++i10) {
                if ((methodArray[i10].getModifiers() & 8) != 0) continue;
                String string = methodArray[i10].getDeclaringClass().getName();
                Class<?> clazz2 = methodArray[i10].getReturnType();
                if (string.startsWith("java.") || string.startsWith("javax.")) continue;
                String string2 = methodArray[i10].getName();
                if (string2.startsWith("get") && !clazz2.equals(Void.TYPE)) {
                    if (methodArray[i10].getGenericParameterTypes().length != 0) continue;
                    this.addMethodToArray(arrayList, methodArray, i10);
                    continue;
                }
                if (string2.startsWith("is") && (clazz2.equals(Boolean.TYPE) || clazz2.equals(Boolean.class))) {
                    if (methodArray[i10].getGenericParameterTypes().length != 0) continue;
                    this.addMethodToArray(arrayList, methodArray, i10);
                    continue;
                }
                if (!string2.startsWith("set") || !clazz2.equals(Void.TYPE) || methodArray[i10].getGenericParameterTypes().length != 1) continue;
                this.addMethodToArray(arrayList, methodArray, i10);
            }
        }
        return arrayList;
    }

    private void addMethodToArray(List<Method> list, Method[] methodArray, int n2) {
        int n3 = methodArray[n2].getModifiers();
        if (Modifier.isPublic(methodArray[n2].getModifiers()) && !Modifier.isAbstract(n3) && !Modifier.isVolatile(n3)) {
            list.add(methodArray[n2]);
        }
    }

    private static Field[] getDeclaredFieldsForClass(Class clazz) {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(PropertyIntrospector.getDeclaredFields(clazz));
        }
        return PropertyIntrospector.getDeclaredFieldsNoSM(clazz);
    }

    private static Field[] getDeclaredFieldsNoSM(Class clazz) {
        return clazz.getDeclaredFields();
    }

    private static final PrivilegedAction<Field[]> getDeclaredFields(final Class clazz) {
        return new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return PropertyIntrospector.getDeclaredFieldsNoSM(clazz);
            }
        };
    }

    private static Method getMethodByNameForClass(Class clazz, String string, Class[] classArray) throws PrivilegedActionException, SecurityException, NoSuchMethodException {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(PropertyIntrospector.getMethodWithParms(clazz, string, classArray));
        }
        return PropertyIntrospector.getMethodWithParmsNoSM(clazz, string, classArray);
    }

    private static Method getMethodWithParmsNoSM(Class clazz, String string, Class[] classArray) throws SecurityException, NoSuchMethodException {
        return clazz.getMethod(string, classArray);
    }

    private static final PrivilegedExceptionAction<Method> getMethodWithParms(final Class clazz, final String string, final Class[] classArray) {
        return new PrivilegedExceptionAction<Method>(){

            @Override
            public Method run() throws NoSuchMethodException {
                return PropertyIntrospector.getMethodWithParmsNoSM(clazz, string, classArray);
            }
        };
    }

    private static Method[] getMethodsForClass(Class clazz) {
        if (DataProperties.runningUnderSecurityManager_) {
            return AccessController.doPrivileged(PropertyIntrospector.getMethodsPriv(clazz));
        }
        return PropertyIntrospector.getMethodsNoSM(clazz);
    }

    private static Method[] getMethodsNoSM(Class clazz) {
        return clazz.getMethods();
    }

    private static final PrivilegedAction<Method[]> getMethodsPriv(final Class clazz) {
        return new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return PropertyIntrospector.getMethodsNoSM(clazz);
            }
        };
    }

    public String getTableAnnotation(Class<?> clazz) throws DataSQLException {
        String string = null;
        if (clazz.isAnnotationPresent(Table.class)) {
            Table table = clazz.getAnnotation(Table.class);
            string = table.name();
        }
        return string;
    }

    protected static BeanPropertyInformation getJoinColumnValues(JoinColumn joinColumn) {
        BeanPropertyInformation beanPropertyInformation = null;
        String string = joinColumn.name();
        String string2 = joinColumn.table();
        String string3 = joinColumn.propertyName();
        if (string != null) {
            if (string2.equals("*") || string2.equals("")) {
                string2 = null;
            }
            if (string3 == null) {
                string3 = "*";
            }
            beanPropertyInformation = new BeanPropertyInformation(string3);
            beanPropertyInformation.setColumnName(string);
            beanPropertyInformation.setTableName(string2);
            beanPropertyInformation.setJoinPointPropertyName(string3);
            beanPropertyInformation.setJoinPointProperty(true);
            beanPropertyInformation.setDerivedProperty(true);
        }
        return beanPropertyInformation;
    }

    protected BeanPropertyInformation[] getJoinPointAnnotationsFromField(Field field, String string) throws DataSQLException {
        Object object;
        BeanPropertyInformation[] beanPropertyInformationArray = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (field.isAnnotationPresent(JoinPoint.class)) {
            if (bl3) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_JOINCOL", field.getName(), field.getDeclaringClass().getCanonicalName()), null, 11229);
            }
            bl2 = true;
            object = field.getAnnotation(JoinPoint.class).value();
            if (object != null) {
                beanPropertyInformationArray = new BeanPropertyInformation[((JoinColumn[])object).length];
                int n2 = 0;
                for (JoinColumn joinColumn : object) {
                    beanPropertyInformationArray[n2++] = PropertyIntrospector.getJoinColumnValues(joinColumn);
                }
                if (beanPropertyInformationArray.length == 1 && "*".equals(beanPropertyInformationArray[0].getColumnName()) && beanPropertyInformationArray[0].getTableName() == null && "*".equals(beanPropertyInformationArray[0].getJoinPointPropertyName()) && (object = field.getAnnotation(JoinPoint.class).joinCol()) != null) {
                    beanPropertyInformationArray = new BeanPropertyInformation[((JoinColumn[])object).length];
                    n2 = 0;
                    for (JoinColumn joinColumn : object) {
                        beanPropertyInformationArray[n2++] = PropertyIntrospector.getJoinColumnValues(joinColumn);
                    }
                }
            }
        }
        if (field.isAnnotationPresent(JoinColumn.class)) {
            if (bl2) {
                throw ExceptionFactory.createDataSQLExceptionForRuntimeOnly(Messages.getText("ERR_JOINCOL", field.getName(), field.getDeclaringClass().getCanonicalName()), null, 11230);
            }
            bl3 = true;
            object = field.getAnnotation(JoinColumn.class);
            beanPropertyInformationArray = new BeanPropertyInformation[]{PropertyIntrospector.getJoinColumnValues((JoinColumn)object)};
        }
        return beanPropertyInformationArray;
    }

    protected String getJoinPointColumnPrefix(Field field) throws DataSQLException {
        if (field.isAnnotationPresent(JoinPoint.class)) {
            String string = field.getAnnotation(JoinPoint.class).columnPrefix();
            if (string != null && string.length() == 0) {
                string = null;
            }
            return string;
        }
        return null;
    }

    protected String getJoinPointColumnPrefix(Method method) throws DataSQLException {
        if (method.isAnnotationPresent(JoinPoint.class)) {
            String string = method.getAnnotation(JoinPoint.class).columnPrefix();
            if (string != null && string.length() == 0) {
                string = null;
            }
            return string;
        }
        return null;
    }
}

