/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.gds.ng.FbBlob;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FirebirdBlob;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.TypeConversionException;

class FBBlobField
extends FBField
implements FBFlushableField {
    protected FirebirdBlob blob;
    private long length;
    private InputStream binaryStream;
    private Reader characterStream;
    private byte[] bytes;

    FBBlobField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        super(fieldDescriptor, dataProvider, requiredType);
    }

    @Override
    public void close() throws SQLException {
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        finally {
            this.blob = null;
            this.bytes = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.length = 0L;
        }
    }

    protected FirebirdBlob getBlobInternal() {
        if (this.blob != null) {
            return this.blob;
        }
        byte[] bytes = this.getFieldData();
        if (bytes == null) {
            return null;
        }
        this.blob = new FBBlob(this.gdsHelper, this.getDatatypeCoder().decodeLong(bytes));
        return this.blob;
    }

    @Override
    public Blob getBlob() throws SQLException {
        FirebirdBlob blob = this.getBlobInternal();
        return blob != null ? this.registerWithTransaction(blob.detach()) : null;
    }

    @Override
    public Clob getClob() throws SQLException {
        FBBlob blob = (FBBlob)this.getBlob();
        if (blob == null) {
            return null;
        }
        return new FBClob(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        FirebirdBlob blob = this.getBlobInternal();
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    @Override
    public byte[] getBytes() throws SQLException {
        return this.getBytesInternal();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getBytesInternal() throws SQLException {
        byte[] blobIdBuffer = this.getFieldData();
        if (blobIdBuffer == null) {
            return null;
        }
        long blobId = this.getDatatypeCoder().decodeLong(blobIdBuffer);
        Object object = this.gdsHelper.getSynchronizationObject();
        synchronized (object) {
            try (FbBlob blobHandle = this.gdsHelper.openBlob(blobId, true);){
                byte[] segmentBuffer;
                int blobLength = (int)blobHandle.length();
                int bufferLength = this.gdsHelper.getBlobBufferLength();
                byte[] resultBuffer = new byte[blobLength];
                for (int offset = 0; offset < blobLength; offset += segmentBuffer.length) {
                    segmentBuffer = blobHandle.getSegment(bufferLength);
                    if (segmentBuffer.length == 0) {
                        throw new TypeConversionException("Error converting to array of bytes.");
                    }
                    System.arraycopy(segmentBuffer, 0, resultBuffer, offset, segmentBuffer.length);
                }
                byte[] byArray = resultBuffer;
                return byArray;
            }
        }
    }

    @Override
    public byte[] getCachedData() throws SQLException {
        if (this.isNull()) {
            return this.bytes;
        }
        return this.getBytesInternal();
    }

    @Override
    public FBFlushableField.CachedObject getCachedObject() throws SQLException {
        if (this.isNull()) {
            return new FBFlushableField.CachedObject(this.bytes, this.binaryStream, this.characterStream, this.length);
        }
        byte[] bytes = this.getBytesInternal();
        return new FBFlushableField.CachedObject(bytes, null, null, bytes.length);
    }

    @Override
    public void setCachedObject(FBFlushableField.CachedObject cachedObject) throws SQLException {
        this.setNull();
        this.bytes = cachedObject.bytes;
        this.binaryStream = cachedObject.binaryStream;
        this.characterStream = cachedObject.characterStream;
        this.length = cachedObject.length;
    }

    @Override
    public String getString() throws SQLException {
        if (this.fieldDescriptor.getSubType() < 0) {
            throw new TypeConversionException("Error converting to string.");
        }
        FirebirdBlob blob = this.getBlobInternal();
        if (blob == null) {
            return null;
        }
        return this.getDatatypeCoder().decodeString(this.getBytes());
    }

    @Override
    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        this.setNull();
        if (in != null) {
            this.characterStream = in;
            this.length = length;
        }
    }

    @Override
    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        this.setNull();
        if (in != null) {
            this.binaryStream = in;
            this.length = length;
        }
    }

    @Override
    public void flushCachedData() throws SQLException {
        if (this.binaryStream != null) {
            this.copyBinaryStream(this.binaryStream, this.length);
        } else if (this.characterStream != null) {
            this.copyCharacterStream(this.characterStream, this.length, this.getDatatypeCoder().getEncoding());
        } else if (this.bytes != null) {
            this.copyBytes(this.bytes, (int)this.length);
        } else if (this.blob == null) {
            this.setNull();
        }
        this.characterStream = null;
        this.binaryStream = null;
        this.bytes = null;
        this.length = 0L;
    }

    private void copyBinaryStream(InputStream in, long length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyStream(in, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
    }

    private void copyCharacterStream(Reader in, long length, Encoding encoding) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyCharacterStream(in, length, encoding);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
    }

    private void copyBytes(byte[] bytes, int length) throws SQLException {
        FBBlob blob = new FBBlob(this.gdsHelper);
        blob.copyBytes(bytes, 0, length);
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
    }

    @Override
    public void setBytes(byte[] value) throws SQLException {
        this.setNull();
        if (value != null) {
            this.bytes = value;
            this.length = value.length;
        }
    }

    @Override
    public void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        this.setBytes(this.getDatatypeCoder().encodeString(value));
    }

    @Override
    public void setBlob(FBBlob blob) throws SQLException {
        this.setNull();
        this.setFieldData(this.getDatatypeCoder().encodeLong(blob.getBlobId()));
        this.blob = blob;
    }

    @Override
    public void setClob(FBClob clob) throws SQLException {
        FBBlob blob = clob.getWrappedBlob();
        this.setBlob(blob);
    }

    @Override
    public void setNull() {
        super.setNull();
        try {
            if (this.blob != null) {
                this.blob.free();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.blob = null;
            this.binaryStream = null;
            this.characterStream = null;
            this.bytes = null;
            this.length = 0L;
        }
    }

    private <T extends FirebirdBlob> T registerWithTransaction(T blob) {
        FbTransaction currentTransaction;
        if (blob instanceof TransactionListener && (currentTransaction = this.gdsHelper.getCurrentTransaction()) != null) {
            currentTransaction.addWeakTransactionListener((TransactionListener)((Object)blob));
        }
        return blob;
    }
}

