/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.aws;

import com.dbeaver.net.auth.aws.AuthModelAWSPreferences;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.AuthProperty;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.SecureProperty;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProcessDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AuthModelAWSCredentials
extends AuthModelDatabaseNativeCredentials {
    private static final Log log = Log.getLog(AuthModelAWSCredentials.class);
    private static final String ROLE_SESSION_NAME = "dbeaver";
    private String region;
    private String profileName;
    private String pluginName;
    private boolean defaultAwsCredentials;
    @SecureProperty
    private String awsAccessKey;
    @SecureProperty
    private String awsSecretKey;
    private AwsCredentialsProvider awsCredentialsProvider;
    private String secretName;
    private boolean ssoOverCli;
    private boolean crossAccountAccess;
    private String awsAssumeAccountId;
    private String awsAssumeRoleName;
    private String awsSessionToken;
    private String awsExternalId;
    private Map<String, ?> attributes = Collections.emptyMap();

    public AuthModelAWSCredentials() {
    }

    public AuthModelAWSCredentials(AuthModelAWSCredentials source) {
        this.region = source.region;
        this.profileName = source.profileName;
        this.pluginName = source.pluginName;
        this.defaultAwsCredentials = source.defaultAwsCredentials;
        this.awsAccessKey = source.awsAccessKey;
        this.awsSecretKey = source.awsSecretKey;
        this.awsSessionToken = source.awsSessionToken;
        this.ssoOverCli = source.ssoOverCli;
        this.crossAccountAccess = source.crossAccountAccess;
        this.awsAssumeAccountId = source.awsAssumeAccountId;
        this.awsAssumeRoleName = source.awsAssumeRoleName;
        this.awsExternalId = source.awsExternalId;
        this.secretName = source.secretName;
        this.attributes = new LinkedHashMap(source.attributes);
    }

    @Property(hidden=true)
    public String getUserPassword() {
        return super.getUserPassword();
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getProfileName() {
        return this.profileName;
    }

    void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Property(order=2)
    @AuthProperty(contextProvided=true)
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Region getAwsRegion() {
        if (CommonUtils.isEmpty((String)this.region)) {
            return Region.AWS_GLOBAL;
        }
        return Region.of((String)this.region);
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public boolean isDefaultAwsCredentials() {
        return this.defaultAwsCredentials;
    }

    void setDefaultAwsCredentials(boolean defaultAwsCredentials) {
        this.defaultAwsCredentials = defaultAwsCredentials;
    }

    @Property(order=3)
    @AuthProperty(contextProvided=true)
    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public void setAwsAccessKey(String awsAccessKey) {
        this.awsAccessKey = awsAccessKey;
    }

    @Property(order=4, password=true)
    @AuthProperty(contextProvided=true)
    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public void setAwsSecretKey(String awsSecretKey) {
        this.awsSecretKey = awsSecretKey;
    }

    @Property(hidden=true, password=true)
    @AuthProperty(contextProvided=true)
    public String getAwsSessionToken() {
        return this.awsSessionToken;
    }

    public void setAwsSessionToken(String awsSessionToken) {
        this.awsSessionToken = awsSessionToken;
    }

    public AwsCredentialsProvider getAwsCredentialsProvider() {
        return this.awsCredentialsProvider;
    }

    public void setAwsCredentialsProvider(AwsCredentialsProvider awsCredentialsProvider) {
        this.awsCredentialsProvider = awsCredentialsProvider;
    }

    public boolean isSsoOverCli() {
        return this.ssoOverCli;
    }

    public void setSsoOverCli(boolean ssoOverCli) {
        this.ssoOverCli = ssoOverCli;
    }

    @Property
    @AuthProperty(contextProvided=true)
    public boolean isCrossAccountAccess() {
        return this.crossAccountAccess;
    }

    public void setCrossAccountAccess(boolean crossAccountAccess) {
        this.crossAccountAccess = crossAccountAccess;
    }

    @Property(order=0x7FFFFFFD)
    public String getAwsAssumeAccountId() {
        return this.awsAssumeAccountId;
    }

    void setAwsAssumeAccountId(String awsAssumeAccountId) {
        this.awsAssumeAccountId = awsAssumeAccountId;
    }

    @Property(order=0x7FFFFFFE)
    public String getAwsAssumeRoleName() {
        return this.awsAssumeRoleName;
    }

    @Property(order=0x7FFFFFFF)
    public String getAwsExternalId() {
        return this.awsExternalId;
    }

    public void setAwsExternalId(String awsExternalId) {
        this.awsExternalId = awsExternalId;
    }

    void setAwsAssumeRoleName(String awsAssumeRoleName) {
        this.awsAssumeRoleName = awsAssumeRoleName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor) throws DBCException {
        return this.getAuthCredentialsProvider(monitor, null);
    }

    @Property(hidden=true)
    @AuthProperty(contextProvided=true)
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public AwsCredentialsProvider getAuthCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBCException {
        AwsCredentialsProvider credentialsProvider = this.resolveCredentialsProvider(monitor, configuration);
        if (this.ssoOverCli) {
            try {
                credentialsProvider.resolveCredentials();
            }
            catch (Throwable throwable) {
                this.initializeSSO(monitor);
            }
        }
        if (this.crossAccountAccess && !CommonUtils.isEmpty((String)this.awsAssumeAccountId)) {
            monitor.subTask("Assume AWS role");
            if (CommonUtils.isEmpty((String)this.awsAssumeRoleName)) {
                throw new DBCException("AWS IAM role name must be specified when 3rd party IAM account is specified");
            }
            Region awsRegion = this.getAwsRegion();
            String roleArn = "arn:aws:iam::" + this.awsAssumeAccountId + ":role/" + this.awsAssumeRoleName;
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(awsRegion)).credentialsProvider(credentialsProvider)).build();
            AssumeRoleRequest.Builder arRequestBuilder = AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(ROLE_SESSION_NAME);
            if (!CommonUtils.isEmpty((String)this.awsExternalId)) {
                arRequestBuilder.externalId(this.awsExternalId);
            }
            AssumeRoleRequest arRequest = (AssumeRoleRequest)arRequestBuilder.build();
            credentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(arRequest).build();
        }
        return credentialsProvider;
    }

    private AwsCredentialsProvider resolveCredentialsProvider(@NotNull DBRProgressMonitor monitor, @Nullable DBPConnectionConfiguration configuration) throws DBCException {
        DefaultCredentialsProvider credentialsProvider;
        if (this.awsCredentialsProvider != null) {
            return this.awsCredentialsProvider;
        }
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            monitor.subTask("Read AWS profiles");
            if (CommonUtils.isEmpty((String)this.profileName)) {
                throw new DBCException("AWS profile name must be specified");
            }
            credentialsProvider = ProfileCredentialsProvider.builder().profileName(this.profileName).build();
        } else if (this.defaultAwsCredentials) {
            credentialsProvider = DefaultCredentialsProvider.builder().reuseLastProviderEnabled(Boolean.valueOf(false)).build();
        } else {
            String accessKey = this.awsAccessKey;
            String secretKey = this.awsSecretKey;
            String sessionToken = this.awsSessionToken;
            if (configuration != null) {
                if (CommonUtils.isEmpty((String)accessKey)) {
                    accessKey = configuration.getUserName();
                }
                if (CommonUtils.isEmpty((String)secretKey)) {
                    secretKey = configuration.getUserPassword();
                }
            }
            if (CommonUtils.isEmpty((String)accessKey) || CommonUtils.isEmpty((String)secretKey)) {
                DBPAuthInfo authInfo;
                monitor.subTask("Acquire secret credentials in interactive mode");
                try {
                    authInfo = DBWorkbench.getPlatformUI().promptUserCredentials("Please enter access key and secret key", "Access Key", accessKey, "Secret Key", secretKey, false, false);
                }
                catch (Exception e) {
                    authInfo = null;
                    log.error((Object)e);
                }
                if (authInfo != null) {
                    accessKey = authInfo.getUserName();
                    secretKey = authInfo.getUserPassword();
                } else {
                    throw new DBCException("AWS access key and secret key must be specified");
                }
            }
            Object awsCredentials = CommonUtils.isEmpty((String)sessionToken) ? AwsBasicCredentials.create((String)accessKey, (String)secretKey) : AwsSessionCredentials.create((String)accessKey, (String)secretKey, (String)sessionToken);
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCredentials);
        }
        return credentialsProvider;
    }

    private void initializeSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Initialize SSO over AWS CLI");
        String cliParams = String.valueOf(AuthModelAWSCredentials.getAwsCliExecutablePath()) + " sso login";
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            cliParams = String.valueOf(cliParams) + " --profile " + this.profileName;
        }
        log.debug((Object)("Perform AWS SSO init [" + cliParams + "]"));
        this.executeCLI(monitor, cliParams);
        monitor.subTask("SSO init finished");
    }

    private void logoutSSO(@NotNull DBRProgressMonitor monitor) throws DBCException {
        monitor.subTask("Initialize SSO over AWS CLI");
        String cliParams = String.valueOf(AuthModelAWSCredentials.getAwsCliExecutablePath()) + " sso logout";
        if (!CommonUtils.isEmpty((String)this.profileName)) {
            cliParams = String.valueOf(cliParams) + " --profile " + this.profileName;
        }
        log.debug((Object)("Perform AWS SSO logout [" + cliParams + "]"));
        this.executeCLI(monitor, cliParams);
        monitor.subTask("SSO logout finished");
    }

    private void executeCLI(@NotNull DBRProgressMonitor monitor, String cliParams) throws DBCException {
        DBRShellCommand cliCommand = new DBRShellCommand(cliParams);
        cliCommand.setEnabled(true);
        final DBRProcessDescriptor cliProcess = new DBRProcessDescriptor(cliCommand);
        try {
            cliProcess.execute();
        }
        catch (DBException e) {
            throw new DBCException("Error running AWS CLI. Is it installed on the local machine?", (Throwable)e);
        }
        final String[] cliErrorLog = new String[2];
        AbstractJob dumpJob = null;
        if (cliProcess.isRunning()) {
            dumpJob = new AbstractJob(String.valueOf(cliProcess.getName()) + ": output reader"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        cliErrorLog[0] = cliProcess.dumpErrors();
                        cliErrorLog[1] = cliProcess.dumpOutput();
                    }
                    catch (Exception e) {
                        log.debug((Object)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            dumpJob.schedule();
        }
        while (cliProcess.isRunning()) {
            if (monitor.isCanceled()) {
                cliProcess.terminate();
                throw new DBCException("AWS SSO initialization has been canceled");
            }
            RuntimeUtils.pause((int)50);
        }
        if (dumpJob != null) {
            try {
                dumpJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        int resCode = cliProcess.getExitValue();
        String infoMessage = cliErrorLog[1];
        if (!CommonUtils.isEmptyTrimmed((String)infoMessage)) {
            log.debug((Object)("AWS SSO login info message:\n" + infoMessage));
        }
        if (resCode != 0) {
            String errorMessage = cliErrorLog[0];
            if (!CommonUtils.isEmptyTrimmed((String)errorMessage)) {
                errorMessage = "AWS SSO login failed: " + errorMessage.trim();
                throw new DBCException(errorMessage);
            }
            log.debug((Object)("AWS SSO login ended with result  code " + resCode));
        }
    }

    public boolean refreshSession(DBRProgressMonitor monitor, DBPDataSourceContainer dataSource) throws DBCException {
        if (!this.ssoOverCli) {
            return false;
        }
        this.initializeSSO(monitor);
        return true;
    }

    public boolean closeSession(DBRProgressMonitor monitor) throws DBCException {
        if (!this.ssoOverCli) {
            return false;
        }
        this.logoutSSO(monitor);
        return true;
    }

    @NotNull
    private static String getAwsCliExecutablePath() {
        String executable = AuthModelAWSPreferences.getPreferences().getString("aws.cli.executable");
        return CommonUtils.isEmpty((String)executable) ? "aws" : executable;
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, ?> attributes) {
        this.attributes = attributes;
    }

    public Object getAttribute(String name) {
        return this.attributes == null ? null : this.attributes.get(name);
    }
}

