/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.model;

import com.couchbase.client.java.cluster.AuthDomain;
import com.couchbase.client.java.cluster.BucketSettings;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.cluster.User;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.dbeaver.db.couchbase.CouchbaseUtils;
import com.dbeaver.db.couchbase.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase.model.CouchbaseBucket;
import com.dbeaver.db.couchbase.model.CouchbaseDataSourceInfo;
import com.dbeaver.db.couchbase.model.CouchbaseNode;
import com.dbeaver.db.couchbase.model.CouchbaseSQLDialect;
import com.dbeaver.db.couchbase.model.CouchbaseUser;
import com.dbeaver.model.NoSQLDataSource;
import com.dbeaver.model.NoSQLDataType;
import com.dbeaver.model.document.DocumentDataManager;
import com.dbeaver.model.document.data.DBDocumentUtils;
import com.dbeaver.model.document.data.DBMapValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IntKeyMap;

public class CouchbaseDataSource
extends NoSQLDataSource<CouchbaseExecutionContext>
implements DBPDataSource,
DocumentDataManager<CouchbaseDataSource, JsonObject>,
DBPRefreshableObject,
DBPDataTypeProvider,
IAdaptable,
DBCQueryTransformProvider {
    private static final Log log = Log.getLog(CouchbaseDataSource.class);
    private IntKeyMap<NoSQLDataType> dataTypes;
    private CouchbaseDataSourceInfo info;
    private final BucketCache bucketCache = new BucketCache();
    private final UserCache userCache = new UserCache();
    private final NodeCache nodeCache = new NodeCache();
    private static Gson JSON_BUILDER = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").setLenient().serializeNulls().create();

    public CouchbaseDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        this.dataTypes = DBDocumentUtils.makeDocumentDataTypes((DBPDataSource)this);
        this.executionContext = new CouchbaseExecutionContext(this, "Main Couchbase Connection");
        ((CouchbaseExecutionContext)this.executionContext).connect(monitor);
    }

    public CouchbaseSQLDialect getSQLDialect() {
        return CouchbaseSQLDialect.INSTANCE;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.document-data-source": {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.info = new CouchbaseDataSourceInfo(this);
    }

    @NotNull
    public CouchbaseExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        CouchbaseExecutionContext context = new CouchbaseExecutionContext(this, purpose);
        context.connect(monitor);
        return context;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return null;
        }
        if (adapter == DBCQueryTransformProvider.class) {
            return adapter.cast((Object)this);
        }
        return null;
    }

    public void shutdown(DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        this.bucketCache.clearCache();
    }

    public List<CouchbaseBucket> getBuckets(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.bucketCache.getAllObjects(monitor, this);
    }

    public CouchbaseBucket getDefaultBucket(DBRProgressMonitor monitor) throws DBException {
        String bucketName = this.getContainer().getConnectionConfiguration().getDatabaseName();
        CouchbaseBucket bucket = null;
        if (!CommonUtils.isEmpty((String)bucketName) && (bucket = (CouchbaseBucket)this.bucketCache.getObject(monitor, (DBSObject)this, bucketName)) == null) {
            log.debug((Object)("Bucket '" + bucketName + "' not found. Use first one"));
        }
        if (bucket == null) {
            if (this.bucketCache.getCachedObjects().isEmpty()) {
                throw new DBCException("No buckets available");
            }
            bucket = (CouchbaseBucket)((Object)this.bucketCache.getCachedObjects().get(0));
        }
        return bucket;
    }

    @Association
    public List<CouchbaseUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, this);
    }

    @Association
    public List<CouchbaseNode> getNodes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.nodeCache.getAllObjects(monitor, this);
    }

    public List<CouchbaseBucket> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getBuckets(monitor);
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.bucketCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<CouchbaseBucket> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CouchbaseBucket.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.bucketCache.getAllObjects(monitor, this);
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        return DBPDataKind.OBJECT;
    }

    public DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return null;
    }

    public List<DBSDataType> getLocalDataTypes() {
        return new ArrayList<DBSDataType>(this.dataTypes.values());
    }

    public DBSDataType getLocalDataType(String typeName) {
        for (NoSQLDataType dt : this.dataTypes.values()) {
            if (!dt.getTypeName().equals(typeName)) continue;
            return dt;
        }
        return null;
    }

    public DBSDataType getLocalDataType(int typeID) {
        return (DBSDataType)this.dataTypes.get(typeID);
    }

    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        return "";
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.bucketCache.clearCache();
        return this;
    }

    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, true);
        }
        return null;
    }

    public void serializeDocument(JsonObject document, Writer writer) {
        JSON_BUILDER.toJson((Object)document.toMap(), (Appendable)writer);
    }

    public Map<String, Object> deserializeDocument(Reader reader) {
        return JSONUtils.parseMap((Gson)JSON_BUILDER, (Reader)reader);
    }

    public DBMapValue<CouchbaseDataSource> convertNativeDocumentToMap(JsonObject jsonObject) {
        return CouchbaseUtils.makeRawMap(this, null, jsonObject);
    }

    public JsonObject convertMapToNativeDocument(DBMapValue<CouchbaseDataSource> map) {
        return JsonObject.from((Map)map.getRawValue());
    }

    public DBSDataType getDocumentDataType(int typeId) {
        return (DBSDataType)this.dataTypes.get(typeId);
    }

    public class BucketCache
    extends BasicObjectCache<CouchbaseDataSource, CouchbaseBucket> {
        @NotNull
        public List<CouchbaseBucket> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseBucket> result = new ArrayList<CouchbaseBucket>();
                for (BucketSettings bucketSettings : ((CouchbaseExecutionContext)CouchbaseDataSource.this.executionContext).getCluster().clusterManager().getBuckets()) {
                    result.add(new CouchbaseBucket(dataSource, bucketSettings, true));
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }

        public void clearCache() {
            List buckets = this.getCachedObjects();
            if (!CommonUtils.isEmpty((Collection)buckets)) {
                for (CouchbaseBucket bucket : buckets) {
                    bucket.close();
                }
            }
            super.clearCache();
        }
    }

    public class NodeCache
    extends BasicObjectCache<CouchbaseDataSource, CouchbaseNode> {
        @NotNull
        public List<CouchbaseNode> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseNode> result = new ArrayList<CouchbaseNode>();
                ClusterInfo clusterInfo = ((CouchbaseExecutionContext)CouchbaseDataSource.this.executionContext).getClusterInfo();
                JsonArray nodes = clusterInfo.raw().getArray("nodes");
                if (nodes != null) {
                    int i = 0;
                    while (i < nodes.size()) {
                        JsonObject nodeMap = nodes.getObject(i);
                        result.add(new CouchbaseNode(dataSource, nodeMap));
                        ++i;
                    }
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }

    public class UserCache
    extends BasicObjectCache<CouchbaseDataSource, CouchbaseUser> {
        @NotNull
        public List<CouchbaseUser> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseDataSource dataSource) throws DBCException {
            if (!this.isFullyCached()) {
                ArrayList<CouchbaseUser> result = new ArrayList<CouchbaseUser>();
                for (User user : ((CouchbaseExecutionContext)CouchbaseDataSource.this.executionContext).getCluster().clusterManager().getUsers(AuthDomain.LOCAL)) {
                    result.add(new CouchbaseUser(dataSource, user));
                }
                this.setCache(result);
            }
            return this.getCachedObjects();
        }
    }
}

