/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.exec;

import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.CouchbaseCluster;
import com.couchbase.client.java.cluster.ClusterInfo;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.dbeaver.db.couchbase.exec.CouchbaseSession;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.utils.CommonUtils;

public class CouchbaseExecutionContext
extends AbstractExecutionContext<CouchbaseDataSource> {
    private static final Log log = Log.getLog(CouchbaseExecutionContext.class);
    private Cluster cluster;
    private CouchbaseEnvironment environment;
    private ClusterInfo clusterInfo;

    public CouchbaseExecutionContext(CouchbaseDataSource dataSource, String purpose) {
        super((DBPDataSource)dataSource, purpose);
    }

    public CouchbaseEnvironment getEnvironment() {
        return this.environment;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public void connect(DBRProgressMonitor monitor) throws DBCException {
        this.connect(monitor, null, null);
    }

    public void connect(DBRProgressMonitor monitor, Boolean autoCommit, @Nullable Integer txnLevel) throws DBCException {
        DBExecUtils.startContextInitiation((DBPDataSourceContainer)((CouchbaseDataSource)this.dataSource).getContainer());
        try {
            try {
                this.reconnect(monitor);
                super.initContextBootstrap(monitor, true);
                ((CouchbaseDataSource)this.dataSource).addExecutionContext((DBCExecutionContext)this);
            }
            catch (Exception e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)this);
            }
        }
        finally {
            DBExecUtils.finishContextInitiation((DBPDataSourceContainer)((CouchbaseDataSource)this.dataSource).getContainer());
        }
    }

    private void reconnect(@NotNull DBRProgressMonitor monitor) {
        monitor.subTask("Open Couchbase session");
        if (this.cluster != null) {
            try {
                this.cluster.disconnect();
            }
            catch (Exception ex) {
                log.debug((Object)ex);
            }
            this.cluster = null;
            this.clusterInfo = null;
            this.environment = null;
        }
        DBPConnectionConfiguration configuration = ((CouchbaseDataSource)this.dataSource).getContainer().getActualConnectionConfiguration();
        String nodeAddress = configuration.getHostName();
        String nodePort = configuration.getHostPort();
        String userName = configuration.getUserName();
        String userPassword = configuration.getUserPassword();
        monitor.subTask("Setup environment");
        DefaultCouchbaseEnvironment.Builder envBuilder = DefaultCouchbaseEnvironment.builder();
        envBuilder.bootstrapHttpDirectPort(CommonUtils.toInt((Object)nodePort, (int)8091));
        DBPConnectionConfiguration config = ((CouchbaseDataSource)this.dataSource).getContainer().getConnectionConfiguration();
        if (config.hasProperty("couchbase.connectionTimeout")) {
            envBuilder.connectTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.connectionTimeout")));
        }
        if (config.hasProperty("couchbase.analyticsTimeout")) {
            envBuilder.analyticsTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.analyticsTimeout")));
        }
        if (config.hasProperty("couchbase.kvTimeout")) {
            envBuilder.kvTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.kvTimeout")));
        }
        if (config.hasProperty("couchbase.queryTimeout")) {
            envBuilder.queryTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.queryTimeout")));
        }
        if (config.hasProperty("couchbase.managementTimeout")) {
            envBuilder.managementTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.managementTimeout")));
        }
        if (config.hasProperty("couchbase.searchTimeout")) {
            envBuilder.searchTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.searchTimeout")));
        }
        if (config.hasProperty("couchbase.viewTimeout")) {
            envBuilder.viewTimeout(CommonUtils.toLong((Object)config.getProperty("couchbase.viewTimeout")));
        }
        if (config.hasProperty("couchbase.sslEnabled")) {
            envBuilder.sslEnabled(CommonUtils.toBoolean((Object)config.getProperty("couchbase.sslEnabled")));
        }
        if (config.hasProperty("couchbase.sslKeystoreFile")) {
            envBuilder.sslKeystoreFile(CommonUtils.toString((Object)config.getProperty("couchbase.sslKeystoreFile")));
        }
        if (config.hasProperty("couchbase.sslKeystoreFile")) {
            envBuilder.sslKeystorePassword(CommonUtils.toString((Object)config.getProperty("couchbase.sslKeystorePassword")));
        }
        this.environment = envBuilder.build();
        this.cluster = CouchbaseCluster.create((CouchbaseEnvironment)this.environment, (String[])new String[]{String.valueOf(nodeAddress) + ":" + nodePort});
        if (!CommonUtils.isEmpty((String)userName) && !CommonUtils.isEmpty((String)userPassword)) {
            this.cluster.authenticate(userName, userPassword);
        }
        monitor.subTask("Get cluster info");
        this.clusterInfo = this.cluster.clusterManager().info();
    }

    @NotNull
    public CouchbaseSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String taskTitle) {
        return new CouchbaseSession(monitor, purpose, taskTitle, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    public DBSInstance getOwnerInstance() {
        return (DBSInstance)this.dataSource;
    }

    public boolean isConnected() {
        return this.cluster != null;
    }

    @NotNull
    public DBCExecutionContext.InvalidateResult invalidateContext(@NotNull DBRProgressMonitor monitor, boolean closeOnFailure) throws DBException {
        this.reconnect(monitor);
        ((CouchbaseDataSource)this.dataSource).refreshObject(monitor);
        return DBCExecutionContext.InvalidateResult.RECONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.cluster != null) {
            try {
                this.cluster.disconnect();
            }
            catch (Exception e) {
                log.debug((Object)"Error disconnecting cluster", (Throwable)e);
            }
        }
        CouchbaseExecutionContext couchbaseExecutionContext = this;
        synchronized (couchbaseExecutionContext) {
            ((CouchbaseDataSource)this.dataSource).removeExecutionContext((DBCExecutionContext)this);
            super.closeContext();
        }
    }
}

