/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.ad;

import com.dbeaver.model.auth.SMApplicationIdentityProvider;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.microsoft.aad.msal4j.IAccount;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import com.microsoft.aad.msal4j.ITokenCacheAccessContext;
import com.microsoft.aad.msal4j.InteractiveRequestParameters;
import com.microsoft.aad.msal4j.PublicClientApplication;
import com.microsoft.aad.msal4j.SilentParameters;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.security.auth.callback.CallbackHandler;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.BasicWorkspaceSession;
import org.jkiss.utils.CommonUtils;

public class AzureIdentityProvider
implements SMApplicationIdentityProvider {
    private static final Log log = Log.getLog(AzureIdentityProvider.class);
    private static final String PROP_SERVICE_URL = "dbeaver.auth.azure.service_url";
    private static final Path TOKEN_CACHE_FILE = Path.of(".ad", "azure_token_cache.json");
    private final Gson gson = new Gson();
    private final HttpClient client = HttpClient.newHttpClient();

    @NotNull
    public SMSession acquireApplicationSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPWorkspace workspace, @NotNull CallbackHandler handler) throws DBException {
        String serviceUrl = System.getProperty(PROP_SERVICE_URL);
        if (CommonUtils.isEmptyTrimmed((String)serviceUrl)) {
            throw new DBException("Property 'dbeaver.auth.azure.service_url' is not set");
        }
        try {
            ConfigResponse config = this.queryService(String.valueOf(serviceUrl) + "/auth/config", ConfigResponse.class);
            IAuthenticationResult result = this.authenticate(workspace, config.clientId, config.scopes);
            SessionResponse session = this.queryService(String.valueOf(serviceUrl) + "/auth/" + result.idToken(), SessionResponse.class);
            return new WorkspaceSession(workspace, session.session);
        }
        catch (DBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DBException("Error acquiring session", (Throwable)e);
        }
    }

    @NotNull
    private IAuthenticationResult authenticate(@NotNull DBPWorkspace workspace, @NotNull String clientId, @NotNull Set<String> scopes) throws InterruptedException, ExecutionException, URISyntaxException, MalformedURLException {
        Path metadata = workspace.getMetadataFolder();
        Path file = metadata.resolve(TOKEN_CACHE_FILE);
        PublicClientApplication application = ((PublicClientApplication.Builder)PublicClientApplication.builder((String)clientId).setTokenCacheAccessAspect((ITokenCacheAccessAspect)new TokenCache(file))).build();
        Set accounts = (Set)application.getAccounts().get();
        if (accounts.isEmpty()) {
            InteractiveRequestParameters params = InteractiveRequestParameters.builder((URI)new URI("http://localhost")).scopes(scopes).build();
            return (IAuthenticationResult)application.acquireToken(params).get();
        }
        SilentParameters params = SilentParameters.builder(scopes, (IAccount)((IAccount)accounts.iterator().next())).build();
        return (IAuthenticationResult)application.acquireTokenSilently(params).get();
    }

    @NotNull
    private <T> T queryService(@NotNull String url, @NotNull Class<T> cls) throws DBException {
        try {
            HttpResponse<String> response = this.client.send(HttpRequest.newBuilder().uri(URI.create(url)).build(), HttpResponse.BodyHandlers.ofString());
            ServiceResponse data = (ServiceResponse)this.gson.fromJson(response.body(), TypeToken.getParameterized(ServiceResponse.class, (Type[])new Type[]{cls}).getType());
            if (data.ok != null) {
                return data.ok;
            }
            if (data.error != null) {
                throw new DBException(data.error.message);
            }
            throw new DBException("Unexpected service response");
        }
        catch (Exception e) {
            throw new DBException("Unexpected error while communicating with the service", (Throwable)e);
        }
    }

    private static class ConfigResponse {
        @SerializedName(value="client_id")
        private String clientId;
        private Set<String> scopes;

        private ConfigResponse() {
        }
    }

    private static class ErrorResponse {
        private String message;

        private ErrorResponse() {
        }
    }

    private static class ServiceResponse<T> {
        private T ok;
        private ErrorResponse error;

        private ServiceResponse() {
        }
    }

    private static class SessionResponse {
        private String session;

        private SessionResponse() {
        }
    }

    private static class TokenCache
    implements ITokenCacheAccessAspect {
        private final Path path;

        public TokenCache(@NotNull Path path) {
            this.path = path;
        }

        public void beforeCacheAccess(ITokenCacheAccessContext context) {
            if (Files.notExists(this.path, new LinkOption[0])) {
                return;
            }
            try {
                context.tokenCache().deserialize(Files.readString(this.path));
            }
            catch (Exception e) {
                log.error((Object)"Error reading token cache", (Throwable)e);
            }
        }

        public void afterCacheAccess(ITokenCacheAccessContext context) {
            try {
                if (Files.notExists(this.path.getParent(), new LinkOption[0])) {
                    Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                }
                Files.writeString(this.path, (CharSequence)context.tokenCache().serialize(), new OpenOption[0]);
            }
            catch (Exception e) {
                log.error((Object)"Error writing token cache", (Throwable)e);
            }
        }
    }

    private static class WorkspaceSession
    extends BasicWorkspaceSession {
        private final String sessionId;

        public WorkspaceSession(@NotNull DBPWorkspace workspace, @NotNull String sessionId) {
            super(workspace);
            this.sessionId = sessionId;
        }

        @NotNull
        public String getSessionId() {
            return this.sessionId;
        }
    }
}

