/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.ds.common;

import com.amazon.redshift.Driver;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.BaseConnection;
import com.amazon.redshift.ds.common.RedshiftObjectFactory;
import com.amazon.redshift.jdbc.AutoSave;
import com.amazon.redshift.jdbc.PreferQueryMode;
import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.ExpressionProperties;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import com.amazon.redshift.util.URLCoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;

public abstract class BaseDataSource
implements CommonDataSource,
Referenceable {
    private String[] serverNames = new String[]{"localhost"};
    private String databaseName = "";
    private String user;
    private String password;
    private int[] portNumbers = new int[]{0};
    private Properties properties = new Properties();

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    public Connection getConnection(String user, String password) throws SQLException {
        try {
            Connection con = DriverManager.getConnection(this.getUrl(), user, password);
            if (RedshiftLogger.isEnable()) {
                ((BaseConnection)con).getLogger().log(LogLevel.DEBUG, "Created a {0} for {1} at {2}", this.getDescription(), user, RedshiftLogger.maskSecureInfoInUrl(this.getUrl()));
            }
            if (RedshiftLogger.isEnable()) {
                ((BaseConnection)con).getLogger().logFunction(false, con);
            }
            return con;
        }
        catch (SQLException e) {
            if (RedshiftLogger.isEnable()) {
                RedshiftLogger.getDriverLogger().logError(e);
            }
            throw e;
        }
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
    }

    @Deprecated
    public String getServerName() {
        return this.serverNames[0];
    }

    public String[] getServerNames() {
        return this.serverNames;
    }

    @Deprecated
    public void setServerName(String serverName) {
        this.setServerNames(new String[]{serverName});
    }

    public void setServerNames(String[] serverNames) {
        if (serverNames == null || serverNames.length == 0) {
            this.serverNames = new String[]{"localhost"};
        } else {
            serverNames = Arrays.copyOf(serverNames, serverNames.length);
            for (int i = 0; i < serverNames.length; ++i) {
                if (serverNames[i] != null && !serverNames[i].equals("")) continue;
                serverNames[i] = "localhost";
            }
            this.serverNames = serverNames;
        }
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public abstract String getDescription();

    public String getUser() {
        return this.user;
    }

    public String getUserID() {
        return this.getUser();
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setUserID(String id) {
        this.setUser(id);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public int getPortNumber() {
        if (this.portNumbers == null || this.portNumbers.length == 0) {
            return 0;
        }
        return this.portNumbers[0];
    }

    public int[] getPortNumbers() {
        return this.portNumbers;
    }

    @Deprecated
    public void setPortNumber(int portNumber) {
        this.setPortNumbers(new int[]{portNumber});
    }

    public void setPortNumbers(int[] portNumbers) {
        if (portNumbers == null || portNumbers.length == 0) {
            portNumbers = new int[]{0};
        }
        this.portNumbers = Arrays.copyOf(portNumbers, portNumbers.length);
    }

    public String getOptions() {
        return RedshiftProperty.OPTIONS.get(this.properties);
    }

    public void setOptions(String options) {
        RedshiftProperty.OPTIONS.set(this.properties, options);
    }

    @Override
    public int getLoginTimeout() {
        return RedshiftProperty.LOGIN_TIMEOUT.getIntNoCheck(this.properties);
    }

    @Override
    public void setLoginTimeout(int loginTimeout) {
        RedshiftProperty.LOGIN_TIMEOUT.set(this.properties, loginTimeout);
    }

    public int getConnectTimeout() {
        return RedshiftProperty.CONNECT_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setConnectTimeout(int connectTimeout) {
        RedshiftProperty.CONNECT_TIMEOUT.set(this.properties, connectTimeout);
    }

    public int getProtocolVersion() {
        if (!RedshiftProperty.PROTOCOL_VERSION.isPresent(this.properties)) {
            return 0;
        }
        return RedshiftProperty.PROTOCOL_VERSION.getIntNoCheck(this.properties);
    }

    public void setProtocolVersion(int protocolVersion) {
        if (protocolVersion == 0) {
            RedshiftProperty.PROTOCOL_VERSION.set(this.properties, null);
        } else {
            RedshiftProperty.PROTOCOL_VERSION.set(this.properties, protocolVersion);
        }
    }

    public int getReceiveBufferSize() {
        return RedshiftProperty.RECEIVE_BUFFER_SIZE.getIntNoCheck(this.properties);
    }

    public void setReceiveBufferSize(int nbytes) {
        RedshiftProperty.RECEIVE_BUFFER_SIZE.set(this.properties, nbytes);
    }

    public int getSendBufferSize() {
        return RedshiftProperty.SEND_BUFFER_SIZE.getIntNoCheck(this.properties);
    }

    public void setSendBufferSize(int nbytes) {
        RedshiftProperty.SEND_BUFFER_SIZE.set(this.properties, nbytes);
    }

    public void setPrepareThreshold(int count) {
        RedshiftProperty.PREPARE_THRESHOLD.set(this.properties, count);
    }

    public int getPrepareThreshold() {
        return RedshiftProperty.PREPARE_THRESHOLD.getIntNoCheck(this.properties);
    }

    public int getPreparedStatementCacheQueries() {
        return RedshiftProperty.PREPARED_STATEMENT_CACHE_QUERIES.getIntNoCheck(this.properties);
    }

    public void setPreparedStatementCacheQueries(int cacheSize) {
        RedshiftProperty.PREPARED_STATEMENT_CACHE_QUERIES.set(this.properties, cacheSize);
    }

    public int getPreparedStatementCacheSizeMiB() {
        return RedshiftProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.getIntNoCheck(this.properties);
    }

    public void setPreparedStatementCacheSizeMiB(int cacheSize) {
        RedshiftProperty.PREPARED_STATEMENT_CACHE_SIZE_MIB.set(this.properties, cacheSize);
    }

    public int getDatabaseMetadataCacheFields() {
        return RedshiftProperty.DATABASE_METADATA_CACHE_FIELDS.getIntNoCheck(this.properties);
    }

    public void setDatabaseMetadataCacheFields(int cacheSize) {
        RedshiftProperty.DATABASE_METADATA_CACHE_FIELDS.set(this.properties, cacheSize);
    }

    public int getDatabaseMetadataCacheFieldsMiB() {
        return RedshiftProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.getIntNoCheck(this.properties);
    }

    public void setDatabaseMetadataCacheFieldsMiB(int cacheSize) {
        RedshiftProperty.DATABASE_METADATA_CACHE_FIELDS_MIB.set(this.properties, cacheSize);
    }

    public void setDefaultRowFetchSize(int fetchSize) {
        RedshiftProperty.DEFAULT_ROW_FETCH_SIZE.set(this.properties, fetchSize);
    }

    public int getDefaultRowFetchSize() {
        return RedshiftProperty.DEFAULT_ROW_FETCH_SIZE.getIntNoCheck(this.properties);
    }

    public void setUnknownLength(int unknownLength) {
        RedshiftProperty.UNKNOWN_LENGTH.set(this.properties, unknownLength);
    }

    public int getUnknownLength() {
        return RedshiftProperty.UNKNOWN_LENGTH.getIntNoCheck(this.properties);
    }

    public void setSocketTimeout(int seconds) {
        RedshiftProperty.SOCKET_TIMEOUT.set(this.properties, seconds);
    }

    public int getSocketTimeout() {
        return RedshiftProperty.SOCKET_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setCancelSignalTimeout(int seconds) {
        RedshiftProperty.CANCEL_SIGNAL_TIMEOUT.set(this.properties, seconds);
    }

    public int getCancelSignalTimeout() {
        return RedshiftProperty.CANCEL_SIGNAL_TIMEOUT.getIntNoCheck(this.properties);
    }

    public void setSsl(boolean enabled) {
        if (enabled) {
            RedshiftProperty.SSL.set(this.properties, true);
        } else {
            RedshiftProperty.SSL.set(this.properties, false);
        }
    }

    public boolean getSsl() {
        return RedshiftProperty.SSL.getBoolean(this.properties) || "".equals(RedshiftProperty.SSL.get(this.properties));
    }

    public void setSslfactory(String classname) {
        RedshiftProperty.SSL_FACTORY.set(this.properties, classname);
    }

    public String getSslfactory() {
        return RedshiftProperty.SSL_FACTORY.get(this.properties);
    }

    public String getSslMode() {
        return RedshiftProperty.SSL_MODE.get(this.properties);
    }

    public void setSslMode(String mode) {
        RedshiftProperty.SSL_MODE.set(this.properties, mode);
    }

    public String getSslFactoryArg() {
        return RedshiftProperty.SSL_FACTORY_ARG.get(this.properties);
    }

    public void setSslFactoryArg(String arg) {
        RedshiftProperty.SSL_FACTORY_ARG.set(this.properties, arg);
    }

    public String getSslHostnameVerifier() {
        return RedshiftProperty.SSL_HOSTNAME_VERIFIER.get(this.properties);
    }

    public void setSslHostnameVerifier(String className) {
        RedshiftProperty.SSL_HOSTNAME_VERIFIER.set(this.properties, className);
    }

    public String getSslCert() {
        return RedshiftProperty.SSL_CERT.get(this.properties);
    }

    public void setSslCert(String file) {
        RedshiftProperty.SSL_CERT.set(this.properties, file);
    }

    public String getSslKey() {
        return RedshiftProperty.SSL_KEY.get(this.properties);
    }

    public void setSslKey(String file) {
        RedshiftProperty.SSL_KEY.set(this.properties, file);
    }

    public String getSslRootCert() {
        return RedshiftProperty.SSL_ROOT_CERT.get(this.properties);
    }

    public void setSslRootCert(String file) {
        RedshiftProperty.SSL_ROOT_CERT.set(this.properties, file);
    }

    public String getSslPassword() {
        return RedshiftProperty.SSL_PASSWORD.get(this.properties);
    }

    public void setSslPassword(String password) {
        RedshiftProperty.SSL_PASSWORD.set(this.properties, password);
    }

    public String getSslPasswordCallback() {
        return RedshiftProperty.SSL_PASSWORD_CALLBACK.get(this.properties);
    }

    public void setSslPasswordCallback(String className) {
        RedshiftProperty.SSL_PASSWORD_CALLBACK.set(this.properties, className);
    }

    public void setApplicationName(String applicationName) {
        RedshiftProperty.APPLICATION_NAME.set(this.properties, applicationName);
    }

    public String getApplicationName() {
        return RedshiftProperty.APPLICATION_NAME.get(this.properties);
    }

    public void setTargetServerType(String targetServerType) {
        RedshiftProperty.TARGET_SERVER_TYPE.set(this.properties, targetServerType);
    }

    public String getTargetServerType() {
        return RedshiftProperty.TARGET_SERVER_TYPE.get(this.properties);
    }

    public void setLoadBalanceHosts(boolean loadBalanceHosts) {
        RedshiftProperty.LOAD_BALANCE_HOSTS.set(this.properties, loadBalanceHosts);
    }

    public boolean getLoadBalanceHosts() {
        return RedshiftProperty.LOAD_BALANCE_HOSTS.isPresent(this.properties);
    }

    public void setHostRecheckSeconds(int hostRecheckSeconds) {
        RedshiftProperty.HOST_RECHECK_SECONDS.set(this.properties, hostRecheckSeconds);
    }

    public int getHostRecheckSeconds() {
        return RedshiftProperty.HOST_RECHECK_SECONDS.getIntNoCheck(this.properties);
    }

    public void setTcpKeepAlive(boolean enabled) {
        RedshiftProperty.TCP_KEEP_ALIVE.set(this.properties, enabled);
    }

    public boolean getTcpKeepAlive() {
        return RedshiftProperty.TCP_KEEP_ALIVE.getBoolean(this.properties);
    }

    public void setBinaryTransfer(boolean enabled) {
        RedshiftProperty.BINARY_TRANSFER.set(this.properties, enabled);
    }

    public boolean getBinaryTransfer() {
        return RedshiftProperty.BINARY_TRANSFER.getBoolean(this.properties);
    }

    public void setBinaryTransferEnable(String oidList) {
        RedshiftProperty.BINARY_TRANSFER_ENABLE.set(this.properties, oidList);
    }

    public String getBinaryTransferEnable() {
        return RedshiftProperty.BINARY_TRANSFER_ENABLE.get(this.properties);
    }

    public void setBinaryTransferDisable(String oidList) {
        RedshiftProperty.BINARY_TRANSFER_DISABLE.set(this.properties, oidList);
    }

    public String getBinaryTransferDisable() {
        return RedshiftProperty.BINARY_TRANSFER_DISABLE.get(this.properties);
    }

    public String getStringType() {
        return RedshiftProperty.STRING_TYPE.get(this.properties);
    }

    public void setStringType(String stringType) {
        RedshiftProperty.STRING_TYPE.set(this.properties, stringType);
    }

    public boolean isColumnSanitiserDisabled() {
        return RedshiftProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.properties);
    }

    public boolean getDisableColumnSanitiser() {
        return RedshiftProperty.DISABLE_COLUMN_SANITISER.getBoolean(this.properties);
    }

    public void setDisableColumnSanitiser(boolean disableColumnSanitiser) {
        RedshiftProperty.DISABLE_COLUMN_SANITISER.set(this.properties, disableColumnSanitiser);
    }

    public String getCurrentSchema() {
        return RedshiftProperty.CURRENT_SCHEMA.get(this.properties);
    }

    public void setCurrentSchema(String currentSchema) {
        RedshiftProperty.CURRENT_SCHEMA.set(this.properties, currentSchema);
    }

    public boolean getReadOnly() {
        return RedshiftProperty.READ_ONLY.getBoolean(this.properties);
    }

    public void setReadOnly(boolean readOnly) {
        RedshiftProperty.READ_ONLY.set(this.properties, readOnly);
    }

    public String getReadOnlyMode() {
        return RedshiftProperty.READ_ONLY_MODE.get(this.properties);
    }

    public void setReadOnlyMode(String mode) {
        RedshiftProperty.READ_ONLY_MODE.set(this.properties, mode);
    }

    public boolean getLogUnclosedConnections() {
        return RedshiftProperty.LOG_UNCLOSED_CONNECTIONS.getBoolean(this.properties);
    }

    public void setLogUnclosedConnections(boolean enabled) {
        RedshiftProperty.LOG_UNCLOSED_CONNECTIONS.set(this.properties, enabled);
    }

    public boolean getLogServerErrorDetail() {
        return RedshiftProperty.LOG_SERVER_ERROR_DETAIL.getBoolean(this.properties);
    }

    public void setLogServerErrorDetail(boolean enabled) {
        RedshiftProperty.LOG_SERVER_ERROR_DETAIL.set(this.properties, enabled);
    }

    public String getAssumeMinServerVersion() {
        return RedshiftProperty.ASSUME_MIN_SERVER_VERSION.get(this.properties);
    }

    public void setAssumeMinServerVersion(String minVersion) {
        RedshiftProperty.ASSUME_MIN_SERVER_VERSION.set(this.properties, minVersion);
    }

    public String getJaasApplicationName() {
        return RedshiftProperty.JAAS_APPLICATION_NAME.get(this.properties);
    }

    public void setJaasApplicationName(String name) {
        RedshiftProperty.JAAS_APPLICATION_NAME.set(this.properties, name);
    }

    public boolean getJaasLogin() {
        return RedshiftProperty.JAAS_LOGIN.getBoolean(this.properties);
    }

    public void setJaasLogin(boolean doLogin) {
        RedshiftProperty.JAAS_LOGIN.set(this.properties, doLogin);
    }

    public String getKerberosServerName() {
        return RedshiftProperty.KERBEROS_SERVER_NAME.get(this.properties);
    }

    public void setKerberosServerName(String serverName) {
        RedshiftProperty.KERBEROS_SERVER_NAME.set(this.properties, serverName);
    }

    public boolean getUseSpNego() {
        return RedshiftProperty.USE_SPNEGO.getBoolean(this.properties);
    }

    public void setUseSpNego(boolean use) {
        RedshiftProperty.USE_SPNEGO.set(this.properties, use);
    }

    public String getGssLib() {
        return RedshiftProperty.GSS_LIB.get(this.properties);
    }

    public void setGssLib(String lib) {
        RedshiftProperty.GSS_LIB.set(this.properties, lib);
    }

    public String getSspiServiceClass() {
        return RedshiftProperty.SSPI_SERVICE_CLASS.get(this.properties);
    }

    public void setSspiServiceClass(String serviceClass) {
        RedshiftProperty.SSPI_SERVICE_CLASS.set(this.properties, serviceClass);
    }

    public boolean getAllowEncodingChanges() {
        return RedshiftProperty.ALLOW_ENCODING_CHANGES.getBoolean(this.properties);
    }

    public void setAllowEncodingChanges(boolean allow) {
        RedshiftProperty.ALLOW_ENCODING_CHANGES.set(this.properties, allow);
    }

    public String getSocketFactory() {
        return RedshiftProperty.SOCKET_FACTORY.get(this.properties);
    }

    public void setSocketFactory(String socketFactoryClassName) {
        RedshiftProperty.SOCKET_FACTORY.set(this.properties, socketFactoryClassName);
    }

    public String getSocketFactoryArg() {
        return RedshiftProperty.SOCKET_FACTORY_ARG.get(this.properties);
    }

    public void setSocketFactoryArg(String socketFactoryArg) {
        RedshiftProperty.SOCKET_FACTORY_ARG.set(this.properties, socketFactoryArg);
    }

    public void setReplication(String replication) {
        RedshiftProperty.REPLICATION.set(this.properties, replication);
    }

    public String getEscapeSyntaxCallMode() {
        return RedshiftProperty.ESCAPE_SYNTAX_CALL_MODE.get(this.properties);
    }

    public void setEscapeSyntaxCallMode(String callMode) {
        RedshiftProperty.ESCAPE_SYNTAX_CALL_MODE.set(this.properties, callMode);
    }

    public String getReplication() {
        return RedshiftProperty.REPLICATION.get(this.properties);
    }

    public String getLoggerLevel() {
        String logLevel = RedshiftProperty.LOGGER_LEVEL.get(this.properties);
        if (logLevel == null) {
            logLevel = RedshiftProperty.LOG_LEVEL.get(this.properties);
        }
        return logLevel;
    }

    public void setLoggerLevel(String loggerLevel) {
        RedshiftProperty.LOGGER_LEVEL.set(this.properties, loggerLevel);
    }

    public void setLogLevel(String level) {
        RedshiftProperty.LOG_LEVEL.set(this.properties, level);
    }

    public String getLoggerFile() {
        String logPath;
        ExpressionProperties exprProps = new ExpressionProperties(this.properties, System.getProperties());
        String logFile = RedshiftProperty.LOGGER_FILE.get(exprProps);
        if (logFile == null && (logPath = this.getLogDirectory()) != null) {
            logFile = logPath + File.pathSeparator + "redshift_jdbc.log";
        }
        return logFile;
    }

    public String getLogDirectory() {
        ExpressionProperties exprProps = new ExpressionProperties(this.properties, System.getProperties());
        return RedshiftProperty.LOG_PATH.get(exprProps);
    }

    public void setLoggerFile(String loggerFile) {
        RedshiftProperty.LOGGER_FILE.set(this.properties, loggerFile);
    }

    public void setLogDirectory(String logDirectory) {
        RedshiftProperty.LOG_PATH.set(this.properties, logDirectory);
    }

    public String getUrl() {
        StringBuilder url = new StringBuilder(100);
        url.append("jdbc:redshift://");
        for (int i = 0; i < this.serverNames.length; ++i) {
            if (i > 0) {
                url.append(",");
            }
            url.append(this.serverNames[i]);
            if (this.portNumbers == null || this.portNumbers.length < i || this.portNumbers[i] == 0) continue;
            url.append(":").append(this.portNumbers[i]);
        }
        url.append("/").append(URLCoder.encode(this.databaseName));
        StringBuilder query = new StringBuilder(100);
        for (RedshiftProperty property : RedshiftProperty.values()) {
            if (!property.isPresent(this.properties)) continue;
            if (query.length() != 0) {
                query.append("&");
            }
            query.append(property.getName());
            query.append("=");
            query.append(URLCoder.encode(property.get(this.properties)));
        }
        if (query.length() > 0) {
            url.append("?");
            url.append((CharSequence)query);
        }
        return url.toString();
    }

    public String getURL() {
        return this.getUrl();
    }

    public void setUrl(String url) {
        Properties p = Driver.parseURL(url, null);
        if (p == null) {
            throw new IllegalArgumentException("URL invalid " + url);
        }
        for (RedshiftProperty property : RedshiftProperty.values()) {
            if (this.properties.containsKey(property.getName())) continue;
            this.setProperty(property, property.get(p));
        }
    }

    public void setURL(String url) {
        this.setUrl(url);
    }

    public String getProperty(String name) throws SQLException {
        RedshiftProperty pgProperty = RedshiftProperty.forName(name);
        if (pgProperty != null) {
            return this.getProperty(pgProperty);
        }
        throw new RedshiftException(GT.tr("Unsupported property name: {0}", name), RedshiftState.INVALID_PARAMETER_VALUE);
    }

    public void setProperty(String name, String value) throws SQLException {
        RedshiftProperty pgProperty = RedshiftProperty.forName(name);
        if (pgProperty == null) {
            throw new RedshiftException(GT.tr("Unsupported property name: {0}", name), RedshiftState.INVALID_PARAMETER_VALUE);
        }
        this.setProperty(pgProperty, value);
    }

    public String getProperty(RedshiftProperty property) {
        return property.get(this.properties);
    }

    public void setProperty(RedshiftProperty property, String value) {
        if (value == null) {
            return;
        }
        switch (property) {
            case HOST: {
                this.setServerNames(value.split(","));
                break;
            }
            case PORT: {
                String[] ps = value.split(",");
                int[] ports = new int[ps.length];
                for (int i = 0; i < ps.length; ++i) {
                    try {
                        ports[i] = Integer.parseInt(ps[i]);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        ports[i] = 0;
                    }
                }
                this.setPortNumbers(ports);
                break;
            }
            case DBNAME: {
                this.setDatabaseName(value);
                break;
            }
            case USER: 
            case UID: {
                this.setUser(value);
                break;
            }
            case PASSWORD: 
            case PWD: {
                this.setPassword(value);
                break;
            }
            default: {
                this.properties.setProperty(property.getName(), value);
            }
        }
    }

    protected Reference createReference() {
        return new Reference(this.getClass().getName(), RedshiftObjectFactory.class.getName(), null);
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = this.createReference();
        StringBuilder serverString = new StringBuilder();
        for (int i = 0; i < this.serverNames.length; ++i) {
            if (i > 0) {
                serverString.append(",");
            }
            String serverName = this.serverNames[i];
            serverString.append(serverName);
        }
        ref.add(new StringRefAddr("serverName", serverString.toString()));
        StringBuilder portString = new StringBuilder();
        for (int i = 0; i < this.portNumbers.length; ++i) {
            if (i > 0) {
                portString.append(",");
            }
            int p = this.portNumbers[i];
            portString.append(Integer.toString(p));
        }
        ref.add(new StringRefAddr("portNumber", portString.toString()));
        ref.add(new StringRefAddr("databaseName", this.databaseName));
        if (this.user != null) {
            ref.add(new StringRefAddr("user", this.user));
        }
        if (this.password != null) {
            ref.add(new StringRefAddr("password", this.password));
        }
        for (RedshiftProperty property : RedshiftProperty.values()) {
            if (!property.isPresent(this.properties)) continue;
            ref.add(new StringRefAddr(property.getName(), property.get(this.properties)));
        }
        return ref;
    }

    public void setFromReference(Reference ref) {
        this.databaseName = BaseDataSource.getReferenceProperty(ref, "databaseName");
        String portNumberString = BaseDataSource.getReferenceProperty(ref, "portNumber");
        if (portNumberString != null) {
            String[] ps = portNumberString.split(",");
            int[] ports = new int[ps.length];
            for (int i = 0; i < ps.length; ++i) {
                try {
                    ports[i] = Integer.parseInt(ps[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    ports[i] = 0;
                }
            }
            this.setPortNumbers(ports);
        } else {
            this.setPortNumbers(null);
        }
        this.setServerNames(BaseDataSource.getReferenceProperty(ref, "serverName").split(","));
        for (RedshiftProperty property : RedshiftProperty.values()) {
            this.setProperty(property, BaseDataSource.getReferenceProperty(ref, property.getName()));
        }
    }

    private static String getReferenceProperty(Reference ref, String propertyName) {
        RefAddr addr = ref.get(propertyName);
        if (addr == null) {
            return null;
        }
        return (String)addr.getContent();
    }

    protected void writeBaseObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.serverNames);
        out.writeObject(this.databaseName);
        out.writeObject(this.user);
        out.writeObject(this.password);
        out.writeObject(this.portNumbers);
        out.writeObject(this.properties);
    }

    protected void readBaseObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serverNames = (String[])in.readObject();
        this.databaseName = (String)in.readObject();
        this.user = (String)in.readObject();
        this.password = (String)in.readObject();
        this.portNumbers = (int[])in.readObject();
        this.properties = (Properties)in.readObject();
    }

    public void initializeFrom(BaseDataSource source) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        source.writeBaseObject(oos);
        oos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        this.readBaseObject(ois);
    }

    public PreferQueryMode getPreferQueryMode() {
        return PreferQueryMode.of(RedshiftProperty.PREFER_QUERY_MODE.get(this.properties));
    }

    public void setPreferQueryMode(PreferQueryMode preferQueryMode) {
        RedshiftProperty.PREFER_QUERY_MODE.set(this.properties, preferQueryMode.value());
    }

    public AutoSave getAutosave() {
        return AutoSave.of(RedshiftProperty.AUTOSAVE.get(this.properties));
    }

    public void setAutosave(AutoSave autoSave) {
        RedshiftProperty.AUTOSAVE.set(this.properties, autoSave.value());
    }

    public boolean isRaiseExceptionOnSilentRollback() {
        return RedshiftProperty.RAISE_EXCEPTION_ON_SILENT_ROLLBACK.getBoolean(this.properties);
    }

    public void setRaiseExceptionOnSilentRollback(boolean raiseExceptionOnSilentRollback) {
        RedshiftProperty.RAISE_EXCEPTION_ON_SILENT_ROLLBACK.set(this.properties, raiseExceptionOnSilentRollback);
    }

    public boolean getCleanupSavepoints() {
        return RedshiftProperty.CLEANUP_SAVEPOINTS.getBoolean(this.properties);
    }

    public void setCleanupSavepoints(boolean cleanupSavepoints) {
        RedshiftProperty.CLEANUP_SAVEPOINTS.set(this.properties, cleanupSavepoints);
    }

    public boolean getReWriteBatchedInserts() {
        return RedshiftProperty.REWRITE_BATCHED_INSERTS.getBoolean(this.properties);
    }

    public void setReWriteBatchedInserts(boolean reWrite) {
        RedshiftProperty.REWRITE_BATCHED_INSERTS.set(this.properties, reWrite);
    }

    public boolean getHideUnprivilegedObjects() {
        return RedshiftProperty.HIDE_UNPRIVILEGED_OBJECTS.getBoolean(this.properties);
    }

    public void setHideUnprivilegedObjects(boolean hideUnprivileged) {
        RedshiftProperty.HIDE_UNPRIVILEGED_OBJECTS.set(this.properties, hideUnprivileged);
    }

    public String getMaxResultBuffer() {
        return RedshiftProperty.MAX_RESULT_BUFFER.get(this.properties);
    }

    public void setMaxResultBuffer(String maxResultBuffer) {
        RedshiftProperty.MAX_RESULT_BUFFER.set(this.properties, maxResultBuffer);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("java.util.logging is not used");
    }

    public boolean isSsl() {
        return this.getSsl();
    }

    public String getSslfactoryarg() {
        return this.getSslFactoryArg();
    }

    public void setSslfactoryarg(String arg) {
        this.setSslFactoryArg(arg);
    }

    public String getSslcert() {
        return this.getSslCert();
    }

    public void setSslcert(String file) {
        this.setSslCert(file);
    }

    public String getSslmode() {
        return this.getSslMode();
    }

    public void setSslmode(String mode) {
        this.setSslMode(mode);
    }

    public String getSslhostnameverifier() {
        return this.getSslHostnameVerifier();
    }

    public void setSslhostnameverifier(String className) {
        this.setSslHostnameVerifier(className);
    }

    public String getSslkey() {
        return this.getSslKey();
    }

    public void setSslkey(String file) {
        this.setSslKey(file);
    }

    public String getSslrootcert() {
        return this.getSslRootCert();
    }

    public void setSslrootcert(String file) {
        this.setSslRootCert(file);
    }

    public String getSslpasswordcallback() {
        return this.getSslPasswordCallback();
    }

    public void setSslpasswordcallback(String className) {
        this.setSslPasswordCallback(className);
    }

    public String getSslpassword() {
        return this.getSslPassword();
    }

    public void setSslpassword(String sslpassword) {
        this.setSslPassword(sslpassword);
    }

    public int getRecvBufferSize() {
        return this.getReceiveBufferSize();
    }

    public void setRecvBufferSize(int nbytes) {
        this.setReceiveBufferSize(nbytes);
    }

    public boolean isAllowEncodingChanges() {
        return this.getAllowEncodingChanges();
    }

    public boolean isLogUnclosedConnections() {
        return this.getLogUnclosedConnections();
    }

    public boolean isTcpKeepAlive() {
        return this.getTcpKeepAlive();
    }

    public boolean isReadOnly() {
        return this.getReadOnly();
    }

    public boolean isDisableColumnSanitiser() {
        return this.getDisableColumnSanitiser();
    }

    public boolean isLoadBalanceHosts() {
        return this.getLoadBalanceHosts();
    }

    public boolean isCleanupSavePoints() {
        return this.getCleanupSavepoints();
    }

    public void setCleanupSavePoints(boolean cleanupSavepoints) {
        this.setCleanupSavepoints(cleanupSavepoints);
    }

    public boolean isReWriteBatchedInserts() {
        return this.getReWriteBatchedInserts();
    }

    static {
        try {
            Class.forName("com.amazon.redshift.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("BaseDataSource is unable to load com.amazon.redshift.Driver. Please check if you have proper Redshift JDBC Driver jar on the classpath", e);
        }
    }
}

