/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.exec;

import com.dbeaver.db.couchdb.data.CouchDBDocument;
import com.dbeaver.db.couchdb.exec.CouchDBAbstractStatement;
import com.dbeaver.db.couchdb.exec.CouchDBDatabaseStatement;
import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.model.document.exec.DocumentResultSet;
import com.google.gson.JsonObject;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;

public class CouchDBResultSet
extends DocumentResultSet<CouchDBSession, CouchDBAbstractStatement> {
    private final List<JsonObject> docs;

    CouchDBResultSet(CouchDBAbstractStatement statement, List<JsonObject> docs) {
        super((DBCStatement)statement);
        this.docs = docs;
    }

    @NotNull
    private Object createDocument(JsonObject valueMap) {
        return new CouchDBDocument(((CouchDBSession)this.getSession()).getDataSource(), valueMap);
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        JsonObject valueMap = this.docs.get(this.itemNumber);
        if (index == 0) {
            return this.createDocument(valueMap);
        }
        throw new DBCException("Index out of range (" + index + ")");
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return this.createDocument(this.docs.get(this.itemNumber));
    }

    public boolean nextRow() throws DBCException {
        ++this.itemNumber;
        return this.itemNumber < this.docs.size();
    }

    protected String getSourceEntityName() {
        if (this.statement instanceof CouchDBDatabaseStatement) {
            return ((CouchDBDatabaseStatement)this.statement).getDatabase().getName();
        }
        return null;
    }

    public boolean moveTo(int position) throws DBCException {
        this.itemNumber = position;
        return this.itemNumber < this.docs.size();
    }
}

