/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.graphics.Drawable;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UITextUtils;
import org.jkiss.dbeaver.ui.controls.resultset.FilterByAttributeType;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

class FilterByAttributeAction
extends Action {
    private final ResultSetViewer resultSetViewer;
    private final DBCLogicalOperator operator;
    private final FilterByAttributeType type;
    private final DBDAttributeBinding attribute;

    FilterByAttributeAction(ResultSetViewer resultSetViewer, DBCLogicalOperator operator, FilterByAttributeType type, DBDAttributeBinding attribute) {
        super(String.valueOf(attribute.getName()) + " " + FilterByAttributeAction.translateFilterPattern(resultSetViewer, operator, type, attribute), type.icon);
        this.resultSetViewer = resultSetViewer;
        this.operator = operator;
        this.type = type;
        this.attribute = attribute;
    }

    public void run() {
        Object value = this.type.getValue(this.resultSetViewer, this.attribute, this.operator, false);
        if (this.operator.getArgumentCount() != 0 && value == null) {
            return;
        }
        DBDDataFilter filter = new DBDDataFilter(this.resultSetViewer.getModel().getDataFilter());
        DBDAttributeConstraint constraint = filter.getConstraint(this.attribute);
        if (constraint != null) {
            constraint.setOperator(this.operator);
            constraint.setValue(value);
            this.resultSetViewer.setDataFilter(filter, true);
        }
    }

    @NotNull
    private static String translateFilterPattern(@NotNull ResultSetViewer viewer, @NotNull DBCLogicalOperator operator, @NotNull FilterByAttributeType type, @NotNull DBDAttributeBinding attribute) {
        Object value = type.getValue(viewer, attribute, operator, true);
        DBCExecutionContext executionContext = viewer.getExecutionContext();
        String strValue = executionContext == null ? String.valueOf(value) : attribute.getValueHandler().getValueDisplayString((DBSTypedObject)attribute, value, DBDDisplayFormat.UI);
        strValue = strValue.replaceAll("\\s+", " ").replace("@", "^").trim();
        strValue = UITextUtils.getShortText((Drawable)viewer.getControl(), (String)strValue, (int)150);
        if (operator.getArgumentCount() == 0) {
            return operator.getExpression();
        }
        if (!"..".equals(strValue)) {
            strValue = "'" + strValue + "'";
        }
        return String.valueOf(operator.getExpression()) + " " + strValue;
    }
}

