/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.cache.metadata.AbstractCacheClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.reflect.CacheClass;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class PojoOperations {
    public static final boolean isJDK5;
    public static final Method isEnum;
    public static final Method enumGetOrdinal;
    public static final Method enumGetName;
    public static final Method enumGetValue;

    public static Field getPrivateField(Class clazz, String string) throws NoSuchFieldException {
        Field field;
        try {
            field = clazz.getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) {
                throw noSuchFieldException;
            }
            field = PojoOperations.getPrivateField(clazz2, string);
        }
        return field;
    }

    public static Id toId(Object object) {
        Id id = object instanceof Id ? (Id)object : (object instanceof String ? new Id((String)object) : (object instanceof Integer ? new Id((Integer)object) : new Id(object.toString())));
        return id;
    }

    public static Member lookupPojoIdSetter(Class clazz, CacheClass cacheClass) {
        String string = cacheClass.getIdPlaceholder();
        return PojoOperations.lookupPojoIdSetter(clazz, string);
    }

    public static Member lookupPojoIdSetter(Class clazz, String string) {
        AccessibleObject accessibleObject;
        if (string == null) {
            string = "rowId";
        }
        if (string.startsWith("get")) {
            accessibleObject = PojoOperations.lookupPojoIdSetterMethod(clazz, string);
            if (accessibleObject == null) {
                accessibleObject = PojoOperations.lookupPojoIdField(clazz, string);
            }
        } else {
            accessibleObject = PojoOperations.lookupPojoIdField(clazz, string);
            if (accessibleObject == null) {
                accessibleObject = PojoOperations.lookupPojoIdSetterMethod(clazz, string);
            }
        }
        return accessibleObject;
    }

    private static Field lookupPojoIdField(Class clazz, String string) {
        try {
            Field field = PojoOperations.getPrivateField(clazz, string);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    private static Method lookupPojoIdSetterMethod(Class clazz, String string) {
        try {
            Method method = clazz.getMethod(string, new Class[0]);
            method.setAccessible(true);
            Class<?> clazz2 = method.getReturnType();
            if (!string.startsWith("get")) {
                return null;
            }
            String string2 = "set" + string.substring(3);
            Method method2 = clazz.getMethod(string2, clazz2);
            return method2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static boolean setValueToField(Object object, Object object2, Field field) throws CacheException {
        Class<Object> clazz = field.getType();
        try {
            if (clazz.isAssignableFrom(String.class)) {
                if (object2 != null) {
                    object2 = object2.toString();
                }
            } else if (PojoOperations.isNumberField(clazz) && !(object2 instanceof Number)) {
                if (clazz.equals(Integer.TYPE) || clazz.isAssignableFrom(Integer.class)) {
                    object2 = Integer.valueOf(object2.toString());
                } else if (clazz.equals(Long.TYPE) || clazz.isAssignableFrom(Long.class)) {
                    object2 = Long.valueOf(object2.toString());
                }
            }
            field.set(object, object2);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Insufficeint permissions to set value of " + field.getName() + " in instance of " + object.getClass().getName());
        }
    }

    private static boolean isNumberField(Class clazz) {
        if (clazz.isAssignableFrom(Number.class)) {
            return true;
        }
        return clazz.isPrimitive();
    }

    public static List arrayToList(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.getComponentType().isPrimitive()) {
            int n = Array.getLength(object);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(Array.get(object, i));
            }
            return arrayList;
        }
        return Arrays.asList((Object[])object);
    }

    public static boolean setPojoIdAsMethod(Object object, Serializable object2, Method method) throws CacheException {
        try {
            Class<Object> clazz = method.getParameterTypes()[0];
            if (clazz.isAssignableFrom(String.class)) {
                object2 = object2.toString();
            } else if (object2 instanceof Id) {
                if (clazz.isAssignableFrom(Integer.class)) {
                    object2 = Integer.valueOf(object2.toString());
                } else if (clazz.isAssignableFrom(Long.class)) {
                    object2 = Long.valueOf(object2.toString());
                }
            }
            method.invoke(object, object2);
            return true;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CacheException(illegalAccessException, "Insufficeint permissions to set Id in instance of " + object.getClass().getName());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CacheException(invocationTargetException.getTargetException(), "Failed to set Id in instance of " + object.getClass().getName());
        }
    }

    public static Object tryConvertValue(Class clazz, Object object, Class clazz2) {
        String string;
        if (object == null) {
            if (Collection.class.isAssignableFrom(clazz)) {
                Class clazz3 = clazz;
                if (clazz.isInterface() && clazz2 != null) {
                    clazz3 = clazz2;
                }
                if (!Modifier.isAbstract(clazz3.getModifiers())) {
                    try {
                        object = clazz3.newInstance();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return object;
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                byte by = ((Number)object).byteValue();
                return new Byte(by);
            }
            if (clazz.equals(Character.TYPE)) {
                if (object instanceof Character) {
                    return object;
                }
                if (object instanceof Number) {
                    char c = (char)((Number)object).intValue();
                    return new Character(c);
                }
            } else {
                if (clazz.equals(Short.TYPE)) {
                    short s = ((Number)object).shortValue();
                    return new Short(s);
                }
                if (clazz.equals(Integer.TYPE)) {
                    int n = ((Number)object).intValue();
                    return new Integer(n);
                }
                if (clazz.equals(Long.TYPE)) {
                    long l = ((Number)object).longValue();
                    return new Long(l);
                }
                if (clazz.equals(Float.TYPE)) {
                    float f = ((Number)object).floatValue();
                    return new Float(f);
                }
                if (clazz.equals(Double.TYPE)) {
                    double d = ((Number)object).doubleValue();
                    return new Double(d);
                }
            }
            return object;
        }
        if (clazz.isArray() && object instanceof Collection) {
            Class<?> clazz4 = clazz.getComponentType();
            Collection collection = (Collection)object;
            int n = collection.size();
            Object object2 = Array.newInstance(clazz4, n);
            Iterator iterator = collection.iterator();
            for (int i = 0; i < n && iterator.hasNext(); ++i) {
                Object object3 = iterator.next();
                if (!clazz4.isInstance(object3)) {
                    object3 = PojoOperations.tryConvertValue(clazz4, object3, null);
                }
                Array.set(object2, i, object3);
            }
            return object2;
        }
        if (PojoOperations.isEnum(clazz)) {
            try {
                return enumGetValue.invoke(null, clazz, object);
            }
            catch (Exception exception) {
                if (Logger.debugOn()) {
                    exception.printStackTrace(Logger.out);
                }
                throw new IllegalArgumentException("Can not convert value " + object + " of type " + object.getClass().getName() + " to type " + clazz.getName() + ". Reason: " + exception.getMessage());
            }
        }
        try {
            string = "Can not convert value " + object + " of type " + object.getClass().getName() + " to type " + clazz.getName();
        }
        catch (Exception exception) {
            string = "Can not convert value of type " + object.getClass().getName() + " to type " + clazz.getName();
        }
        throw new IllegalArgumentException(string);
    }

    public static boolean isEnum(Class clazz) {
        if (!isJDK5) {
            return false;
        }
        try {
            Boolean bl = (Boolean)isEnum.invoke((Object)clazz, new Object[0]);
            return bl;
        }
        catch (Exception exception) {
            if (Logger.debugOn()) {
                exception.printStackTrace(Logger.out);
            }
            return false;
        }
    }

    public static Integer enumGetOrdinal(Object object) {
        if (!isJDK5) {
            return null;
        }
        try {
            return (Integer)enumGetOrdinal.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            if (Logger.debugOn()) {
                exception.printStackTrace(Logger.out);
            }
            return null;
        }
    }

    public static String enumGetName(Object object) {
        if (!isJDK5) {
            return null;
        }
        try {
            return (String)enumGetName.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            if (Logger.debugOn()) {
                exception.printStackTrace(Logger.out);
            }
            return null;
        }
    }

    public static Class classForName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        String string2;
        if (Float.TYPE.getName().equals(string)) {
            return Float.TYPE;
        }
        if (Double.TYPE.getName().equals(string)) {
            return Double.TYPE;
        }
        if (Integer.TYPE.getName().equals(string)) {
            return Integer.TYPE;
        }
        if (Long.TYPE.getName().equals(string)) {
            return Long.TYPE;
        }
        if (Short.TYPE.getName().equals(string)) {
            return Short.TYPE;
        }
        if (Byte.TYPE.getName().equals(string)) {
            return Byte.TYPE;
        }
        if (Character.TYPE.getName().equals(string)) {
            return Character.TYPE;
        }
        if (Boolean.TYPE.getName().equals(string)) {
            return Boolean.TYPE;
        }
        if (string.startsWith("com.intersys") && (string2 = AbstractCacheClass.checkIfCollectionClassJavaName(string)) != null) {
            string = string2;
        }
        return Class.forName(string, true, classLoader);
    }

    static {
        Method method;
        Method method2;
        Method method3;
        Method method4;
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.Enum");
            method4 = Class.class.getMethod("isEnum", new Class[0]);
            method3 = clazz.getMethod("ordinal", new Class[0]);
            method2 = clazz.getMethod("name", new Class[0]);
            Class<?> clazz2 = Class.forName("com.jalapeno.tools.objects.EnumUtilities");
            method = clazz2.getMethod("getEnum", Class.class, Object.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
            method4 = null;
            method3 = null;
            method = null;
            method2 = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            clazz = null;
            method4 = null;
            method3 = null;
            method = null;
            method2 = null;
        }
        isJDK5 = clazz != null;
        isEnum = method4;
        enumGetOrdinal = method3;
        enumGetValue = method;
        enumGetName = method2;
    }
}

