/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.runtime;

import com.intersys.objects.CacheException;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.runtime.CacheObjectManager;
import com.jalapeno.runtime.Dependency;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.JalapenoHelperInterface;
import com.jalapeno.runtime.ObjectFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class DependencyResolver {
    private CacheObjectManager mObjectManager;
    private ObjectFactory mObjectFactory;
    private Map mDependencyMap;
    private int mMaxOrder;
    private int mMaxReqOrder;
    private Vector mOrderedObjects;
    private Vector mOrderedObjectsRequired;
    private Set mUnresolvedObjects;
    private int mSequenceNumber;
    private C mComparator;

    public DependencyResolver(CacheObjectManager cacheObjectManager) {
        this.mObjectManager = cacheObjectManager;
        this.mObjectFactory = this.mObjectManager.manager().getObjectFactory();
        this.mMaxOrder = -1;
        this.mMaxReqOrder = -1;
        this.mSequenceNumber = 0;
        this.mComparator = new C();
    }

    public int getMaxOrder() {
        return this.mMaxOrder;
    }

    public int getMaxReqOrder() {
        return this.mMaxReqOrder;
    }

    public Set getOrderedObjects(int n) {
        return (Set)this.mOrderedObjects.get(n);
    }

    public Set getOrderedObjectsRequired(int n) {
        return (Set)this.mOrderedObjectsRequired.get(n);
    }

    public Set getUnresolvedObjects() {
        return this.mUnresolvedObjects;
    }

    public void resolve(Collection collection) throws Exception {
        this.createDependencyMap(collection);
        this.processDependencies();
    }

    public void markAsDirty(DetachedObjectsManager detachedObjectsManager) throws CacheException {
        for (Map.Entry entry : this.mDependencyMap.entrySet()) {
            Object k = entry.getKey();
            Dependency dependency = (Dependency)entry.getValue();
            if (!dependency.isDirty() || dependency.getOrder(false) == -2) continue;
            detachedObjectsManager.setDirty(k);
        }
    }

    private void createDependencyMap(Collection hashSet) throws Exception {
        HashSet hashSet2;
        this.mDependencyMap = new HashMap();
        HashSet hashSet3 = hashSet;
        if (hashSet3 == null || hashSet3 instanceof Set || hashSet3.size() < 10) {
            hashSet2 = hashSet3;
        } else {
            hashSet2 = new HashSet();
            hashSet2.addAll(hashSet3);
        }
        while (hashSet3 != null && !hashSet3.isEmpty()) {
            Collection collection = null;
            for (Object object : hashSet3) {
                object = CacheObjectManager.getDBObject(object);
                Dependency dependency = this.prepareDependency(object);
                this.mDependencyMap.put(object, dependency);
                ++this.mSequenceNumber;
                dependency.userNumber = dependency.userNumber;
                List list = dependency.getReferences();
                if (list == null) continue;
                for (Object e : list) {
                    if (ObjectFactory.isUnswizzledShadow(e) || this.mDependencyMap.containsKey(e) || hashSet2.contains(e)) continue;
                    if (collection == null) {
                        collection = new FastList();
                    }
                    collection.add(e);
                }
            }
            hashSet2 = hashSet3 = collection;
        }
        for (Object object : this.mDependencyMap.keySet()) {
            this.calculateDependency(object);
        }
    }

    private void processDependencies() throws Exception {
        for (Object k : this.mDependencyMap.keySet()) {
            Set set;
            int n = this.calculateOrder(k, new HashSet(), false);
            if (n == -2) {
                n = this.calculateOrder(k, new HashSet(), true);
                if (n == -2) {
                    throw new IllegalStateException("Objects in persistence context contain unresolvable circular dependency");
                }
                if (this.mOrderedObjectsRequired == null) {
                    this.mOrderedObjectsRequired = new Vector();
                }
                if (n > this.mMaxReqOrder) {
                    this.mMaxReqOrder = n;
                    this.mOrderedObjectsRequired.setSize(this.mMaxReqOrder + 1);
                }
                if ((set = (Set)this.mOrderedObjectsRequired.get(n)) == null) {
                    set = new TreeSet(this.mComparator);
                    this.mOrderedObjectsRequired.set(n, set);
                }
                this.addToSet(set, k);
                if (this.mUnresolvedObjects == null) {
                    this.mUnresolvedObjects = new HashSet();
                }
                this.mUnresolvedObjects.add(k);
                continue;
            }
            if (this.mOrderedObjects == null) {
                this.mOrderedObjects = new Vector();
            }
            if (n > this.mMaxOrder) {
                this.mMaxOrder = n;
                this.mOrderedObjects.setSize(this.mMaxOrder + 1);
            }
            if ((set = (TreeSet)this.mOrderedObjects.get(n)) == null) {
                set = new TreeSet(this.mComparator);
                this.mOrderedObjects.set(n, set);
            }
            this.addToSet(set, k);
        }
    }

    private int calculateOrder(Object object, Set set, boolean bl) {
        Dependency dependency = (Dependency)this.mDependencyMap.get(object);
        int n = dependency.getOrder(bl);
        if (n != -1) {
            return n;
        }
        Set set2 = bl ? dependency.getRequiredDependencies() : dependency.getDependencies();
        if (set2 == null || set2.isEmpty()) {
            dependency.setOrder(0, bl);
            return 0;
        }
        int n2 = 0;
        set.add(object);
        for (Object e : set2) {
            if (set.contains(e)) {
                dependency.setOrder(-2, bl);
                return -2;
            }
            int n3 = this.calculateOrder(e, set, bl);
            if (n3 == -2) {
                dependency.setOrder(-2, bl);
                return -2;
            }
            if (n3 <= n2) continue;
            n2 = n3;
        }
        set.remove(object);
        n = n2 + 1;
        dependency.setOrder(n, bl);
        return n;
    }

    private Dependency prepareDependency(Object object) throws Exception {
        CacheClass cacheClass = this.mObjectManager.findImplementation(object.getClass());
        JalapenoHelperInterface jalapenoHelperInterface = this.mObjectFactory.getHelper(cacheClass, this.mObjectManager.getClassLoader());
        Dependency dependency = jalapenoHelperInterface.prepareDependency(object, this.mObjectManager, true);
        return dependency;
    }

    private void calculateDependency(Object object) throws Exception {
        CacheClass cacheClass = this.mObjectManager.findImplementation(object.getClass());
        JalapenoHelperInterface jalapenoHelperInterface = this.mObjectFactory.getHelper(cacheClass, this.mObjectManager.getClassLoader());
        Dependency dependency = (Dependency)this.mDependencyMap.get(object);
        jalapenoHelperInterface.calculateDependency(object, dependency, this.mObjectManager);
    }

    private synchronized void addToSet(Set set, Object object) {
        set.add(object);
    }

    private static class FastList
    extends ArrayList {
        private Set mIdxMap;

        @Override
        public boolean add(Object object) {
            int n = this.size();
            if (n > 10) {
                if (this.mIdxMap == null) {
                    this.mIdxMap = new HashSet();
                    this.mIdxMap.addAll(this);
                }
                this.mIdxMap.add(object);
            }
            return super.add(object);
        }

        @Override
        public boolean contains(Object object) {
            if (this.mIdxMap != null) {
                return this.mIdxMap.contains(object);
            }
            return super.contains(object);
        }
    }

    private class C
    implements Comparator {
        private C() {
        }

        public int compare(Object object, Object object2) {
            Dependency dependency;
            String string;
            if (object == null) {
                return 2;
            }
            if (object2 == null) {
                return -2;
            }
            if (object.equals(object2)) {
                return 0;
            }
            String string2 = object.getClass().getName();
            if (!string2.equals(string = object2.getClass().getName())) {
                return string2.compareTo(string);
            }
            int n = -1;
            int n2 = -1;
            Dependency dependency2 = (Dependency)DependencyResolver.this.mDependencyMap.get(object);
            if (dependency2 != null) {
                n = dependency2.userNumber;
            }
            if ((dependency = (Dependency)DependencyResolver.this.mDependencyMap.get(object2)) != null) {
                n2 = dependency.userNumber;
            }
            if (n != n2) {
                return n - n2;
            }
            return System.identityHashCode(object) - System.identityHashCode(object2);
        }
    }
}

