/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.transaction;

import com.intersys.transaction.ExecutionContext;
import java.util.ArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class CacheTransaction
implements Transaction {
    private static TransactionManager transactionManager;
    private ArrayList resources;
    private Xid xid;
    private int status;

    CacheTransaction(TransactionManager transactionManager, Xid xid) {
        CacheTransaction.transactionManager = transactionManager;
        this.xid = xid;
        this.resources = new ArrayList();
        this.status = 0;
    }

    public final void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this != transactionManager.getTransaction()) {
            new SystemException("Can commit only the transaction associated with the current thread");
        }
        if (this.status != 0 || this.status == 8) {
            throw new SystemException("Invalid transaction status: " + this.status);
        }
        for (int i = 0; i < this.resources.size(); ++i) {
            try {
                XAResource xAResource = (XAResource)this.resources.get(i);
                xAResource.commit(this.xid, true);
                continue;
            }
            catch (Exception exception) {
                throw new HeuristicMixedException("Could not commit across all resources");
            }
        }
        this.status = 3;
        this.resources.clear();
    }

    public final void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (this != transactionManager.getTransaction()) {
            new SystemException("Can rollback only the transaction associated with the current thread");
        }
        if (this.status != 1 || this.status == 9) {
            throw new SystemException("Invalid transaction status: " + this.status);
        }
        for (int i = 0; i < this.resources.size(); ++i) {
            try {
                XAResource xAResource = (XAResource)this.resources.get(i);
                xAResource.rollback(this.xid);
                continue;
            }
            catch (Exception exception) {
                throw new SystemException("Could not rollback across all resources");
            }
        }
        this.status = 4;
        this.resources.clear();
    }

    public final void setRollbackOnly() throws IllegalStateException, SystemException {
        this.status = 1;
    }

    public final int getStatus() throws SystemException {
        return this.status;
    }

    public final boolean delistResource(XAResource xAResource, int n) throws IllegalStateException, SystemException {
        if (n != 0x4000000) {
            // empty if block
        }
        this.resources.remove(xAResource);
        return true;
    }

    public final boolean enlistResource(XAResource xAResource) throws RollbackException, IllegalStateException, SystemException {
        this.resources.add(xAResource);
        try {
            xAResource.start(this.xid, 0);
        }
        catch (Exception exception) {
            throw new SystemException(exception.getMessage());
        }
        return true;
    }

    public final void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("Not supported");
    }

    protected final void start() throws SystemException {
        ArrayList arrayList = ExecutionContext.getResources();
        for (int i = 0; i < arrayList.size(); ++i) {
            try {
                XAResource xAResource = (XAResource)arrayList.get(i);
                this.resources.add(xAResource);
                xAResource.start(this.xid, 0);
                continue;
            }
            catch (Exception exception) {
                throw new SystemException(exception.getMessage());
            }
        }
    }
}

