/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;

public class Logger
implements Serializable {
    private static boolean initialized = false;
    private static boolean isOn = false;
    private static boolean debugCache = false;
    private static boolean useThreadId = true;
    private static int debugRefCount = 0;
    private static String connectionLog = null;
    private static boolean debugTransaction = false;
    public static PrintWriter out = null;

    public static boolean debugOn() {
        if (!initialized) {
            Logger.init();
        }
        return isOn;
    }

    public static boolean logTransactionState() {
        if (!initialized) {
            Logger.init();
        }
        return debugTransaction;
    }

    public static void setDebug(boolean bl) {
        if (!initialized) {
            Logger.init();
        }
        isOn = bl;
    }

    public static int getDebugReferenceCountLevel() {
        if (!initialized) {
            Logger.init();
        }
        return debugRefCount;
    }

    public static void setDebugReferenceCountLevel(int n) {
        if (!initialized) {
            Logger.init();
        }
        debugRefCount = n;
    }

    public static boolean getDebugCache() {
        if (!initialized) {
            Logger.init();
        }
        return debugCache;
    }

    public static void getDebugCache(boolean bl) {
        if (!initialized) {
            Logger.init();
        }
        debugCache = bl;
    }

    public static String getConnectionLog() {
        if (!initialized) {
            Logger.init();
        }
        return connectionLog;
    }

    public static void setConnectionLog(String string) {
        if (!initialized) {
            Logger.init();
        }
        connectionLog = string;
    }

    private static void init() {
        String string;
        if (initialized) {
            return;
        }
        int n = Logger.getProperty("com.intersys.debug");
        if (n == 0) {
            isOn = false;
        } else if (n > 0) {
            isOn = true;
        }
        n = Logger.getProperty("com.intersys.debugCache");
        if (n == 0) {
            debugCache = false;
        } else if (n > 0) {
            debugCache = true;
        }
        n = Logger.getProperty("com.intersys.debug.tlevel");
        if (n == 0) {
            debugTransaction = false;
        } else if (n > 0) {
            debugTransaction = true;
        }
        n = Logger.getProperty("com.intersys.debug.threads");
        if (n == 0) {
            useThreadId = false;
        } else if (n > 0) {
            useThreadId = true;
        }
        n = Logger.getProperty("com.intersys.debugReferenceCount");
        if (n >= 0) {
            debugRefCount = n;
        }
        if ((string = System.getProperty("com.intersys.debug.logfile")) != null) {
            try {
                if (useThreadId) {
                    out = new ThreadPrintWriter(new FileWriter(string), true);
                }
                out = new PrintWriter((Writer)new FileWriter(string), true);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can not open file for logging: " + string);
            }
        } else {
            out = new PrintWriter(System.out, true);
        }
        connectionLog = System.getProperty("com.intersys.debugConnection.file");
        initialized = true;
    }

    private static int getProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            if (string2.equalsIgnoreCase("true")) {
                return 1;
            }
            if (string2.equalsIgnoreCase("false")) {
                return 0;
            }
            try {
                int n = Integer.parseInt(string2);
                if (n >= 0) {
                    return n;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            throw new RuntimeException("Unable to parse value of property " + string + ": " + string2);
        }
        return -1;
    }

    public static class ThreadPrintWriter
    extends PrintWriter {
        private boolean newLine = true;

        public ThreadPrintWriter(Writer writer, boolean bl) {
            super(writer, bl);
        }

        @Override
        public synchronized void print(String string) {
            if (this.newLine) {
                super.print(Thread.currentThread().getName() + ": ");
            }
            super.print(string);
            this.newLine = false;
        }

        @Override
        public synchronized void println(String string) {
            if (this.newLine) {
                super.print(Thread.currentThread().getName() + ": ");
                this.newLine = false;
            }
            super.println(string);
            this.newLine = true;
        }
    }
}

