/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.objects.CacheException;
import com.intersys.objects.ObjectServerInfo;

public class CacheUnsupportedProtocolException
extends CacheException {
    private ObjectServerInfo mInfo;
    private String mMessage;

    public CacheUnsupportedProtocolException(ObjectServerInfo objectServerInfo) {
        super("Server does not support client protocol (" + objectServerInfo.protocolServerVersion + "/" + objectServerInfo.protocolClientVersion + ")" + "Please upgrade to a newer client.");
        this.mInfo = objectServerInfo;
    }

    public CacheUnsupportedProtocolException(ObjectServerInfo objectServerInfo, int n) {
        this.mInfo = objectServerInfo;
        switch (n) {
            case 2010: {
                this.mMessage = "This driver is only compatible with Cache Server versions 2010.1 and higher. For older versions please use 2009.1 family of drivers.";
                break;
            }
            default: {
                this.mMessage = "This driver is incompatible with server version " + this.mInfo.cacheObjectVersion;
            }
        }
    }

    @Override
    public String getMessage() {
        String string = super.getMessage();
        if (string == null) {
            string = this.mMessage;
        } else if (this.mMessage != null) {
            string = string + ". " + this.mMessage;
        }
        return string;
    }

    public ObjectServerInfo getInfo() {
        return this.mInfo;
    }
}

