/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionListener;
import com.intersys.jdbc.ObjectFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RegisteredDatabases {
    Set databases;

    public synchronized void onClose() {
        if (this.databases == null) {
            return;
        }
        Iterator iterator = this.databases.iterator();
        while (iterator.hasNext()) {
            CacheConnectionListener cacheConnectionListener = (CacheConnectionListener)iterator.next();
            iterator.remove();
            cacheConnectionListener.onConnectionClosed();
        }
        this.databases = null;
    }

    public boolean register(CacheConnectionListener cacheConnectionListener) {
        if (this.databases == null) {
            this.databases = new HashSet();
        }
        return this.databases.add(cacheConnectionListener);
    }

    public boolean unregister(CacheConnectionListener cacheConnectionListener) {
        if (this.databases == null) {
            return false;
        }
        return this.databases.remove(cacheConnectionListener);
    }

    ObjectFactory getObjectFactory(CacheConnection cacheConnection) throws SQLException {
        if (this.databases != null) {
            for (Object e : this.databases) {
                if (!(e instanceof ObjectFactory)) continue;
                return (ObjectFactory)e;
            }
        }
        return this.constructNewObjectFactory(cacheConnection);
    }

    private ObjectFactory constructNewObjectFactory(CacheConnection cacheConnection) throws SQLException {
        try {
            Class<?> clazz = Class.forName("com.intersys.objects.CacheDatabase");
            Method method = clazz.getMethod("getLightDatabase", Connection.class);
            return (ObjectFactory)method.invoke(null, cacheConnection);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("No Object Factory class is available in your classpath");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new SQLException(noSuchMethodException.getMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException.getMessage());
        }
    }
}

