/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheInputStream;
import com.intersys.jdbc.CacheOutputStream;
import com.intersys.jdbc.CacheReader;
import com.intersys.jdbc.CacheWriter;
import com.intersys.jdbc.RealStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class CacheClob
extends RealStream
implements Clob {
    CacheClob(CacheConnection cacheConnection, byte[] byArray, int n, int n2, int n3) throws SQLException {
        super(cacheConnection, null, byArray, n, n2, n3, 0);
        this.getStreamSize();
    }

    CacheClob(CacheConnection cacheConnection, String string, int n, int n2, int n3) throws SQLException {
        super(cacheConnection, string, null, n, n2, n3, 0);
        this.getSize();
    }

    CacheClob(CacheConnection cacheConnection, byte[] byArray, int n) throws SQLException {
        super(cacheConnection, null, byArray, n, 0, -1, 0);
        this.getStreamSize();
    }

    @Override
    public long length() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        return this.size;
    }

    @Override
    public synchronized String getSubString(long l, int n) throws SQLException {
        try {
            return new String(this.getByteStream(l, n), "UTF-8");
        }
        catch (Exception exception) {
            throw new SQLException(exception.getMessage());
        }
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.streamOID != null) {
            return new CacheReader(this.connection, this.streamOID, this.cursorNumber, this.sqlType, 0);
        }
        return new CacheReader(this.connection, (byte[])this.streamHandle, this.cursorNumber);
    }

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed", "08003");
        }
        if (this.streamOID != null) {
            return new CacheInputStream(this.connection, this.streamOID, this.cursorNumber, 0, this.sqlType, 0);
        }
        return new CacheInputStream(this.connection, (byte[])this.streamHandle, this.cursorNumber, 0);
    }

    @Override
    public synchronized long position(String string, long l) throws SQLException {
        return this.getPosition(string.getBytes(), l);
    }

    @Override
    public synchronized long position(Clob clob, long l) throws SQLException {
        return this.getPosition(clob.getSubString(0L, (int)clob.length()).getBytes(), l);
    }

    @Override
    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SQLException {
        int n3 = this.sendBytes(l, string.getBytes(), n, n2);
        this.getStreamSize();
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SQLException {
        return new CacheOutputStream(this, l);
    }

    @Override
    public Writer setCharacterStream(long l) throws SQLException {
        return new CacheWriter(this, l);
    }

    @Override
    public void truncate(long l) throws SQLException {
        this.truncateStream(l);
        this.getStreamSize();
    }

    @Override
    public void free() throws SQLException {
        try {
            this.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error freeing clob " + exception.getMessage(), "S1000");
        }
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        return new CacheReader(this.getSubString(l, (int)l2));
    }
}

