/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.classes.RegisteredObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.SList;
import com.intersys.objects.reflect.CacheClass;

public class PersistentWrapper
extends RegisteredObject {
    private static String CACHE_CLASS_NAME = "%Library.Persistent";

    public PersistentWrapper(CacheObject cacheObject) throws CacheException {
        super(cacheObject);
    }

    public static RegisteredObject _open(Database database, Oid oid) throws CacheException {
        CacheObject cacheObject = ((SysDatabase)database).openCacheObject(CACHE_CLASS_NAME, oid.getData());
        return (RegisteredObject)cacheObject.newJavaInstance();
    }

    public static RegisteredObject _open(Database database, Oid oid, int n) throws CacheException {
        CacheObject cacheObject = ((SysDatabase)database).openCacheObject(CACHE_CLASS_NAME, oid.getData(), n);
        return (RegisteredObject)cacheObject.newJavaInstance();
    }

    public Oid getInternalCacheOid() throws CacheException {
        return this.mInternal.getOid();
    }

    public Oid _oid() throws CacheException {
        return this.mInternal.getOid();
    }

    public Id getInternalCacheId() throws CacheException {
        return this.mInternal.getId();
    }

    public Id _id() throws CacheException {
        return this.mInternal.getId();
    }

    public CandidateKey getKey(String string) throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CandidateKey candidateKey = cacheClass.createKey(string);
        if (candidateKey == null) {
            throw new CacheException("No key with name " + string + " is defined in class " + cacheClass.getName());
        }
        candidateKey.setFromObject(this);
        return candidateKey;
    }

    public CandidateKey getBestCandidateKey() throws CacheException {
        CacheClass cacheClass = this.getCacheClass();
        CandidateKey candidateKey = cacheClass.createBestCandidateKey();
        if (candidateKey == null) {
            return null;
        }
        candidateKey.setFromObject(this);
        return candidateKey;
    }

    public int save() throws CacheException {
        boolean bl = !this.getDatabase().isLightConnection();
        return this.save(bl);
    }

    public int save(boolean bl) throws CacheException {
        return this.mInternal.save(bl);
    }

    public int _save() throws CacheException {
        return this.save();
    }

    public static Boolean _exists(Database database, Oid oid) throws CacheException {
        return new Boolean(PersistentWrapper.exists(database, oid));
    }

    public static boolean exists(Database database, Oid oid) throws CacheException {
        return ((SysDatabase)database).existsObject(oid);
    }

    protected static boolean exists(Database database, Oid oid, String string) throws CacheException {
        String string2 = oid.getClassName();
        if (string2 != null && !string2.equals("")) {
            return ((SysDatabase)database).existsObject(oid);
        }
        oid = new Oid(oid.getId(), string);
        return ((SysDatabase)database).existsObject(oid);
    }

    public static void _delete(Database database, Oid oid) throws CacheException {
        PersistentWrapper.delete(database, oid);
    }

    public static void delete(Database database, Oid oid) throws CacheException {
        ((SysDatabase)database).deleteObject(oid);
    }

    public void delete() throws CacheException {
        this.mInternal.delete();
    }

    public static void _delete(Database database, Oid oid, Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(oid), new Dataholder(n)};
        Dataholder dataholder = ((SysDatabase)database).runClassMethod(CACHE_CLASS_NAME, "%Delete", dataholderArray, 0);
        database.parseStatus(dataholder);
    }

    public void _downgradeConcurrency(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%DowngradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _downgradeConcurrency(int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%DowngradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _upgradeConcurrency(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%UpgradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _upgradeConcurrency(int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%UpgradeConcurrency", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public void _reload() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = this.mInternal.runInstanceMethod("%Reload", dataholderArray, 0);
        this.getDatabase().parseStatus(dataholder);
    }

    public static void _buildIndices(Database database) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        Dataholder dataholder = ((SysDatabase)database).runClassMethod(CACHE_CLASS_NAME, "%BuildIndices", dataholderArray, 0);
        database.parseStatus(dataholder);
    }

    public static void _buildIndices(Database database, SList sList) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(sList)};
        Dataholder dataholder = ((SysDatabase)database).runClassMethod(CACHE_CLASS_NAME, "%BuildIndices", dataholderArray, 0);
        database.parseStatus(dataholder);
    }

    public Integer JournalObject(Integer n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("JournalObject", dataholderArray, 0);
        return dataholder.getInteger();
    }

    public Integer JournalObject(Integer n, Integer n2) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(n), new Dataholder(n2)};
        Dataholder dataholder = this.mInternal.runInstanceMethod("JournalObject", dataholderArray, 0);
        return dataholder.getInteger();
    }

    public static String getCacheClassName() {
        return CACHE_CLASS_NAME;
    }
}

