/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.classes;

import com.intersys.cache.CacheObject;
import com.intersys.classes.ArrayBuffer;
import com.intersys.classes.DataConverter;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.RegisteredObject;
import com.intersys.classes.SysAbstractArray;
import com.intersys.objects.CacheCollectionException;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.StringHolder;
import com.intersys.objects.SystemError;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractCacheArray
extends AbstractMap
implements ObjectHandle {
    protected SysAbstractArray mInternal;
    private ArrayBuffer mBuffer = null;
    private transient Set entrySet = null;
    private transient Set keySet = null;

    protected abstract Object keyExternal2internal(Object var1);

    protected abstract Object keyInternal2external(Object var1);

    protected abstract Object valueExternal2internal(Object var1);

    protected abstract Object valueInternal2external(Object var1);

    @Override
    public int size() {
        try {
            return this._count();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public boolean containsValue(Object object) {
        try {
            return this._find(this.valueExternal2internal(object)) != null;
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public boolean containsKey(Object object) {
        try {
            return this._isDefined(this.keyExternal2internal(object));
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object get(Object object) {
        try {
            Object object2 = this._getAt((String)this.keyExternal2internal(object));
            return object2;
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object put(Object object, Object object2) {
        try {
            Object object3 = this.get(object);
            this._setAt(this.keyExternal2internal(object), this.valueExternal2internal(object2));
            return object3;
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public void putAll(Map map) {
        try {
            for (Map.Entry entry : map.entrySet()) {
                this._setAt(this.keyExternal2internal(entry.getKey()), this.valueExternal2internal(entry.getValue()));
            }
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Object remove(Object object) {
        try {
            Object object2 = this._removeAt(this.keyExternal2internal(object));
            if (object2 != null) {
                return this.valueInternal2external(object2);
            }
            return null;
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public void clear() {
        try {
            this._clear();
        }
        catch (CacheException cacheException) {
            throw new CacheCollectionException(cacheException);
        }
    }

    @Override
    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public Integer _count() throws CacheException {
        if (this.mBuffer != null) {
            return new Integer(this.mBuffer.count());
        }
        return this.getInternal()._count();
    }

    public Object _first() throws CacheException {
        return DataConverter.string2object(this.getInternal()._next(null));
    }

    public Object _next(Object object) throws CacheException {
        if (object != null && object.equals("")) {
            object = null;
        }
        if (this.mBuffer != null) {
            return DataConverter.string2object(this.mBuffer._next((String)object));
        }
        return DataConverter.string2object(this.getInternal()._next((String)object));
    }

    public Object _previous(Object object) throws CacheException {
        if (object != null && object.equals("")) {
            object = null;
        }
        if (this.mBuffer != null) {
            return DataConverter.string2object(this.mBuffer._previous((String)object));
        }
        return DataConverter.string2object(this.getInternal()._previous((String)object));
    }

    public Object _getFirst(StringHolder stringHolder) throws CacheException {
        return this._getNext(stringHolder);
    }

    public Object _getNext(StringHolder stringHolder) throws CacheException {
        if (stringHolder.value != null && stringHolder.value.equals("")) {
            stringHolder.value = null;
        }
        if (this.mBuffer != null) {
            return this.mBuffer._getNext(stringHolder);
        }
        return this.getInternal()._getNext(stringHolder);
    }

    public Object _getPrevious(StringHolder stringHolder) throws CacheException {
        if (stringHolder.value != null && stringHolder.value.equals("")) {
            stringHolder.value = null;
        }
        if (this.mBuffer != null) {
            return this.mBuffer._getPrevious(stringHolder);
        }
        return this.getInternal()._getPrevious(stringHolder);
    }

    public Object _removeAt(Object object) throws CacheException {
        this.invalidateCache();
        return this.getInternal()._removeAt((String)object);
    }

    public abstract Object _find(Object var1) throws CacheException;

    public Boolean _isDefined(Object object) throws CacheException {
        if (this.mBuffer != null) {
            return this.mBuffer._isDefined((String)object);
        }
        return this.getInternal()._isDefined((String)object);
    }

    public Object _getAt(String string) throws CacheException {
        Object object = this.mBuffer != null ? this.mBuffer._getAt(string) : this.getInternal()._getAt(string);
        return this.valueInternal2external(object);
    }

    public abstract void _setAt(Object var1, Object var2) throws CacheException;

    public void _clear() throws CacheException {
        this.invalidateCache();
        this.getInternal()._clear();
    }

    private SysAbstractArray getInternal() throws CacheException {
        return this.mInternal;
    }

    @Override
    public CacheObject getProxy() {
        return this.mInternal.getProxy();
    }

    public RegisteredObject getRegisteredObject() throws CacheException {
        return this.mInternal;
    }

    public int getBufferSize() {
        if (this.mBuffer != null) {
            return this.mBuffer.getBufferSize();
        }
        return 0;
    }

    public static int getDefaultBufferSize() {
        return ArrayBuffer.getDefaultBufferSize();
    }

    public static void setDefaultBufferSize(int n) {
        ArrayBuffer.setDefaultBufferSize(n);
    }

    public boolean getAutoLoad() throws CacheException {
        if (this.mBuffer != null) {
            return this.mBuffer.getAutoLoad();
        }
        throw new CacheException("This List does not support bufferization.");
    }

    public void setAutoLoad(boolean bl) throws CacheException {
        if (this.mBuffer != null) {
            this.mBuffer.setAutoLoad(bl);
        }
        throw new CacheException("This List does not support bufferization.");
    }

    protected void setBuffer(ArrayBuffer arrayBuffer) throws CacheException {
        if (this.mBuffer != null) {
            throw new SystemError("Buffer already set.");
        }
        this.mBuffer = arrayBuffer;
    }

    public void close() throws CacheException {
        if (this.mBuffer != null) {
            this.mBuffer.close(true);
        }
    }

    @Override
    public int getOref() throws ObjectClosedException {
        return this.mInternal.getOref();
    }

    @Override
    public final Object getZRef() throws CacheException {
        return this.mInternal.getZRef();
    }

    @Override
    public Database getDatabase() {
        return this.mInternal.getDatabase();
    }

    @Override
    public void _close() throws CacheException {
        this.close();
    }

    @Override
    public String _className() throws CacheException {
        return this.mInternal._className();
    }

    @Override
    public String _className(Boolean bl) throws CacheException {
        return this.mInternal._className(bl);
    }

    @Override
    public Integer _isModified() throws CacheException {
        return this.mInternal._isModified();
    }

    @Override
    public void _normalizeObject() throws CacheException {
        this.mInternal._normalizeObject();
    }

    @Override
    public String _packageName() throws CacheException {
        return this.mInternal._packageName();
    }

    @Override
    public void _validateObject() throws CacheException {
        this.mInternal._validateObject();
    }

    @Override
    public void _validateObject(Integer n) throws CacheException {
        this.mInternal._validateObject(n);
    }

    protected void invalidateCache() throws CacheException {
        if (this.mBuffer != null) {
            this.mBuffer.invalidateCache(true);
        }
    }

    @Override
    public String toString() {
        return this.mInternal.toString() + ": " + super.toString();
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            try {
                return new EntryIterator();
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = AbstractCacheArray.this.get(entry.getKey());
            if (object2 == null) {
                return false;
            }
            return object2.equals(entry.getValue());
        }

        @Override
        public boolean remove(Object object) {
            if (!this.contains(object)) {
                return false;
            }
            Object object2 = AbstractCacheArray.this.remove(((Map.Entry)object).getKey());
            return object2 != null;
        }

        @Override
        public int size() {
            return AbstractCacheArray.this.size();
        }

        @Override
        public void clear() {
            AbstractCacheArray.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        @Override
        public Iterator iterator() {
            try {
                return new KeyIterator();
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }

        @Override
        public boolean contains(Object object) {
            return AbstractCacheArray.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            Object object2 = AbstractCacheArray.this.remove(object);
            return object2 != null;
        }

        @Override
        public int size() {
            return AbstractCacheArray.this.size();
        }

        @Override
        public void clear() {
            AbstractCacheArray.this.clear();
        }
    }

    private class EntryIterator
    implements Iterator {
        private StringHolder mKey = new StringHolder("");
        private Object mValue;
        private String mReturnedKey;

        EntryIterator() throws CacheException {
            this.mValue = AbstractCacheArray.this._getFirst(this.mKey);
            this.mReturnedKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.mKey.value != null && !this.mKey.value.equals("");
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Entry entry = new Entry(AbstractCacheArray.this.keyInternal2external(this.mKey.value), AbstractCacheArray.this.valueInternal2external(this.mValue));
                this.mReturnedKey = this.mKey.value;
                this.mValue = AbstractCacheArray.this._getNext(this.mKey);
                return entry;
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }

        @Override
        public void remove() {
            if (this.mReturnedKey == null) {
                throw new IllegalStateException();
            }
            try {
                AbstractCacheArray.this._removeAt(this.mReturnedKey);
                this.mReturnedKey = null;
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }
    }

    private class KeyIterator
    implements Iterator {
        private Object mKey;
        private String mReturnedKey;

        KeyIterator() throws CacheException {
            this.mKey = AbstractCacheArray.this._first();
            this.mReturnedKey = null;
        }

        @Override
        public boolean hasNext() {
            return this.mKey != null && !this.mKey.equals("");
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Object object = AbstractCacheArray.this.keyInternal2external(this.mKey);
                this.mReturnedKey = (String)this.mKey;
                this.mKey = AbstractCacheArray.this._next(this.mKey);
                return object;
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }

        @Override
        public void remove() {
            if (this.mReturnedKey == null) {
                throw new IllegalStateException();
            }
            try {
                AbstractCacheArray.this._removeAt(this.mReturnedKey);
                this.mReturnedKey = null;
            }
            catch (CacheException cacheException) {
                throw new CacheCollectionException(cacheException);
            }
        }
    }

    private static class Entry
    implements Map.Entry {
        private final Object key;
        private Object value;

        Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return (this.key == null ? entry.getKey() == null : this.key.equals(entry.getKey())) && (this.value == null ? entry.getValue() == null : this.value.equals(entry.getValue()));
        }

        @Override
        public int hashCode() {
            int n = this.key == null ? 0 : this.key.hashCode();
            int n2 = this.value == null ? 0 : this.value.hashCode();
            return n ^ n2;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

