/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.util;

import com.intersys.cache.util.ConsoleOutputStream;
import com.intersys.cache.util.StateDump;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintStream;

public class Console
extends Frame {
    private static Console dw;
    private static String defaultTitle;
    private TextArea ta = new TextArea();
    private static PrintStream out;
    private static PrintStream err;
    private static Object hookLock;

    public static void setDefaultTitle(String string) {
        defaultTitle = string;
    }

    public Console(String string) {
        this(500, 400, string);
    }

    public Console(int n, int n2, String string) {
        super(string);
        this.setLayout(new BorderLayout());
        this.add("Center", this.ta);
        this.setSize(n, n2);
        this.setVisible(true);
        this.ta.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyChar()) {
                    case 'd': {
                        StateDump.dump();
                        break;
                    }
                    case 'c': {
                        Console.this.ta.setText("");
                    }
                }
                keyEvent.consume();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
    }

    public static void println(int n) {
        Console.println("" + n);
    }

    public static void println(long l) {
        Console.println("" + l);
    }

    public static void println(double d) {
        Console.println("" + d);
    }

    public static void println(String string) {
        Console.println((Object)string);
    }

    public static void println(Object object) {
        if (dw == null) {
            dw = new Console(defaultTitle);
        }
        dw.showString(object.toString() + "\n");
    }

    public static void print(int n) {
        Console.print("" + n);
    }

    public static void print(long l) {
        Console.print("" + l);
    }

    public static void print(double d) {
        Console.print("" + d);
    }

    public static void print(String string) {
        Console.print((Object)string);
    }

    public static void print(Object object) {
        if (dw == null) {
            dw = new Console(defaultTitle);
        }
        dw.showString(object.toString());
    }

    private void showString(Object object) {
        this.ta.append(object.toString());
    }

    private void closeit() {
        Console.unhookStandards();
        this.setVisible(false);
    }

    public static void close() {
        if (dw != null) {
            dw.closeit();
            dw = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hookStandards() {
        Object object = hookLock;
        synchronized (object) {
            if (out != null) {
                return;
            }
            out = System.out;
            err = System.err;
            PrintStream printStream = new PrintStream(new ConsoleOutputStream());
            System.setOut(printStream);
            System.setErr(printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unhookStandards() {
        Object object = hookLock;
        synchronized (object) {
            if (out == null) {
                return;
            }
            System.setOut(out);
            System.setErr(err);
            out = null;
            err = null;
        }
    }

    static {
        defaultTitle = "";
        hookLock = new Object();
    }
}

