/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.SerializationSupport;
import com.intersys.cache.jbind.UnsetProperties;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Serializer
extends SerializationSupport {
    private static final int OREF = -1;
    private boolean mIsUnicode;
    private String mServerLocale;

    public Serializer(boolean bl, String string, PrintWriter printWriter) {
        super(null, printWriter);
        this.mIsUnicode = bl;
        this.mServerLocale = string;
    }

    public void marshall(Object object, Object object2, Map map) throws Exception {
        UnsetProperties unsetProperties = this.processJavaObject(object, map);
        unsetProperties.makeSetZList(object2, null);
    }

    private UnsetProperties processJavaObject(Object object, Map map) throws Exception {
        Class<?> clazz = object.getClass();
        if (this.logger != null) {
            this.logger.println("Serializing <" + clazz.getName() + ">.");
        }
        Map map2 = this.getMetaData(map, clazz);
        UnsetProperties unsetProperties = new UnsetProperties();
        try {
            int n;
            Field[] fieldArray = clazz.getFields();
            HashSet<String> hashSet = new HashSet<String>();
            for (n = 0; n < fieldArray.length; ++n) {
                hashSet.add(fieldArray[n].getName());
            }
            for (n = 0; n < fieldArray.length; ++n) {
                Field field = fieldArray[n];
                if (this.logger != null) {
                    this.logger.println("Getting field " + field.getName());
                }
                field.setAccessible(true);
                Object object2 = field.get(object);
                this.setValue(unsetProperties, field, map2, hashSet, object2);
            }
            if (this.logger != null) {
                this.logger.println("Done <" + clazz.getName() + ">.");
            }
        }
        catch (Exception exception) {
            if (this.logger != null) {
                exception.printStackTrace(this.logger);
            }
            throw new SQLException("Failed to get data from object of class " + clazz.getName() + ": " + exception.getMessage());
        }
        return unsetProperties;
    }

    private void setValue(UnsetProperties unsetProperties, Field field, Map map, Set set, Object object) throws Exception {
        String string = field.getName();
        String string2 = this.mNameMapper.cacheFieldNameFor(field, set);
        SerializationSupport.Metadata metadata = (SerializationSupport.Metadata)map.get(string2);
        if (metadata == null) {
            throw new Exception("No metadata for field " + string + '/' + string2);
        }
        Dataholder dataholder = Dataholder.create(object);
        unsetProperties.setProperty(-1, metadata.ii, metadata.isObj, string, dataholder);
    }
}

