/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.AbstractCacheObject;
import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.ExternalObjectProvider;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.JBindCacheObject;
import com.intersys.classes.AbstractCacheArray;
import com.intersys.classes.AbstractCacheList;
import com.intersys.classes.BinaryStream;
import com.intersys.classes.CacheRootObject;
import com.intersys.classes.CharacterStream;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.DatabaseUtilities;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.Oid;
import com.intersys.objects.ReferenceCountingException;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.jalapeno.runtime.DetachedObjectsManager;
import com.jalapeno.runtime.ObjectFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public abstract class DatabaseWithReferenceMap
extends ExternalObjectProvider
implements SysDatabase,
CacheServerSensitive {
    private static final String SYSTEM_CLASS = "%Library.Persistent";
    protected static final int TRANSACTION_START = 1;
    protected static final int TRANSACTION_COMMIT = 2;
    protected static final int TRANSACTION_ROLLBACK = 3;
    protected static final int TRANSACTION_QUERY = 4;
    private Map mObjectMap = Collections.synchronizedMap(new HashMap());
    private Map mDiscardedMap = Collections.synchronizedMap(new TreeMap());
    private Map mClassMap = Collections.synchronizedMap(new TreeMap());
    private Map mTableToClassMap = Collections.synchronizedMap(new TreeMap());
    private Map mReverseClassMap = Collections.synchronizedMap(new TreeMap());
    private ReferenceQueue mDiscardedQueue;
    Exception mDelayedException = null;
    private ClassLoader mClassLoader = null;
    protected ObjectServerInfo mInfo = new ObjectServerInfo();
    protected String mProcess;
    private DetachedObjectsManager mDetachedbjectsManager;
    private boolean mInAttachMode = false;
    private boolean mIsOpen = true;

    protected DatabaseWithReferenceMap() {
        this.mDiscardedQueue = new ReferenceQueue();
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray) throws CacheException {
        return this.openCacheObject(string, byArray, -1, -1);
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray, int n) throws CacheException {
        return this.openCacheObject(string, byArray, n, -1);
    }

    @Override
    public CacheObject openCacheObject(String string, byte[] byArray, int n, int n2) throws CacheException {
        CacheClass cacheClass = this.getCacheClass(string);
        if (cacheClass.isSerial()) {
            return this.deserializeObject(string, byArray);
        }
        Oid oid = new Oid(byArray);
        if (oid.getClassName().length() == 0) {
            String string2 = oid.getId().toString();
            oid = new Oid(string2, string);
        }
        return this.openCacheObject(oid, n, n2);
    }

    public CacheObject openCacheObject(Oid oid, int n, int n2) throws CacheException {
        return this.openObjectByOID(oid, n, n2);
    }

    @Override
    public CacheObject openCacheObject(String string, String string2) throws CacheException {
        return this.openCacheObject(string, string2, -1, -1);
    }

    @Override
    public CacheObject openCacheObject(String string, String string2, int n) throws CacheException {
        return this.openCacheObject(string, string2, n, -1);
    }

    @Override
    public CacheObject openCacheObject(String string, String string2, int n, int n2) throws CacheException {
        return this.openObjectByID(string, string2, n, n2);
    }

    @Override
    public synchronized CacheObject getCacheObjectUnsafe(String string, int n) throws CacheException {
        CacheObject cacheObject = this.findInMap(n);
        if (cacheObject == null) {
            cacheObject = this.createCacheObjectByOref(string, n);
            cacheObject.increaseReferenceCount();
        } else if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println(this.mProcess + ": Oref " + n + " was found in map");
        }
        ((AbstractCacheObject)cacheObject).lock();
        return cacheObject;
    }

    @Override
    public Dataholder runClassMethod(String string, String string2, Dataholder[] dataholderArray, int n) throws CacheException {
        int[] nArray = new int[]{};
        Dataholder[] dataholderArray2 = this.runClassMethod(string, string2, nArray, dataholderArray, n);
        return dataholderArray2[0];
    }

    @Override
    public synchronized void setCacheObjectReadDirty(Oid oid) throws CacheException {
        Persistent persistent = (Persistent)Persistent._open(this, oid);
        if (persistent != null) {
            persistent.getProxy().setStateReadDirty();
        }
    }

    @Override
    public CacheInputStream getInputStream(int n) throws CacheException {
        if (n == 0) {
            return null;
        }
        String string = BinaryStream.getCacheClassName();
        CacheObject cacheObject = this.getCacheObjectUnsafe(string, n);
        BinaryStream binaryStream = (BinaryStream)cacheObject.newJavaInstance();
        return new CacheInputStream(binaryStream);
    }

    @Override
    public CacheInputStream getInputStream(CacheObject cacheObject) throws CacheException {
        if (cacheObject == null) {
            return null;
        }
        BinaryStream binaryStream = (BinaryStream)cacheObject.newJavaInstance();
        return new CacheInputStream(binaryStream);
    }

    @Override
    public CacheReader getReader(int n) throws CacheException {
        if (n == 0) {
            return null;
        }
        String string = CharacterStream.getCacheClassName();
        CacheObject cacheObject = this.getCacheObjectUnsafe(string, n);
        CharacterStream characterStream = (CharacterStream)cacheObject.newJavaInstance();
        return new CacheReader(characterStream);
    }

    @Override
    public CacheReader getReader(CacheObject cacheObject) throws CacheException {
        if (cacheObject == null) {
            return null;
        }
        CharacterStream characterStream = (CharacterStream)cacheObject.newJavaInstance();
        return new CacheReader(characterStream);
    }

    @Override
    public CacheOutputStream getOutputStream(int n) throws CacheException {
        if (n == 0) {
            return null;
        }
        String string = BinaryStream.getCacheClassName();
        CacheObject cacheObject = this.getCacheObjectUnsafe(string, n);
        BinaryStream binaryStream = (BinaryStream)cacheObject.newJavaInstance();
        return new CacheOutputStream(binaryStream);
    }

    @Override
    public CacheOutputStream getOutputStream(CacheObject cacheObject) throws CacheException {
        if (cacheObject == null) {
            return null;
        }
        BinaryStream binaryStream = (BinaryStream)cacheObject.newJavaInstance();
        return new CacheOutputStream(binaryStream);
    }

    @Override
    public CacheWriter getWriter(int n) throws CacheException {
        if (n == 0) {
            return null;
        }
        String string = CharacterStream.getCacheClassName();
        CacheObject cacheObject = this.getCacheObjectUnsafe(string, n);
        CharacterStream characterStream = (CharacterStream)cacheObject.newJavaInstance();
        return new CacheWriter(characterStream);
    }

    @Override
    public CacheWriter getWriter(CacheObject cacheObject) throws CacheException {
        if (cacheObject == null) {
            return null;
        }
        CharacterStream characterStream = (CharacterStream)cacheObject.newJavaInstance();
        return new CacheWriter(characterStream);
    }

    @Override
    public synchronized DetachedObjectsManager getDetachedObjectsManager() {
        if (this.mDetachedbjectsManager == null) {
            this.mDetachedbjectsManager = DetachedObjectsManager.createDetachedObjectsManager(this);
            this.registerSensitiveObject(this);
        }
        return this.mDetachedbjectsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void closeDiscardedObjects(boolean bl) throws CacheException {
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println(this.mProcess + ": Clearing weak references.");
        }
        this.checkQueue();
        Iterator iterator = this.mDiscardedMap.values().iterator();
        while (iterator.hasNext()) {
            Object t;
            WeakReferenceToOref weakReferenceToOref = (WeakReferenceToOref)iterator.next();
            if (!bl && weakReferenceToOref.isLocked() || (t = weakReferenceToOref.get()) == null) continue;
            AbstractCacheObject abstractCacheObject = (AbstractCacheObject)t;
            if (!bl && abstractCacheObject.isLocked()) continue;
            AbstractCacheObject abstractCacheObject2 = abstractCacheObject;
            synchronized (abstractCacheObject2) {
                if (!abstractCacheObject.isClosed()) {
                    abstractCacheObject.close();
                    abstractCacheObject.setOrefClosed();
                }
            }
            weakReferenceToOref.clear();
            if (bl) continue;
            iterator.remove();
        }
        if (bl) {
            this.mDiscardedMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void closeAllObjects() throws CacheException {
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.clear();
        }
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println(this.mProcess + ": Clearing strong references.");
        }
        Iterator iterator = this.mObjectMap.values().iterator();
        while (iterator.hasNext()) {
            AbstractCacheObject abstractCacheObject;
            AbstractCacheObject abstractCacheObject2 = abstractCacheObject = (AbstractCacheObject)iterator.next();
            synchronized (abstractCacheObject2) {
                if (!abstractCacheObject.isClosed()) {
                    abstractCacheObject.close();
                    abstractCacheObject.sendEvent(300);
                    abstractCacheObject.setOrefClosed();
                }
            }
        }
        this.mObjectMap.clear();
        this.closeDiscardedObjects(true);
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println(this.mProcess + ": Done clearing references.");
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return this.mIsOpen && !this.isLowLevelConnectionClosed();
        }
        catch (CacheException cacheException) {
            return false;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!this.getClass().equals(object.getClass())) {
            return false;
        }
        try {
            SysDatabase sysDatabase = (SysDatabase)object;
            return this.mProcess.equals(sysDatabase.getProcessNumber()) && this.getConnectionString().equals(sysDatabase.getConnectionString());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public synchronized void closeObject(int n) throws CacheException {
        AbstractCacheObject abstractCacheObject = this.findInMap(n);
        abstractCacheObject.forceClose();
    }

    @Override
    public synchronized void releaseObject(Object object) throws CacheException {
        if (object instanceof CacheRootObject) {
            ((CacheRootObject)object).release();
        } else if (object instanceof AbstractCacheList) {
            ((AbstractCacheList)object).getRegisteredObject().release();
        } else if (object instanceof AbstractCacheArray) {
            ((AbstractCacheArray)object).getRegisteredObject().release();
        } else if (object instanceof ObjectHandle) {
            CacheObject cacheObject = ((ObjectHandle)object).getProxy();
            if (cacheObject == null) {
                throw new ObjectClosedException(null, "Object has been already released");
            }
            if (cacheObject.isClosed()) {
                return;
            }
            ((AbstractCacheObject)cacheObject).decreaseCount();
        } else if (!(object instanceof Oid)) {
            throw new CacheException("Release is not defined for " + object.getClass().getName());
        }
    }

    public Map close(boolean bl) throws CacheException {
        if (!this.isEmpty() && !bl) {
            throw new CacheServerException("Objects still active: " + this.mapSize());
        }
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.close();
        }
        try {
            this.closeAllObjects(false);
        }
        catch (ReferenceCountingException referenceCountingException) {
            this.mDelayedException = referenceCountingException;
        }
        Map map = this.forceClose();
        this.mIsOpen = false;
        return map;
    }

    @Override
    public Map close() throws CacheException {
        return this.close(true);
    }

    public void checkDelayedException() throws Exception {
        if (this.mDelayedException != null) {
            throw this.mDelayedException;
        }
    }

    @Override
    public int getNumberOfOpenObjects() {
        return this.mObjectMap.size();
    }

    @Override
    public ObjectServerInfo getServerInfo() {
        try {
            return (ObjectServerInfo)this.mInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException("Unexpected error");
        }
    }

    public boolean isInMap(int n) {
        Integer n2 = new Integer(n);
        return this.mObjectMap.containsKey(n2) || this.mDiscardedMap.containsKey(n2);
    }

    public boolean isObjectAlive(int n) {
        Integer n2 = new Integer(n);
        return this.mObjectMap.containsKey(n2);
    }

    @Override
    public boolean ensureInMap(int n, String string) throws CacheException {
        AbstractCacheObject abstractCacheObject = (AbstractCacheObject)this.onGetFromServer(n, string).getMe();
        if (abstractCacheObject == null) {
            return false;
        }
        abstractCacheObject.increaseCount();
        if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println(this.mProcess + ": Oref " + n + " was locked in map");
            abstractCacheObject.assertNotClosed(true);
        }
        return true;
    }

    public void releaseEnsuredFromMap(int n) throws CacheException {
        if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println(this.mProcess + ": Oref " + n + " was unlocked in map");
            AbstractCacheObject abstractCacheObject = this.findInMap(n);
            if (abstractCacheObject != null) {
                abstractCacheObject.assertNotClosed(false);
            } else {
                Logger.out.println(this.mProcess + ": Attempt to release non-existing " + " object (probably forcibly closed) " + n);
            }
        }
        this.releaseFromMap(n);
    }

    @Override
    public void releaseFromMap(int n) throws CacheException {
        AbstractCacheObject abstractCacheObject = this.findInMap(n);
        if (abstractCacheObject == null) {
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": Attempt to release non-existing " + " object (probably forcibly closed) " + n);
            }
            return;
        }
        abstractCacheObject.decreaseCount();
        if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println(this.mProcess + ": Oref " + n + " was released from map");
        }
    }

    @Override
    public void addClass(CacheClass cacheClass, String string) throws CacheException {
        this.mClassMap.put(cacheClass.getName(), cacheClass);
        String string2 = cacheClass.getFullSQLTableName();
        if (string2 != null) {
            this.mTableToClassMap.put(string2, cacheClass);
        }
        if (string != null) {
            this.mReverseClassMap.put(string, cacheClass.getName());
        }
    }

    @Override
    public void registerClass(String string, CacheClass cacheClass) {
        this.mClassMap.put(string, cacheClass);
    }

    @Override
    public void removeClass(CacheClass cacheClass) {
        this.mClassMap.remove(cacheClass.getName());
    }

    @Override
    public void removeClass(String string) {
        this.mClassMap.remove(string);
    }

    public void closeAllClasses() {
        this.mClassMap.clear();
    }

    @Override
    public CacheClass getCacheClassIfLoaded(String string) throws CacheException {
        if (string == null) {
            return null;
        }
        return (CacheClass)this.mClassMap.get(string);
    }

    public CacheClass getCacheClassIfLoadedByTable(String string) throws CacheException {
        if (string == null) {
            return null;
        }
        return (CacheClass)this.mTableToClassMap.get(string);
    }

    @Override
    public String getCacheClassName(String string) throws CacheException {
        return (String)this.mReverseClassMap.get(string);
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mClassLoader != null) {
            return this.mClassLoader;
        }
        return this.getClass().getClassLoader();
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        if (Thread.currentThread().getContextClassLoader() != this.mClassLoader && this.mClassLoader != classLoader) {
            this.mClassMap.clear();
        }
        this.mClassLoader = classLoader;
    }

    @Override
    public DatabaseUtilities utilities() {
        return new DatabaseUtilities(this);
    }

    @Override
    public void deleteObject(Oid oid) throws CacheException {
        Dataholder dataholder = this.deleteObjectByOID(oid.getData(), -1);
        this.parseStatus(dataholder);
    }

    @Override
    public void deleteObject(Oid oid, int n) throws CacheException {
        Dataholder dataholder = this.deleteObjectByOID(oid.getData(), n);
        this.parseStatus(dataholder);
    }

    @Override
    public void deleteObject(String string, Id id) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(id.toString())};
        Dataholder dataholder = this.runClassMethod(string, "%DeleteId", dataholderArray, 0);
        this.parseStatus(dataholder);
    }

    @Override
    public void deleteObject(String string, Id id, int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(id.toString()), new Dataholder(n)};
        Dataholder dataholder = this.runClassMethod(string, "%DeleteId", dataholderArray, 0);
        this.parseStatus(dataholder);
    }

    @Override
    public boolean existsObject(Oid oid) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(oid)};
        String string = oid.getClassName();
        if (string == null || string.length() == 0) {
            string = SYSTEM_CLASS;
        }
        Dataholder dataholder = this.runClassMethod(string, "%Exists", dataholderArray, 0);
        return dataholder.getBooleanValue();
    }

    @Override
    public boolean existsObject(String string, Id id) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(id.toString())};
        Dataholder dataholder = this.runClassMethod(string, "%ExistsId", dataholderArray, 0);
        return dataholder.getBooleanValue();
    }

    @Override
    public String getProcessNumber() {
        return this.mProcess;
    }

    protected synchronized void addObjectToMap(int n, CacheObject cacheObject) throws ReferenceCountingException {
        Integer n2 = new Integer(n);
        if (this.mObjectMap.containsKey(n2)) {
            String string = "Attempt to add to object map already counted object <" + n + "><" + cacheObject + ">";
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": ERROR: " + string);
            }
            throw new ReferenceCountingException(string);
        }
        this.mObjectMap.put(n2, cacheObject);
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println(this.mProcess + ": Added to map: oref = " + n);
        }
    }

    protected synchronized CacheObject onGetFromServer(int n, String string) throws CacheException {
        CacheObject cacheObject = this.findInMap(n);
        if (cacheObject == null) {
            cacheObject = this.createCacheObjectByOref(string, n);
            if (string != null && string.length() != 0) {
                cacheObject.setCacheClass(this.getCacheClass(string));
            }
        } else if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println(this.mProcess + ": Oref " + n + " was found in map");
        }
        ((AbstractCacheObject)cacheObject).lock();
        cacheObject.increaseReferenceCount();
        return cacheObject;
    }

    protected AbstractCacheObject findInMap(int n) throws SystemError {
        Integer n2 = new Integer(n);
        Object object = this.mObjectMap.get(n2);
        if (object == null) {
            object = this.getFromDiscarded(n2);
        }
        try {
            return (AbstractCacheObject)object;
        }
        catch (ClassCastException classCastException) {
            throw new SystemError(classCastException, "Wrong type of object in map");
        }
    }

    private synchronized Object getFromDiscarded(Integer n) throws SystemError {
        Object var2_2 = null;
        WeakReferenceToOref weakReferenceToOref = (WeakReferenceToOref)this.mDiscardedMap.get(n);
        if (weakReferenceToOref != null) {
            if (weakReferenceToOref.key != n) {
                String string = "Inconsistent key in discarded map";
                if (Logger.getDebugReferenceCountLevel() > 0) {
                    Logger.out.println(this.mProcess + ": ERROR: " + string);
                }
                throw new SystemError(string);
            }
            var2_2 = weakReferenceToOref.get();
            if (var2_2 == null && Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": WARN: Discarded object for " + n + " is set to null");
            }
            weakReferenceToOref.lock();
        }
        return var2_2;
    }

    protected synchronized Object removeObjectFromMap(int n) throws SystemError {
        this.removeFromCache(n);
        Integer n2 = new Integer(n);
        Object v = this.mObjectMap.remove(n2);
        if (v == null) {
            throw new SystemError("Attempt to remove non-existing object with oref " + n);
        }
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.print(this.mProcess + ": Removed from map: oref = " + n);
            if (Logger.getDebugReferenceCountLevel() > 2) {
                Logger.out.println(": " + v.toString());
            } else {
                Logger.out.println();
            }
        }
        return v;
    }

    protected boolean isEmpty() {
        return this.mObjectMap.isEmpty();
    }

    public int mapSize() {
        return this.mObjectMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void objectDiscarded(int n) throws CacheException {
        Object object;
        this.checkQueue();
        Object object2 = this.removeObjectFromMap(n);
        if (Logger.getDebugReferenceCountLevel() > 1) {
            object = Logger.getDebugReferenceCountLevel() > 2 ? ": " + object2.toString() : "";
            Logger.out.println(this.mProcess + ": Object " + n + (String)object + " is being discarded");
        }
        object = new WeakReferenceToOref(object2, this.mDiscardedQueue);
        Object object3 = object2;
        synchronized (object3) {
            if (((AbstractCacheObject)object2).isLocked()) {
                ((WeakReferenceToOref)object).lock();
            }
        }
        object3 = new Integer(n);
        this.checkQueue();
        Object object4 = this.getFromDiscarded((Integer)object3);
        if (object4 != null) {
            String string = "Object " + n + " was already discarded";
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": ERROR: " + string);
            }
            throw new SystemError(string);
        }
        this.mDiscardedMap.put(object3, object);
        if (Logger.getDebugReferenceCountLevel() > 2) {
            Logger.out.println(this.mProcess + ": Reference to " + n + ": " + ((Reference)object).get().toString());
        }
    }

    synchronized void objectReinstated(int n, CacheObject cacheObject) throws CacheException {
        this.checkQueue();
        Integer n2 = new Integer(n);
        WeakReference weakReference = (WeakReference)this.mDiscardedMap.remove(n2);
        Object object = null;
        if (weakReference == null) {
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": WARN: Discarded object " + n + " was not found");
            }
        } else {
            if (!((WeakReferenceToOref)weakReference).isLocked()) {
                throw new SystemError("Reinstated weak ref is not locked: " + weakReference);
            }
            object = weakReference.get();
            weakReference.clear();
        }
        if (object == null) {
            if (Logger.getDebugReferenceCountLevel() > 0) {
                Logger.out.println(this.mProcess + ": WARN: Discarded object " + n + " was deleted");
            }
        } else if (object != cacheObject) {
            throw new SystemError("Discarded object " + n + object.toString() + " is not the same" + " as the one being resinstated " + cacheObject.toString());
        }
        if (Logger.getDebugReferenceCountLevel() > 0) {
            Logger.out.println(this.mProcess + ": Object " + n + " reinstated");
        }
        this.addObjectToMap(n, cacheObject);
    }

    private void checkQueue() throws SystemError {
        if (Logger.getDebugReferenceCountLevel() > 1) {
            Reference reference;
            StringBuffer stringBuffer = new StringBuffer();
            while ((reference = this.mDiscardedQueue.poll()) != null) {
                WeakReferenceToOref weakReferenceToOref = (WeakReferenceToOref)reference;
                stringBuffer.append(weakReferenceToOref.key + ",");
                Integer n = new Integer(weakReferenceToOref.key);
                WeakReference weakReference = (WeakReference)this.mDiscardedMap.get(n);
                if (!weakReferenceToOref.equals(weakReference)) {
                    String string = "Enqueued object " + n + " differs from one in discarded map: " + weakReferenceToOref + " -> " + weakReference;
                    Logger.out.println(this.mProcess + ": " + string);
                    continue;
                }
                this.mDiscardedMap.remove(n);
            }
            if (stringBuffer.length() > 0) {
                Logger.out.println(this.mProcess + ": Deleted discarded objects: " + stringBuffer.toString());
            }
        } else {
            Reference reference;
            while ((reference = this.mDiscardedQueue.poll()) != null) {
                WeakReferenceToOref weakReferenceToOref = (WeakReferenceToOref)reference;
                Integer n = new Integer(weakReferenceToOref.key);
                WeakReference weakReference = (WeakReference)this.mDiscardedMap.get(n);
                if (!weakReferenceToOref.equals(weakReference)) {
                    String string = "Enqueued object " + n + " differs from one in discarded map: " + weakReferenceToOref + " -> " + weakReference;
                    if (Logger.getDebugReferenceCountLevel() <= 0) continue;
                    Logger.out.println(this.mProcess + ": " + string);
                    continue;
                }
                this.mDiscardedMap.remove(n);
            }
        }
    }

    protected Dataholder deleteObjectByOID(byte[] byArray, int n) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{new Dataholder(byArray), new Dataholder(n)};
        Dataholder dataholder = this.runClassMethod(SYSTEM_CLASS, "%Delete", dataholderArray, 0);
        return dataholder;
    }

    protected Map getCopyOfMap() {
        return new TreeMap(this.mObjectMap);
    }

    protected abstract CacheObject createCacheObjectByOref(String var1, int var2) throws CacheException;

    protected abstract CacheObject openObjectByOID(Oid var1, int var2, int var3) throws CacheException;

    protected abstract CacheObject openObjectByID(String var1, String var2, int var3, int var4) throws CacheException;

    protected abstract Map forceClose() throws CacheException;

    protected abstract void removeFromCache(int var1) throws SystemError;

    @Override
    public synchronized boolean onServerCall(Set set) throws CacheException {
        if (this.mInAttachMode) {
            return true;
        }
        if (this.mDetachedbjectsManager != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Oid oid;
                int n = (Integer)iterator.next();
                AbstractCacheObject abstractCacheObject = this.findInMap(n);
                if (abstractCacheObject == null) continue;
                abstractCacheObject.setStateReadDirty();
                if (!abstractCacheObject.getCacheClass().isPersistent()) continue;
                if (abstractCacheObject instanceof JBindCacheObject) {
                    oid = ((JBindCacheObject)abstractCacheObject).getOidWithoutCall();
                    if (oid == null || oid.undefined()) {
                        continue;
                    }
                } else {
                    oid = abstractCacheObject.getOid();
                }
                Object object = this.mDetachedbjectsManager.findPOJO(oid, true);
                ObjectFactory.unswizzle(object);
            }
        }
        return true;
    }

    public synchronized void setInAttachMode(boolean bl) {
        this.mInAttachMode = bl;
    }

    @Override
    public void onDatabaseDestroy() throws CacheException {
    }

    private static class WeakReferenceToOref
    extends WeakReference {
        int key;
        private boolean locked;

        WeakReferenceToOref(Object object) throws CacheException {
            super(object);
            this.key = ((CacheObject)object).getOref();
            this.locked = false;
        }

        WeakReferenceToOref(Object object, ReferenceQueue referenceQueue) throws CacheException {
            super(object, referenceQueue);
            this.key = ((CacheObject)object).getOref();
            this.locked = false;
        }

        protected void lock() {
            this.locked = true;
        }

        protected boolean isLocked() {
            return this.locked;
        }

        public String toString() {
            return super.toString() + '[' + this.key + ',' + this.get() + ']';
        }
    }
}

