/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.jalapeno.tools.objects.PersistentPropertyDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassAnalizer {
    private static MemberComparator mc = null;

    public static Set getGetSetPairs(Class clazz, int n, boolean bl) {
        if (n == 1) {
            try {
                return ClassAnalizer.getBeanProperties(clazz, bl);
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
        if (mc == null) {
            mc = new MemberComparator();
        }
        HashSet<PersistentPropertyDescriptor> hashSet = new HashSet<PersistentPropertyDescriptor>();
        Method[] methodArray = clazz.getDeclaredMethods();
        Arrays.sort(methodArray, mc);
        int n2 = Arrays.binarySearch(methodArray, "get", mc);
        n2 = n2 < 0 ? -n2 - 1 : ++n2;
        while (n2 < methodArray.length) {
            Method method = methodArray[n2];
            int n3 = method.getModifiers();
            if (ClassAnalizer.checkAccess(n, n3) && !Modifier.isStatic(n3)) {
                String string = method.getName();
                if (!string.startsWith("get") && !string.startsWith("is")) break;
                if (method.getParameterTypes().length == 0) {
                    Method method2;
                    Object object;
                    Method method3;
                    Object object2 = method.getReturnType();
                    int n4 = n2;
                    while (++n4 != methodArray.length && string.equals((method3 = methodArray[n4]).getName())) {
                        if (method.getParameterTypes().length != 0 || !((Class)object2).isAssignableFrom((Class<?>)(object = method3.getReturnType()))) continue;
                        method = method3;
                        object2 = object;
                    }
                    n2 = n4 - 1;
                    boolean bl2 = !bl && !Collection.class.isAssignableFrom((Class<?>)object2) && !Map.class.isAssignableFrom((Class<?>)object2);
                    object = string.startsWith("is") ? string.substring(2) : string.substring(3);
                    String string2 = "set" + (String)object;
                    object = Introspector.decapitalize((String)object);
                    try {
                        method2 = clazz.getDeclaredMethod(string2, new Class[]{object2});
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        method2 = null;
                    }
                    if (!bl2 || method2 != null) {
                        try {
                            hashSet.add(new PersistentPropertyDescriptor((String)object, method, method2));
                        }
                        catch (IntrospectionException introspectionException) {
                            throw new IllegalStateException("Can not create Property Descriptor for class: " + clazz.getName() + ", getter: " + method.getName() + " and setter " + method2);
                        }
                    }
                }
            }
            ++n2;
        }
        return hashSet;
    }

    public static Set getBeanProperties(Class clazz, boolean bl) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz, clazz.getSuperclass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        HashSet<PropertyDescriptor> hashSet = new HashSet<PropertyDescriptor>(propertyDescriptorArray.length);
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            if (!bl && propertyDescriptor.getWriteMethod() == null) continue;
            hashSet.add(propertyDescriptor);
        }
        return hashSet;
    }

    public static Set getPersistableFields(Class clazz, Set hashSet, int n, boolean bl) {
        AccessibleObject[] accessibleObjectArray;
        if (hashSet == null) {
            hashSet = new HashSet<PersistentPropertyDescriptor>();
        }
        if (n == 1 && bl) {
            accessibleObjectArray = clazz.getFields();
        } else {
            accessibleObjectArray = clazz.getDeclaredFields();
            Field.setAccessible(accessibleObjectArray, true);
        }
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject accessibleObject = accessibleObjectArray[i];
            int n2 = ((Field)accessibleObject).getModifiers();
            if (!ClassAnalizer.checkAccess(n, n2) || Modifier.isStatic(n2) || Modifier.isTransient(n2)) continue;
            try {
                hashSet.add(new PersistentPropertyDescriptor(clazz, (Field)accessibleObject));
                continue;
            }
            catch (IntrospectionException introspectionException) {
                throw new IllegalStateException("Can not create Property Descriptor for class: " + clazz.getName() + " and field: " + ((Field)accessibleObject).getName());
            }
        }
        if (n == 1 || !bl) {
            return hashSet;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            ClassAnalizer.getPersistableFields(clazz2, hashSet, n, bl);
        }
        return hashSet;
    }

    public static Set getMethodDependentTypes(Class clazz, int n) {
        HashSet<Class> hashSet = new HashSet<Class>();
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!ClassAnalizer.checkAccess(n, method.getModifiers())) continue;
            Class clazz2 = method.getReturnType();
            if ((clazz2 = ClassAnalizer.getElementClass(clazz2)) != Void.TYPE) {
                hashSet.add(clazz2);
            }
            Class<?>[] classArray = method.getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                Class clazz3 = ClassAnalizer.getElementClass(classArray[j]);
                hashSet.add(clazz3);
            }
        }
        return hashSet;
    }

    private static boolean checkAccess(int n, int n2) {
        if (Modifier.isPublic(n2)) {
            return true;
        }
        switch (n) {
            case 2: {
                return true;
            }
            case 4: {
                return Modifier.isProtected(n2);
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    private static Class getElementClass(Class clazz) {
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz;
    }

    public static Map getAllClasses(Class classArray) {
        Object object;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        for (object = classArray; object != null; object = object.getSuperclass()) {
            String string = object.getName();
            hashMap.put(String.valueOf(n++), string);
        }
        object = classArray.getInterfaces();
        for (int i = 0; i < ((Class<?>[])object).length; ++i) {
            String string = object[i].getName();
            hashMap.put(String.valueOf(n++), string);
        }
        return hashMap;
    }

    public static String methodName2PropertyName(String string) {
        if (string.startsWith("get") || string.startsWith("set")) {
            String string2 = string.substring(3);
            string2 = Introspector.decapitalize(string2);
            return string2;
        }
        if (string.startsWith("is")) {
            String string3 = string.substring(2);
            string3 = Introspector.decapitalize(string3);
            return string3;
        }
        return string;
    }

    public static String propertyName2SetterName(String string) {
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        return "set" + string;
    }

    public static String propertyName2GetterName(String string, boolean bl) {
        string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        if (bl) {
            return "is" + string;
        }
        return "get" + string;
    }

    private static class MemberComparator
    implements Comparator {
        private MemberComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = MemberComparator.toString(object);
            String string2 = MemberComparator.toString(object2);
            return string.compareTo(string2);
        }

        @Override
        public boolean equals(Object object) {
            return this.getClass().isInstance(object);
        }

        private static String toString(Object object) {
            if (object instanceof String) {
                return (String)object;
            }
            if (object instanceof Method) {
                Method method = (Method)object;
                String string = method.getName();
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length == 0) {
                    return string;
                }
                String string2 = string;
                for (int i = 0; i < classArray.length; ++i) {
                    string2 = string2 + "," + classArray[i].getName();
                }
                return string2;
            }
            if (object instanceof Member) {
                return ((Member)object).getName();
            }
            throw new ClassCastException();
        }
    }
}

