/*
 * Decompiled with CFR 0.152.
 */
package com.edb.jms.client;

import com.edb.jms.client.EDBJmsDestination;
import com.edb.jms.client.EDBQueueTable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class EDBJmsQueue
extends EDBJmsDestination
implements Queue,
Externalizable {
    static final long serialVersionUID = 1L;
    private EDBQueueTable edbQueueTbl;
    private String typeName;
    private int dequeue_mode;

    public EDBJmsQueue() {
    }

    public EDBJmsQueue(String name) {
        super(name);
    }

    @Override
    public String getQueueName() throws JMSException {
        return this.getName();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object instanceof EDBJmsQueue && ((EDBJmsQueue)object).getName().equals(this.getName())) {
            result = true;
        }
        return result;
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        stream.writeLong(1L);
        super.writeExternal(stream);
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        long version = stream.readLong();
        if (version != 1L) {
            throw new IOException("JmsQueue with version " + version + " is not supported.");
        }
        super.readExternal(stream);
    }

    @Override
    public Reference getReference() {
        Reference reference = new Reference(EDBJmsQueue.class.getName(), new StringRefAddr("name", this.getName()), Destination.class.getName(), null);
        reference.add(new StringRefAddr("persistent", this.getPersistent() ? "true" : "false"));
        return reference;
    }

    public void start() {
        EDBQueueTable tbl = this.getEdbQueueTbl();
        Connection con = tbl.getConn();
        try (CallableStatement callStmt = this.getEdbQueueTbl().getConn().prepareCall("{call DBMS_AQADM.START_QUEUE(?)}");){
            callStmt.setString(1, this.getName());
            callStmt.execute();
            System.out.println("Queue started successfully.");
        }
        catch (SQLException ex) {
            Logger.getLogger(EDBQueueTable.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public EDBQueueTable getEdbQueueTbl() {
        return this.edbQueueTbl;
    }

    public void setEdbQueueTbl(EDBQueueTable edbQueueTbl) {
        this.edbQueueTbl = edbQueueTbl;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public int getDequeue_mode() {
        return this.dequeue_mode;
    }

    public void setDequeue_mode(int dequeue_mode) {
        this.dequeue_mode = dequeue_mode;
    }
}

