/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.auth;

import java.nio.file.Paths;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProviderFactory;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sso.SsoClient;
import software.amazon.awssdk.services.sso.SsoClientBuilder;
import software.amazon.awssdk.services.sso.auth.SsoCredentialsProvider;
import software.amazon.awssdk.services.sso.internal.SsoAccessTokenProvider;
import software.amazon.awssdk.services.sso.internal.SsoTokenFileUtils;
import software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.UserHomeDirectoryUtils;

@SdkProtectedApi
public class SsoProfileCredentialsProviderFactory
implements ProfileCredentialsProviderFactory {
    private static final String TOKEN_DIRECTORY = Paths.get(UserHomeDirectoryUtils.userHomeDirectory(), ".aws", "sso", "cache").toString();

    public AwsCredentialsProvider create(Profile profile) {
        return this.create(profile, new SsoAccessTokenProvider(SsoTokenFileUtils.generateCachedTokenPath((String)profile.properties().get("sso_start_url"), TOKEN_DIRECTORY)));
    }

    @SdkTestInternalApi
    public AwsCredentialsProvider create(Profile profile, SsoAccessTokenProvider tokenProvider) {
        return new SsoProfileCredentialsProvider(profile, tokenProvider);
    }

    private static final class SsoProfileCredentialsProvider
    implements AwsCredentialsProvider,
    SdkAutoCloseable {
        private final SsoClient ssoClient;
        private final SsoCredentialsProvider credentialsProvider;

        private SsoProfileCredentialsProvider(Profile profile, SsoAccessTokenProvider tokenProvider) {
            String ssoAccountId = (String)profile.properties().get("sso_account_id");
            String ssoRoleName = (String)profile.properties().get("sso_role_name");
            String ssoRegion = (String)profile.properties().get("sso_region");
            this.ssoClient = (SsoClient)((SsoClientBuilder)((SsoClientBuilder)SsoClient.builder().credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).region(Region.of((String)ssoRegion))).build();
            GetRoleCredentialsRequest request = (GetRoleCredentialsRequest)((Object)GetRoleCredentialsRequest.builder().accountId(ssoAccountId).roleName(ssoRoleName).build());
            Supplier<GetRoleCredentialsRequest> supplier = () -> (GetRoleCredentialsRequest)((Object)((Object)request.toBuilder().accessToken(tokenProvider.resolveAccessToken()).build()));
            this.credentialsProvider = SsoCredentialsProvider.builder().ssoClient(this.ssoClient).refreshRequest(supplier).build();
        }

        public AwsCredentials resolveCredentials() {
            return this.credentialsProvider.resolveCredentials();
        }

        public void close() {
            IoUtils.closeQuietly((AutoCloseable)((Object)this.credentialsProvider), null);
            IoUtils.closeQuietly((AutoCloseable)((Object)this.ssoClient), null);
        }
    }
}

