/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.UserQueueImpl;
import com.ibm.as400.access.UserQueueImplILE;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class UserQueue {
    public static final byte QUEUE_TYPE_FIRST_IN_FIRST_OUT = -58;
    public static final byte QUEUE_TYPE_KEYED = -46;
    public static final byte QUEUE_TYPE_LAST_IN_FIRST_OUT = -45;
    private boolean mustUseNativeMethods_ = false;
    AS400 system_;
    String path_;
    int handle_ = 0;
    byte[] objectNameBytes_;
    int dataSize_;
    int keyLength_;
    private byte queueType_;
    UserQueueImpl impl_;

    public UserQueue(AS400 aS400, String string) throws UnsupportedEncodingException, CharConversionException {
        Object object;
        byte[] byArray;
        byte[] byArray2;
        if (Trace.traceOn_) {
            Trace.log(1, "Constructing UserQueue object.");
        }
        this.system_ = aS400;
        this.path_ = string;
        this.objectNameBytes_ = new byte[20];
        Arrays.fill(this.objectNameBytes_, (byte)64);
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string, "USRQ");
        String string2 = qSYSObjectPathName.getLibraryName();
        try {
            byArray2 = string2.getBytes("IBM-037");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = byArray = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)aS400.getImpl();
            object = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
            ((ConverterImplRemote)object).stringToByteArray(string2, byArray2);
        }
        String string3 = qSYSObjectPathName.getObjectName();
        try {
            byArray = string3.getBytes("IBM-037");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
            byArray = object;
            AS400ImplRemote aS400ImplRemote = (AS400ImplRemote)aS400.getImpl();
            ConverterImplRemote converterImplRemote = ConverterImplRemote.getConverter(aS400ImplRemote.getCcsid(), aS400ImplRemote);
            converterImplRemote.stringToByteArray(string3, byArray);
        }
        System.arraycopy(byArray, 0, this.objectNameBytes_, 0, byArray.length);
        System.arraycopy(byArray2, 0, this.objectNameBytes_, 10, byArray2.length);
        this.mustUseNativeMethods_ = true;
        this.impl_ = new UserQueueImplILE();
    }

    public void create(String string, byte by, int n, int n2, int n3, int n4, String string2, String string3, String string4) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.dataSize_ = n2;
        byte[] byArray = string.getBytes("IBM-037");
        byte[] byArray2 = string2.getBytes("IBM-037");
        byte[] byArray3 = string3.getBytes("IBM-037");
        byte[] byArray4 = string4.getBytes("IBM-037");
        this.keyLength_ = n;
        this.queueType_ = by;
        this.handle_ = this.impl_.create(this.objectNameBytes_, byArray, by, n, this.dataSize_, n3, n4, byArray2, byArray3, byArray4);
    }

    public void delete() {
        this.impl_.delete(this.handle_, this.objectNameBytes_);
    }

    public String dequeue() throws IllegalObjectTypeException, UnsupportedEncodingException {
        if (this.handle_ == 0) {
            this.open();
        }
        if (this.queueType_ != -58 && this.queueType_ != -45) {
            Trace.log(2, "Using dequeue for non FIFO / LIFO user queue.");
            throw new IllegalObjectTypeException(1);
        }
        if (this.keyLength_ == 0) {
            byte[] byArray = new byte[20];
            byte[] byArray2 = new byte[this.dataSize_];
            int n = this.impl_.dequeue(this.handle_, byArray, byArray2);
            if (n == 0) {
                return null;
            }
            int n2 = (0xFF & byArray[16]) * 256 * 16 + (0xFF & byArray[17]) * 256 + (0xFF & byArray[18]) * 16 + (0xFF & byArray[19]);
            return new String(byArray2, 0, n2, "IBM-037");
        }
        Trace.log(2, "Using dequeue for keyLength_ == 0.");
        throw new IllegalObjectTypeException(1);
    }

    public int dequeue(byte[] byArray, byte[] byArray2) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        if (this.handle_ == 0) {
            this.open();
        }
        return this.impl_.dequeue(this.handle_, byArray, byArray2);
    }

    public String toString() {
        return "UserQueue " + this.path_;
    }

    public void enqueue(String string) throws UnsupportedEncodingException, IllegalObjectTypeException {
        byte[] byArray = string.getBytes("IBM-037");
        if (this.handle_ == 0) {
            this.open();
        }
        if (this.queueType_ != -58 && this.queueType_ != -45) {
            Trace.log(2, "Using dequeue for keyLength_ == 0.");
            throw new IllegalObjectTypeException(1);
        }
        this.impl_.enqueue(this.handle_, null, byArray);
    }

    public void enqueue(byte[] byArray, byte[] byArray2) throws Exception {
        if (this.handle_ == 0) {
            this.open();
        }
        if (byArray != null) {
            Trace.log(2, "Keyed message queue not yet supported.");
            throw new IllegalObjectTypeException(1);
        }
        this.impl_.enqueue(this.handle_, null, byArray2);
    }

    public boolean isMustUseNativeMethods() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if user queue must use native methods:", this.mustUseNativeMethods_);
        }
        return this.mustUseNativeMethods_;
    }

    public void setMustUseNativeMethods(boolean bl) {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting if user queue must use native methods:", bl);
        }
        if (bl) {
            if (!this.mustUseNativeMethods_) {
                this.mustUseNativeMethods_ = bl;
                this.impl_ = new UserQueueImplILE();
            }
        } else if (this.mustUseNativeMethods_) {
            this.mustUseNativeMethods_ = bl;
            if (this.impl_ != null) {
                this.impl_.close(this.handle_);
                this.impl_ = null;
                this.handle_ = 0;
            }
        }
    }

    private void open() {
        this.handle_ = this.impl_.open(this.objectNameBytes_);
        byte[] byArray = new byte[128];
        this.impl_.getAttributes(this.handle_, byArray);
        if ((byArray[96] & 0x60) == 0) {
            this.queueType_ = (byte)-46;
        } else if ((byArray[96] & 0x60) == 32) {
            this.queueType_ = (byte)-45;
        } else if ((byArray[96] & 0x60) == 64) {
            this.queueType_ = (byte)-58;
        }
        this.dataSize_ = 0x1000000 * (0xFF & byArray[111]) + 65536 * (0xFF & byArray[112]) + 256 * (0xFF & byArray[113]) + (0xFF & byArray[114]);
        this.keyLength_ = 256 * (0xFF & byArray[109]) + (0xFF & byArray[110]);
    }

    public static void resetDequeueMessagePrefixBytes(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
    }

    public static int getDequeueMessagePrefixBytesLength(byte[] byArray) {
        return (0xFF & byArray[16]) * 256 * 16 + (0xFF & byArray[17]) * 256 + (0xFF & byArray[18]) * 16 + (0xFF & byArray[19]);
    }

    public static void resetEnqueueMessagePrefixBytes(byte[] byArray) {
        Arrays.fill(byArray, (byte)0);
    }

    public static void setEnqueueMessagePrefixBytesMessageSize(byte[] byArray, int n) {
        byArray[0] = (byte)(n / 0x1000000);
        byArray[1] = (byte)(n / 65536 & 0xFF);
        byArray[2] = (byte)(n / 256 & 0xFF);
        byArray[3] = (byte)(n & 0xFF);
    }

    public static void setEnqueueMessagePrefixBytesEnqueueKey(byte[] byArray, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
    }
}

