/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.mail;

import com.dbeaver.data.transfer.mail.SMTPProfile;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;

public final class SMTPProfileManager {
    private static final Log log = Log.getLog(SMTPProfileManager.class);
    private static final List<SMTPProfile> cachedProfiles = new ArrayList<SMTPProfile>();

    private SMTPProfileManager() {
    }

    @Nullable
    public static SMTPProfile getProfile(@NotNull String id) {
        for (SMTPProfile profile : SMTPProfileManager.getProfiles()) {
            if (!profile.getId().equals(id)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public static synchronized List<SMTPProfile> getProfiles() {
        if (cachedProfiles.isEmpty()) {
            ISecurePreferences securePreferences = DBWorkbench.getPlatform().getApplication().getSecureStorage().getSecurePreferences().node("mail/profiles");
            DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
            int count = preferences.getInt("mail.profiles.count");
            try {
                int i = 0;
                while (i < count) {
                    ISecurePreferences node = securePreferences.node(Integer.toString(i));
                    cachedProfiles.add(new SMTPProfile(preferences.getString("mail.profiles." + i + ".id"), preferences.getString("mail.profiles." + i + ".hostname"), preferences.getInt("mail.profiles." + i + ".port"), node.get("username", ""), node.get("password", "")));
                    ++i;
                }
            }
            catch (StorageException e) {
                log.error((Object)"Error reading SMTP profiles", (Throwable)e);
            }
        }
        return cachedProfiles;
    }

    public static synchronized void setProfiles(@NotNull List<SMTPProfile> profiles) {
        cachedProfiles.clear();
        ISecurePreferences securePreferences = DBWorkbench.getPlatform().getApplication().getSecureStorage().getSecurePreferences().node("mail/profiles");
        DBPPreferenceStore preferences = DBWorkbench.getPlatform().getPreferenceStore();
        try {
            securePreferences.clear();
            preferences.setValue("mail.profiles.count", profiles.size());
            int i = 0;
            while (i < profiles.size()) {
                SMTPProfile profile = profiles.get(i);
                preferences.setValue("mail.profiles." + i + ".id", profile.getId());
                preferences.setValue("mail.profiles." + i + ".hostname", profile.getHostname());
                preferences.setValue("mail.profiles." + i + ".port", profile.getPort());
                ISecurePreferences node = securePreferences.node(Integer.toString(i));
                node.put("username", profile.getUsername(), false);
                node.put("password", profile.getPassword(), false);
                ++i;
            }
            preferences.save();
            securePreferences.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error saving SMTP profiles", (Throwable)e);
        }
    }
}

