/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb.exec;

import com.dbeaver.ee.influxdb.exec.InfluxBaseStatement;
import com.dbeaver.ee.influxdb.exec.InfluxResultSetMetaColumn;
import com.dbeaver.ee.influxdb.exec.InfluxSession;
import com.dbeaver.model.timeseries.TSResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.influxdb.dto.QueryResult;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.impl.local.LocalResultSetMeta;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class InfluxResultSet
extends AbstractResultSet<InfluxSession, InfluxBaseStatement>
implements DBRBlockingObject,
TSResultSet {
    private QueryResult.Series series;
    private DBCResultSetMetaData metaData;
    private List<Object> curRow;
    private int rowCount = 0;

    public InfluxResultSet(InfluxBaseStatement statement, QueryResult.Series series) {
        super((DBCSession)statement.getSession(), (DBCStatement)statement);
        this.series = series;
        if (statement.getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetOpen((DBCResultSet)this);
        }
        statement.getSession().getProgressMonitor().startBlock((DBRBlockingObject)this, "Fetch result");
    }

    public QueryResult.Series getSeries() {
        return this.series;
    }

    public InfluxSession getSession() {
        return ((InfluxBaseStatement)this.statement).getSession();
    }

    public InfluxBaseStatement getSourceStatement() {
        return (InfluxBaseStatement)this.statement;
    }

    private void checkRowFetched() throws DBCException {
        if (this.curRow == null) {
            throw new DBCException("Row not fetched");
        }
    }

    public Object getAttributeValue(int index) throws DBCException {
        this.checkRowFetched();
        return this.curRow.get(index);
    }

    public Object getAttributeValue(String name) throws DBCException {
        this.checkRowFetched();
        return null;
    }

    public List<Object> getCurRow() {
        return this.curRow;
    }

    public boolean nextRow() throws DBCException {
        if (this.series == null) {
            return false;
        }
        List values = this.series.getValues();
        if (CommonUtils.isEmpty((Collection)values) || values.size() <= this.rowCount) {
            return false;
        }
        this.curRow = (List)values.get(this.rowCount);
        ++this.rowCount;
        return true;
    }

    public boolean moveTo(int position) throws DBCException {
        this.rowCount = position;
        return true;
    }

    @NotNull
    public DBCResultSetMetaData getMeta() throws DBCException {
        if (this.metaData == null) {
            ArrayList<InfluxResultSetMetaColumn> attrs = new ArrayList<InfluxResultSetMetaColumn>();
            if (this.series != null) {
                for (String col : this.series.getColumns()) {
                    attrs.add(new InfluxResultSetMetaColumn(this, attrs.size(), col, DBPDataKind.STRING));
                }
            }
            this.metaData = new LocalResultSetMeta(attrs);
        }
        return this.metaData;
    }

    public String getResultSetName() throws DBCException {
        if (this.series == null) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        if (!CommonUtils.isEmpty((String)this.series.getName())) {
            name.append(this.series.getName());
        }
        if (!CommonUtils.isEmpty((Map)this.series.getTags())) {
            name.append(": ");
            boolean firstTag = true;
            for (Map.Entry tag : this.series.getTags().entrySet()) {
                if (!firstTag) {
                    name.append(",");
                }
                name.append((String)tag.getKey()).append("=").append((String)tag.getValue());
                firstTag = false;
            }
        }
        return name.toString();
    }

    public Object getFeature(String name) {
        if ("timeseries".equals(name)) {
            return true;
        }
        return super.getFeature(name);
    }

    public void close() {
        ((InfluxBaseStatement)this.statement).getSession().getProgressMonitor().endBlock();
        if (((InfluxBaseStatement)this.statement).getSession().isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleResultSetClose((DBCResultSet)this, (long)this.rowCount);
        }
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
    }
}

