/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.net.auth.postgresql.sspi;

import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;

public class PostgreSQLAuthModelSSPI
extends AuthModelDatabaseNative<AuthModelDatabaseNativeCredentials> {
    private static final Log log = Log.getLog(PostgreSQLAuthModelSSPI.class);
    public static final String WAFFLE_MAVEN_REF = "maven:/com.github.waffle:waffle-jna:RELEASE[1.9.1]";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelDatabaseNativeCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connectProps) throws DBException {
        DBPDriver driver = dataSource.getContainer().getDriver();
        boolean hasWaffleDeps = false;
        for (DBPDriverLibrary dl : driver.getDriverLibraries()) {
            if (!dl.getPath().contains("waffle")) continue;
            hasWaffleDeps = true;
        }
        if (!hasWaffleDeps) {
            DriverDescriptor driverImpl = (DriverDescriptor)driver;
            driverImpl.addDriverLibrary(WAFFLE_MAVEN_REF, DBPDriverLibrary.FileType.jar);
            driverImpl.resetDriverInstance();
        }
        connectProps.put("gsslib", "sspi");
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connectProps);
    }
}

