/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl;

import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.ConnectionRouter;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.FreeformLayer;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;

public class ConnectionLayer
extends FreeformLayer {
    int antialias = -1;
    protected ConnectionRouter connectionRouter;

    @Override
    public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
        if (figure instanceof Connection && this.getConnectionRouter() != null) {
            ((Connection)figure).setConnectionRouter(this.getConnectionRouter());
        }
    }

    public ConnectionRouter getConnectionRouter() {
        return this.connectionRouter;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.antialias != -1) {
            graphics.setAntialias(this.antialias);
        }
        super.paint(graphics);
    }

    @Override
    public void remove(IFigure figure) {
        if (figure instanceof Connection) {
            ((Connection)figure).setConnectionRouter(null);
        }
        super.remove(figure);
    }

    public void setConnectionRouter(ConnectionRouter router) {
        this.connectionRouter = router;
        Figure.FigureIterator iter = new Figure.FigureIterator(this);
        while (iter.hasNext()) {
            IFigure figure = iter.nextFigure();
            if (!(figure instanceof Connection)) continue;
            ((Connection)figure).setConnectionRouter(router);
        }
    }

    public void setAntialias(int antialias) {
        this.antialias = antialias;
    }
}

