/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.model;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.TableOptionsMetadata;
import com.dbeaver.db.cassandra.model.CasKeyspace;
import com.dbeaver.db.cassandra.model.CasTableBase;
import com.dbeaver.db.cassandra.model.CasTableIndex;
import com.dbeaver.db.cassandra.model.CasTableKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;

public class CasTable
extends CasTableBase {
    private static final Log log = Log.getLog(CasTable.class);
    private final TableMetadata metadata;
    private final IndexCache indexCache = new IndexCache();
    private CasTableKey primaryKey;
    private CasTableKey partitionKey;

    public CasTable(CasKeyspace keyspace, TableMetadata metadata) {
        super(keyspace);
        this.metadata = metadata;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.metadata.getName();
    }

    @Property(viewable=true, editable=true, order=100)
    @Nullable
    public String getDescription() {
        TableOptionsMetadata options = this.metadata.getOptions();
        if (options == null) {
            return null;
        }
        return options.getComment();
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getAllObjects(monitor, this);
    }

    public IndexCache getIndexCache() {
        return this.indexCache;
    }

    @Override
    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) {
        this.indexCache.clearCache();
        return super.refreshObject(monitor);
    }

    public Collection<CasTableKey> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.primaryKey == null) {
            this.primaryKey = new CasTableKey(monitor, this, this.metadata.getPrimaryKey(), DBSEntityConstraintType.PRIMARY_KEY);
            this.partitionKey = new CasTableKey(monitor, this, this.metadata.getPartitionKey(), CasTableKey.PARTITION_KEY);
        }
        return Arrays.asList(this.primaryKey, this.partitionKey);
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) {
        return this.metadata.exportAsString();
    }

    @Property(viewable=false, editable=false, order=10, category="Options")
    public double getBloomFilterFalsePositiveChance() {
        return this.metadata.getOptions().getBloomFilterFalsePositiveChance();
    }

    @Property(viewable=false, editable=false, order=11, category="Options")
    public Map<String, String> getCaching() {
        return this.metadata.getOptions().getCaching();
    }

    @Property(viewable=false, editable=false, order=12, category="Options")
    public Map<String, String> getCompaction() {
        return this.metadata.getOptions().getCompaction();
    }

    @Property(viewable=false, editable=false, order=13, category="Options")
    public Map<String, String> getCompression() {
        return this.metadata.getOptions().getCompression();
    }

    @Property(viewable=false, editable=false, order=14, category="Options")
    public int getDefaultTimeToLive() {
        return this.metadata.getOptions().getDefaultTimeToLive();
    }

    @Property(viewable=false, editable=false, order=15, category="Options")
    public int getGcGraceInSeconds() {
        return this.metadata.getOptions().getGcGraceInSeconds();
    }

    @Property(viewable=false, editable=false, order=16, category="Options")
    public Integer getIndexInterval() {
        return this.metadata.getOptions().getIndexInterval();
    }

    @Property(viewable=false, editable=false, order=17, category="Options")
    public double getLocalReadRepairChance() {
        return this.metadata.getOptions().getLocalReadRepairChance();
    }

    @Property(viewable=false, editable=false, order=18, category="Options")
    public int getMemtableFlushPeriodInMs() {
        return this.metadata.getOptions().getMemtableFlushPeriodInMs();
    }

    @Property(viewable=false, editable=false, order=19, category="Options")
    public boolean getPopulateIOCacheOnFlush() {
        return this.metadata.getOptions().getPopulateIOCacheOnFlush();
    }

    @Property(viewable=false, editable=false, order=20, category="Options")
    public double getReadRepairChance() {
        return this.metadata.getOptions().getReadRepairChance();
    }

    @Property(viewable=false, editable=false, order=21, category="Options")
    public boolean getReplicateOnWrite() {
        return this.metadata.getOptions().getReplicateOnWrite();
    }

    @Property(viewable=false, editable=false, order=22, category="Options")
    public String getSpeculativeRetry() {
        return this.metadata.getOptions().getSpeculativeRetry();
    }

    @Property(viewable=false, editable=false, order=23, category="Options")
    public boolean isCompactStorage() {
        return this.metadata.getOptions().isCompactStorage();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isKeyColumn(String name) {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        try {
            CasTableKey.KeyColumn col;
            this.getConstraints((DBRProgressMonitor)monitor);
            if (this.primaryKey == null) return false;
            Iterator<CasTableKey.KeyColumn> iterator = this.primaryKey.getAttributeReferences((DBRProgressMonitor)monitor).iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(col = iterator.next()).getName().equals(name));
            return true;
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return false;
    }

    @Override
    protected List<ColumnMetadata> getMetaColumns() {
        return this.metadata.getColumns();
    }

    class IndexCache
    extends AbstractObjectCache<CasTable, CasTableIndex> {
        IndexCache() {
        }

        @NotNull
        public Collection<CasTableIndex> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasTable table) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasTableIndex> indexes = new ArrayList<CasTableIndex>();
                for (IndexMetadata imd : CasTable.this.metadata.getIndexes()) {
                    indexes.add(new CasTableIndex(table, imd));
                    if (monitor.isCanceled()) break;
                }
                this.setCache(indexes);
            }
            return this.getCachedObjects();
        }

        public CasTableIndex getObject(@NotNull DBRProgressMonitor monitor, @Nullable CasTable casKeyspace, @NotNull String name) throws DBException {
            return (CasTableIndex)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }
}

