/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.exec.MGBaseStatement;
import com.dbeaver.db.mongodb.exec.MGSession;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import java.util.ArrayList;
import java.util.List;
import org.bson.Document;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;

public class MGInsertStatement
extends MGBaseStatement {
    private DBSAttributeBase[] valueAttributes;
    private final List<Object[]> rowValues = new ArrayList<Object[]>();
    private int[] batchResult;

    public MGInsertStatement(MGSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        super(session, MGInsertStatement.makeQuery(mongoCollection, updateAttributes, rowValues));
        this.collection = mongoCollection;
        this.valueAttributes = updateAttributes;
    }

    public void addRowValues(Object[] rowValues) {
        this.rowValues.add(rowValues);
    }

    @Override
    public void addToBatch() throws DBCException {
    }

    @Override
    public int[] executeStatementBatch() throws DBCException {
        this.executeStatement();
        return this.batchResult;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            this.batchResult = new int[this.rowValues.size()];
            ArrayList<Document> newDocs = new ArrayList<Document>();
            for (Object[] row : this.rowValues) {
                Document o;
                if (this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT) {
                    o = (Document)MGUtils.unwrapMongoValue(((MGSession)this.getSession()).getDataSource(), this.valueAttributes[0], ((DBDDocument)row[0]).getRootNode());
                } else {
                    o = new Document();
                    int i = 0;
                    while (i < this.valueAttributes.length) {
                        String attrName = MongoSQLUtils.unquote(this.collection.getAttributeName(this.valueAttributes[i]));
                        attrName = attrName.replace(".", "_");
                        Object attrValue = MGUtils.unwrapMongoValue(((MGSession)this.getSession()).getDataSource(), this.valueAttributes[i], row[i]);
                        o.put(attrName, attrValue);
                        ++i;
                    }
                }
                newDocs.add((Document)MongoSQLUtils.normalizeMongoValue(((MGSession)this.getSession()).getDataSource(), o));
            }
            this.updateRowCount = this.collection.getMongoCollection((MGSession)this.getSession()).insertMany(newDocs).getInsertedIds().size();
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
            this.rowValues.clear();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO  ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append(" (");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i]));
            ++i;
        }
        sql.append(") VALUES (");
        i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        sql.append(")");
        return sql.toString();
    }
}

