/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb;

import com.dbeaver.db.mongodb.data.MGDocument;
import com.dbeaver.db.mongodb.data.MGListValue;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.model.document.data.DBMapValue;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoCredential;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.runtime.encode.EncryptionException;
import org.jkiss.dbeaver.runtime.encode.PasswordEncrypter;
import org.jkiss.dbeaver.runtime.encode.SimpleStringEncrypter;
import org.jkiss.utils.CommonUtils;

public class MGUtils {
    private static final Log log = Log.getLog(MGUtils.class);
    private static final char[] EMPTY_PASSWORD = "".toCharArray();
    private static PasswordEncrypter ENCRYPTER = new SimpleStringEncrypter();

    public static int resolveValueType(Object value) {
        if (value instanceof CharSequence) {
            return 3;
        }
        if (value instanceof Number) {
            return 4;
        }
        if (value instanceof Boolean) {
            return 7;
        }
        if (value instanceof Date) {
            return 8;
        }
        if (value instanceof byte[]) {
            return 9;
        }
        if (value instanceof Collection) {
            return 10;
        }
        if (value instanceof MGDocument) {
            return 2;
        }
        return 11;
    }

    public static Object wrapMongoValue(MGDataSource dataSource, Object value, Object parent) {
        if (value instanceof List) {
            return MGUtils.wrapMongoList(dataSource, (List)value, parent);
        }
        if (value instanceof Map) {
            return MGUtils.wrapMongoMap(dataSource, (Map)value, parent);
        }
        if (value instanceof ObjectId) {
            return value.toString();
        }
        return value;
    }

    public static MGListValue wrapMongoList(MGDataSource dataSource, List<Object> dbList, Object parent) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object item : dbList) {
            list.add(MGUtils.wrapMongoValue(dataSource, item, parent));
        }
        return new MGListValue(dataSource, list);
    }

    @NotNull
    public static DBMapValue<MGDataSource> wrapMongoMap(MGDataSource dataSource, Map<String, Object> value, Object parent) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        DBMapValue mapValue = new DBMapValue((DBPDataSource)dataSource, parent, map);
        for (String name : value.keySet()) {
            Object mValue = value.get(name);
            map.put(name, MGUtils.wrapMongoValue(dataSource, mValue, mapValue));
        }
        return mapValue;
    }

    public static Object unwrapMongoValue(@NotNull MGDataSource dataSource, @Nullable DBSAttributeBase attribute, Object value) {
        return MGUtils.unwrapMongoValue(dataSource, attribute == null ? null : attribute.getName(), value);
    }

    public static Object unwrapMongoValue(@NotNull MGDataSource dataSource, @Nullable String name, Object value) {
        if (value instanceof MGDocument) {
            return MGUtils.unwrapMongoMap(dataSource, (DBMapValue<MGDataSource>)((MGDocument)((Object)value)).getRootNode());
        }
        if (value instanceof DBMapValue) {
            return MGUtils.unwrapMongoMap(dataSource, (DBMapValue<MGDataSource>)((DBMapValue)value));
        }
        if (value instanceof Map) {
            return MGUtils.unwrapPlainMap(dataSource, (Map)value);
        }
        if (value instanceof MGListValue) {
            return MGUtils.unwrapMongoList(dataSource, (MGListValue)((Object)value));
        }
        if (value instanceof String) {
            if (name != null && name.equals("_id")) {
                ObjectId objectId;
                if (ObjectId.isValid((String)((String)value)) && (objectId = new ObjectId((String)value)).getTimestamp() > 0) {
                    return objectId;
                }
                return value;
            }
        } else if (value instanceof BigDecimal && !dataSource.supportsDecimal128()) {
            value = ((BigDecimal)value).scale() == 0 ? (Number)((BigDecimal)value).longValue() : (Number)((BigDecimal)value).doubleValue();
        }
        return value;
    }

    private static Document unwrapMongoMap(MGDataSource dataSource, DBMapValue<MGDataSource> value) {
        return MGUtils.unwrapPlainMap(dataSource, value.getRawValue());
    }

    private static Document unwrapPlainMap(MGDataSource dataSource, Map<String, Object> value) {
        Document dbObject = new Document();
        if (value != null) {
            for (Map.Entry<String, Object> me : value.entrySet()) {
                dbObject.append(me.getKey(), MGUtils.unwrapMongoValue(dataSource, me.getKey(), me.getValue()));
            }
        }
        return dbObject;
    }

    private static BasicDBList unwrapMongoList(MGDataSource dataSource, MGListValue value) {
        BasicDBList dbList = new BasicDBList();
        if (value.getRawValue() != null) {
            Iterator iterator = value.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                dbList.add(MGUtils.unwrapMongoValue(dataSource, null, item));
            }
        }
        return dbList;
    }

    public static String toJSON(Map<String, Object> object, boolean preview) {
        return object == null ? "[NULL]" : object.toString();
    }

    public static String saveAuthInfo(String userName, String userDB, String userPassword) {
        if (CommonUtils.isEmpty((String)userName)) {
            return null;
        }
        try {
            return String.valueOf(userName) + "|" + userDB + "|" + ENCRYPTER.encrypt(userPassword);
        }
        catch (EncryptionException encryptionException) {
            return String.valueOf(userName) + "|" + userDB + "|" + userPassword;
        }
    }

    public static String[] extractAuthInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        try {
            return new String[]{authTokens[0], authTokens[1], ENCRYPTER.decrypt(authTokens[2])};
        }
        catch (EncryptionException encryptionException) {
            return new String[]{authTokens[0], authTokens[1], authTokens[2]};
        }
    }

    public static String saveSeedInfo(String host, String port) {
        return String.valueOf(host) + "|" + port;
    }

    public static String[] extractSeedInfo(String tokens) {
        String[] authTokens = tokens.split("\\|");
        return new String[]{authTokens[0], authTokens[1]};
    }

    @NotNull
    public static Object cloneObject(Object object) {
        if (object instanceof BasicDBObject) {
            return (BasicDBObject)((BasicDBObject)object).copy();
        }
        if (object instanceof BasicDBList) {
            return (BasicDBList)((BasicDBList)object).copy();
        }
        if (object instanceof DBObject) {
            return (DBObject)object;
        }
        if (object instanceof Document) {
            return new Document((Map)((Document)object));
        }
        throw new IllegalArgumentException("Can't copy object [" + object + "]");
    }

    @Nullable
    public static String[] getHostnamesFromURL(@NotNull String url) {
        int optsPos;
        if (!MGUtils.isValidURL(url)) {
            return null;
        }
        String hostnames = url.substring(url.indexOf("://") + 3);
        int userPos = hostnames.indexOf(64);
        if (userPos != -1) {
            hostnames = hostnames.substring(userPos + 1);
        }
        if ((optsPos = hostnames.indexOf(47)) != -1) {
            hostnames = hostnames.substring(0, optsPos);
        }
        return CommonUtils.split((String)hostnames, (String)",");
    }

    public static boolean isValidURL(String url) {
        return !CommonUtils.isEmpty((String)url) && !url.startsWith("mongo://");
    }

    public static boolean isCommandResultOk(Document commandResult) {
        return commandResult.get((Object)"ok") != null;
    }

    public static String getCommandResultError(Document commandResult) {
        return (String)commandResult.get((Object)"errorMessage");
    }

    @Nullable
    public static MongoCredential getMongoCredential(MGDataSource dataSource, DBPConnectionConfiguration connectionInfo) {
        String authString;
        MongoCredential credential = null;
        String mechanism = connectionInfo.getProviderProperty("authMechanism");
        if (mechanism == null && (mechanism = connectionInfo.getProviderProperty("@dbeaver-mongo-cred-mechanism@")) == null) {
            mechanism = dataSource.getDefaultAuthMechanism();
        }
        String userName = null;
        String userPassword = null;
        String userDB = connectionInfo.getProviderProperty("authSource");
        if (CommonUtils.isEmpty((String)userDB)) {
            userDB = connectionInfo.getProviderProperty("@dbeaver-auth-source@");
        }
        if (CommonUtils.isEmpty((String)userDB)) {
            userDB = connectionInfo.getDatabaseName();
        }
        if ((authString = connectionInfo.getProviderProperty("@dbeaver-auth@0")) != null) {
            String[] authTokens = MGUtils.extractAuthInfo(authString);
            userName = authTokens[0];
            userDB = authTokens[1];
            userPassword = authTokens[2];
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            userName = connectionInfo.getUserName();
        }
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserPassword())) {
            userPassword = connectionInfo.getUserPassword();
        }
        if (!CommonUtils.isEmpty((String)userName) && !"NONE".equals(mechanism)) {
            if (mechanism.equals(MongoCredential.PLAIN_MECHANISM)) {
                credential = MongoCredential.createPlainCredential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
            } else if (mechanism.equals(MongoCredential.GSSAPI_MECHANISM)) {
                credential = MongoCredential.createGSSAPICredential((String)userName);
            } else if (mechanism.equals(MongoCredential.SCRAM_SHA_1_MECHANISM) || mechanism.equals("MONGODB-CR")) {
                credential = MongoCredential.createScramSha1Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
            } else if (mechanism.equals(MongoCredential.SCRAM_SHA_256_MECHANISM)) {
                credential = MongoCredential.createScramSha256Credential((String)userName, (String)userDB, (char[])(CommonUtils.isEmpty((String)userPassword) ? EMPTY_PASSWORD : userPassword.toCharArray()));
            } else if (mechanism.equals(MongoCredential.MONGODB_X509_MECHANISM)) {
                credential = MongoCredential.createMongoX509Credential((String)userName);
            }
        }
        return credential;
    }

    @NotNull
    public static String transformURL(MongoCredential credential, String url) {
        int userPos = url.indexOf(64);
        if (userPos == -1 && (userPos = url.indexOf("://")) != -1) {
            userPos += 3;
        }
        if (userPos != -1 && credential != null) {
            String userPassPart = credential.getUserName();
            if (credential.getPassword() != null) {
                userPassPart = String.valueOf(userPassPart) + ":" + new String(credential.getPassword());
            }
            if (url.charAt(userPos) != '@') {
                userPassPart = String.valueOf(userPassPart) + "@";
            }
            url = String.valueOf(url.substring(0, userPos)) + userPassPart + url.substring(userPos);
        }
        if (credential != null && credential.getMechanism() != null && !url.contains("authMechanism=")) {
            url = !url.contains("?") ? String.valueOf(url) + "?" : String.valueOf(url) + "&";
            url = String.valueOf(url) + "authMechanism=" + credential.getMechanism();
        }
        return url;
    }
}

