/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.net.auth.wallet;

import com.dbeaver.db.oracle.net.auth.wallet.OracleAuthModelWalletCredentials;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class OracleAuthModelWallet
extends AuthModelDatabaseNative<OracleAuthModelWalletCredentials> {
    private static final String ORACLE_WALLET_LOCATION = "oracle.net.wallet_location";
    private static final String ORACLE_WALLET_PASS = "oracle.net.wallet_password";

    @NotNull
    public OracleAuthModelWalletCredentials createCredentials() {
        return new OracleAuthModelWalletCredentials();
    }

    @NotNull
    public OracleAuthModelWalletCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        OracleAuthModelWalletCredentials credentials = (OracleAuthModelWalletCredentials)super.loadCredentials(dataSource, configuration);
        credentials.setWalletDir(CommonUtils.toString((Object)configuration.getAuthProperty("oracle.wallet.dir")));
        return credentials;
    }

    public void saveCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull OracleAuthModelWalletCredentials credentials) {
        configuration.setAuthProperty("oracle.wallet.dir", credentials.getWalletDir());
        super.saveCredentials(dataSource, configuration, (AuthModelDatabaseNativeCredentials)credentials);
    }

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, OracleAuthModelWalletCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        connProperties.setProperty(ORACLE_WALLET_LOCATION, "file:" + credentials.getWalletDir());
        if (CommonUtils.isNotEmpty((String)configuration.getAuthProperty("oracle.wallet.password"))) {
            connProperties.setProperty(ORACLE_WALLET_PASS, configuration.getAuthProperty("oracle.wallet.password"));
        }
        return super.initAuthentication(monitor, dataSource, (AuthModelDatabaseNativeCredentials)credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }
}

