/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.application;

import com.dbeaver.application.EnterpriseVersionUpdateDialog;
import com.dbeaver.application.EnterpriseWorkbenchAdvisor;
import com.dbeaver.ee.qm.db.impl.QMEmbeddedService;
import com.dbeaver.ee.runtime.core.EnterpriseProjectSecureStorage;
import com.dbeaver.ee.runtime.core.EnterpriseSecureStorage;
import com.dbeaver.lm.app.DBPApplicationLicensed;
import com.dbeaver.lm.embedded.LicenseServiceEmbedded;
import com.dbeaver.model.DBPApplicationExtended;
import com.dbeaver.model.QMService;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.resources.IWorkspace;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.impl.app.ApplicationDescriptor;
import org.jkiss.dbeaver.model.impl.app.ApplicationRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.EclipseWorkspaceImpl;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverApplication;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMService;
import org.osgi.framework.Version;

public class DBeaverApplicationAdvanced
extends DBeaverApplication
implements DBPApplicationExtended,
DBPApplicationLicensed {
    private static final Log log = Log.getLog(DBeaverApplicationAdvanced.class);
    private DBASecureStorage eeSecureStorage;
    private LMService licenseService;

    public DBeaverApplicationAdvanced() {
    }

    public DBeaverApplicationAdvanced(String defaultWorkspaceLocation, String defaultAppWorkspaceName) {
        super(defaultWorkspaceLocation, defaultAppWorkspaceName);
    }

    protected void initializeApplication() {
        super.initializeApplication();
        ApplicationDescriptor application = ApplicationRegistry.getInstance().getApplication();
        ArrayList<String> applicableProductList = new ArrayList<String>();
        applicableProductList.add(application.getLicenseProductId());
        Collections.addAll(applicableProductList, application.getUmbrellaProductIds());
        for (String productId : applicableProductList) {
            Path workspaceLicenseFile;
            Path userLicenseFile;
            String licenseFileName = "." + productId + "-license.dat";
            String userHome = System.getProperty("user.home");
            if (userHome != null && Files.exists(userLicenseFile = Path.of(userHome, new String[0]).resolve(licenseFileName), new LinkOption[0])) {
                LMLicenseManager.addLicenseSearchPath((Path)userLicenseFile);
            }
            if (!Files.exists(workspaceLicenseFile = GeneralUtils.getMetadataFolder().resolve(licenseFileName), new LinkOption[0])) continue;
            LMLicenseManager.addLicenseSearchPath((Path)workspaceLicenseFile);
        }
    }

    @NotNull
    public DBPWorkspace createWorkspace(@NotNull DBPPlatform platform, @NotNull IWorkspace eclipseWorkspace) {
        return new EclipseWorkspaceImpl(platform, eclipseWorkspace);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new EnterpriseWorkbenchAdvisor((DBPApplication)this);
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        if (this.eeSecureStorage == null) {
            this.eeSecureStorage = new EnterpriseSecureStorage();
        }
        return this.eeSecureStorage;
    }

    @NotNull
    public DBASecureStorage getProjectSecureStorage(DBPProject project) {
        return new EnterpriseProjectSecureStorage(project);
    }

    public String getInfoDetails(DBRProgressMonitor monitor) {
        LMLicense license;
        block3: {
            try {
                license = this.getLicenseService().getActiveProductLicense(false);
                if (license != null) break block3;
                return "Not licensed! ";
            }
            catch (LMException e) {
                log.error((Object)"Error reading product license", (Throwable)e);
                return null;
            }
        }
        return "Licensed to " + license.getOwnerFull() + "\n" + "License ID: " + license.getLicenseId();
    }

    public void notifyVersionUpgrade(@NotNull Version currentVersion, @NotNull VersionDescriptor newVersion, boolean showSkip) {
        EnterpriseVersionUpdateDialog dialog = new EnterpriseVersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public boolean isLicenseRequired() {
        return true;
    }

    @NotNull
    public synchronized LMService getLicenseService() {
        if (this.licenseService == null) {
            this.licenseService = this.createLicenseService();
        }
        return this.licenseService;
    }

    protected LMService createLicenseService() {
        return new LicenseServiceEmbedded();
    }

    public QMService getQueryManagerService() {
        return new QMEmbeddedService();
    }
}

