/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model.transform;

import com.amazonaws.services.redshiftarcadiainternal.model.Snapshot;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class SnapshotJsonUnmarshaller
implements Unmarshaller<Snapshot, JsonUnmarshallerContext> {
    private static SnapshotJsonUnmarshaller instance;

    public Snapshot unmarshall(JsonUnmarshallerContext context) throws Exception {
        Snapshot snapshot = new Snapshot();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("actualIncrementalBackupSizeInMegaBytes", targetDepth)) {
                    context.nextToken();
                    snapshot.setActualIncrementalBackupSizeInMegaBytes((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("backupProgressInMegaBytes", targetDepth)) {
                    context.nextToken();
                    snapshot.setBackupProgressInMegaBytes((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("currentBackupRateInMegaBytesPerSecond", targetDepth)) {
                    context.nextToken();
                    snapshot.setCurrentBackupRateInMegaBytesPerSecond((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("dbName", targetDepth)) {
                    context.nextToken();
                    snapshot.setDbName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("elapsedTimeInSeconds", targetDepth)) {
                    context.nextToken();
                    snapshot.setElapsedTimeInSeconds((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("encrypted", targetDepth)) {
                    context.nextToken();
                    snapshot.setEncrypted((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("estimatedSecondsToCompletion", targetDepth)) {
                    context.nextToken();
                    snapshot.setEstimatedSecondsToCompletion((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("kmsKeyId", targetDepth)) {
                    context.nextToken();
                    snapshot.setKmsKeyId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("manualSnapshotRemainingDays", targetDepth)) {
                    context.nextToken();
                    snapshot.setManualSnapshotRemainingDays((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("manualSnapshotRetentionPeriod", targetDepth)) {
                    context.nextToken();
                    snapshot.setManualSnapshotRetentionPeriod((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("masterUsername", targetDepth)) {
                    context.nextToken();
                    snapshot.setMasterUsername((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ownerAccount", targetDepth)) {
                    context.nextToken();
                    snapshot.setOwnerAccount((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("snapshotCreateTime", targetDepth)) {
                    context.nextToken();
                    snapshot.setSnapshotCreateTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("snapshotIdentifier", targetDepth)) {
                    context.nextToken();
                    snapshot.setSnapshotIdentifier((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("snapshotRetentionStartTime", targetDepth)) {
                    context.nextToken();
                    snapshot.setSnapshotRetentionStartTime(SimpleTypeJsonUnmarshallers.DateJsonUnmarshallerFactory.getInstance((String)"unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("sourceRegion", targetDepth)) {
                    context.nextToken();
                    snapshot.setSourceRegion((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    snapshot.setStatus((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("totalBackupSizeInMegaBytes", targetDepth)) {
                    context.nextToken();
                    snapshot.setTotalBackupSizeInMegaBytes((Double)context.getUnmarshaller(Double.class).unmarshall((Object)context));
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    context.nextToken();
                    snapshot.setVpcId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return snapshot;
    }

    public static SnapshotJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SnapshotJsonUnmarshaller();
        }
        return instance;
    }
}

