/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.redshiftarcadiainternal.model.Snapshot;
import com.amazonaws.services.redshiftarcadiainternal.model.transform.SnapshotMessageMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SnapshotMessage
implements Serializable,
Cloneable,
StructuredPojo {
    private String marker;
    private SdkInternalList<Snapshot> snapshots;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public SnapshotMessage withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<Snapshot> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new SdkInternalList();
        }
        return this.snapshots;
    }

    public void setSnapshots(Collection<Snapshot> snapshots) {
        if (snapshots == null) {
            this.snapshots = null;
            return;
        }
        this.snapshots = new SdkInternalList(snapshots);
    }

    public SnapshotMessage withSnapshots(Snapshot ... snapshots) {
        if (this.snapshots == null) {
            this.setSnapshots((Collection<Snapshot>)new SdkInternalList(snapshots.length));
        }
        for (Snapshot ele : snapshots) {
            this.snapshots.add((Object)ele);
        }
        return this;
    }

    public SnapshotMessage withSnapshots(Collection<Snapshot> snapshots) {
        this.setSnapshots(snapshots);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getSnapshots() != null) {
            sb.append("Snapshots: ").append(this.getSnapshots());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotMessage)) {
            return false;
        }
        SnapshotMessage other = (SnapshotMessage)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getSnapshots() == null ^ this.getSnapshots() == null) {
            return false;
        }
        return other.getSnapshots() == null || other.getSnapshots().equals(this.getSnapshots());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getSnapshots() == null ? 0 : this.getSnapshots().hashCode());
        return hashCode;
    }

    public SnapshotMessage clone() {
        try {
            return (SnapshotMessage)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnapshotMessageMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

