/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshiftarcadiainternal.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.redshiftarcadiainternal.model.DataShareAssociation;
import com.amazonaws.services.redshiftarcadiainternal.model.transform.DataShareMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DataShare
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean allowPubliclyAccessibleConsumers;
    private String dataShareArn;
    private SdkInternalList<DataShareAssociation> dataShareAssociations;
    private String producerArn;

    public void setAllowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers) {
        this.allowPubliclyAccessibleConsumers = allowPubliclyAccessibleConsumers;
    }

    public Boolean getAllowPubliclyAccessibleConsumers() {
        return this.allowPubliclyAccessibleConsumers;
    }

    public DataShare withAllowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers) {
        this.setAllowPubliclyAccessibleConsumers(allowPubliclyAccessibleConsumers);
        return this;
    }

    public Boolean isAllowPubliclyAccessibleConsumers() {
        return this.allowPubliclyAccessibleConsumers;
    }

    public void setDataShareArn(String dataShareArn) {
        this.dataShareArn = dataShareArn;
    }

    public String getDataShareArn() {
        return this.dataShareArn;
    }

    public DataShare withDataShareArn(String dataShareArn) {
        this.setDataShareArn(dataShareArn);
        return this;
    }

    public List<DataShareAssociation> getDataShareAssociations() {
        if (this.dataShareAssociations == null) {
            this.dataShareAssociations = new SdkInternalList();
        }
        return this.dataShareAssociations;
    }

    public void setDataShareAssociations(Collection<DataShareAssociation> dataShareAssociations) {
        if (dataShareAssociations == null) {
            this.dataShareAssociations = null;
            return;
        }
        this.dataShareAssociations = new SdkInternalList(dataShareAssociations);
    }

    public DataShare withDataShareAssociations(DataShareAssociation ... dataShareAssociations) {
        if (this.dataShareAssociations == null) {
            this.setDataShareAssociations((Collection<DataShareAssociation>)new SdkInternalList(dataShareAssociations.length));
        }
        for (DataShareAssociation ele : dataShareAssociations) {
            this.dataShareAssociations.add((Object)ele);
        }
        return this;
    }

    public DataShare withDataShareAssociations(Collection<DataShareAssociation> dataShareAssociations) {
        this.setDataShareAssociations(dataShareAssociations);
        return this;
    }

    public void setProducerArn(String producerArn) {
        this.producerArn = producerArn;
    }

    public String getProducerArn() {
        return this.producerArn;
    }

    public DataShare withProducerArn(String producerArn) {
        this.setProducerArn(producerArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllowPubliclyAccessibleConsumers() != null) {
            sb.append("AllowPubliclyAccessibleConsumers: ").append(this.getAllowPubliclyAccessibleConsumers()).append(",");
        }
        if (this.getDataShareArn() != null) {
            sb.append("DataShareArn: ").append(this.getDataShareArn()).append(",");
        }
        if (this.getDataShareAssociations() != null) {
            sb.append("DataShareAssociations: ").append(this.getDataShareAssociations()).append(",");
        }
        if (this.getProducerArn() != null) {
            sb.append("ProducerArn: ").append(this.getProducerArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataShare)) {
            return false;
        }
        DataShare other = (DataShare)obj;
        if (other.getAllowPubliclyAccessibleConsumers() == null ^ this.getAllowPubliclyAccessibleConsumers() == null) {
            return false;
        }
        if (other.getAllowPubliclyAccessibleConsumers() != null && !other.getAllowPubliclyAccessibleConsumers().equals(this.getAllowPubliclyAccessibleConsumers())) {
            return false;
        }
        if (other.getDataShareArn() == null ^ this.getDataShareArn() == null) {
            return false;
        }
        if (other.getDataShareArn() != null && !other.getDataShareArn().equals(this.getDataShareArn())) {
            return false;
        }
        if (other.getDataShareAssociations() == null ^ this.getDataShareAssociations() == null) {
            return false;
        }
        if (other.getDataShareAssociations() != null && !other.getDataShareAssociations().equals(this.getDataShareAssociations())) {
            return false;
        }
        if (other.getProducerArn() == null ^ this.getProducerArn() == null) {
            return false;
        }
        return other.getProducerArn() == null || other.getProducerArn().equals(this.getProducerArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllowPubliclyAccessibleConsumers() == null ? 0 : this.getAllowPubliclyAccessibleConsumers().hashCode());
        hashCode = 31 * hashCode + (this.getDataShareArn() == null ? 0 : this.getDataShareArn().hashCode());
        hashCode = 31 * hashCode + (this.getDataShareAssociations() == null ? 0 : this.getDataShareAssociations().hashCode());
        hashCode = 31 * hashCode + (this.getProducerArn() == null ? 0 : this.getProducerArn().hashCode());
        return hashCode;
    }

    public DataShare clone() {
        try {
            return (DataShare)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataShareMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

