/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.handlers;

import com.dbeaver.ee.vqb.ui.handlers.VQBAbstractHandler;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorPresentation;

public class SplitEditorHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(SplitEditorHandler.class);

    public Object execute(ExecutionEvent event) {
        IEditorPart activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        if (activeEditor instanceof SQLEditor) {
            SQLEditor sqlEditor = (SQLEditor)activeEditor;
            switch (sqlEditor.getExtraPresentationState()) {
                case MAXIMIZED: {
                    sqlEditor.showExtraPresentation(true, false);
                    break;
                }
                case VISIBLE: {
                    sqlEditor.showExtraPresentation(true, true);
                    break;
                }
                default: {
                    sqlEditor.showExtraPresentation(true, false);
                }
            }
        }
        VQBAbstractHandler.updateEditorCommandStates();
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)element.getServiceLocator().getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return;
        }
        IEditorPart activeEditor = workbenchWindow.getActivePage().getActiveEditor();
        if (activeEditor instanceof SQLEditor) {
            element.setChecked(((SQLEditor)activeEditor).getExtraPresentationState() == SQLEditorPresentation.ActivationType.VISIBLE);
        }
    }
}

