/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.editor;

import com.dbeaver.ee.vqb.internal.ui.VQBMessages;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.ee.vqb.ui.editor.VQBContentProvider;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorDecorator;
import com.dbeaver.ee.vqb.ui.editor.VQBEditorPresentation;
import com.dbeaver.ee.vqb.ui.part.QueryColumnPart;
import com.dbeaver.ee.vqb.ui.part.QueryJoinPart;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.builder.VQBQueryParser;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef3.GraphicalViewer;
import org.eclipse.gef3.commands.Command;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.erd.model.ERDContentProvider;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.ui.command.BendpointCommand;
import org.jkiss.dbeaver.erd.ui.command.NodeMoveCommand;
import org.jkiss.dbeaver.erd.ui.editor.ERDEditorPart;
import org.jkiss.dbeaver.erd.ui.model.ERDDecorator;
import org.jkiss.dbeaver.erd.ui.model.EntityDiagram;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.load.DatabaseLoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadService;
import org.jkiss.dbeaver.model.runtime.load.ILoadVisualizer;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.LoadingJob;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.TextEditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class VQBEditorPart
extends ERDEditorPart {
    private static final Log log = Log.getLog(VQBEditorPart.class);
    @NotNull
    private final VQBEditorPresentation presentation;
    @Nullable
    private VQBQueryInfo queryInfo;
    @NotNull
    private final QueryGeneratorJob generatorJob = new QueryGeneratorJob();

    VQBEditorPart(VQBEditorPresentation presentation) {
        this.presentation = presentation;
    }

    public VQBEditorPresentation getPresentation() {
        return this.presentation;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.presentation.getSQLEditor().getDataSource();
    }

    public boolean isReadOnly() {
        return false;
    }

    protected boolean hasProgressControl() {
        return false;
    }

    public void createPartControl(Composite parent) {
        Composite vqbHolder = UIUtils.createPlaceholder((Composite)parent, (int)1);
        if (parent.getLayout() instanceof GridLayout) {
            vqbHolder.setLayoutData((Object)new GridData(1808));
        }
        Composite erdHolder = UIUtils.createPlaceholder((Composite)vqbHolder, (int)1);
        erdHolder.setLayout((Layout)new FillLayout());
        erdHolder.setLayoutData((Object)new GridData(1808));
        super.createPartControl(erdHolder);
        ToolBarManager tb = new ToolBarManager();
        this.fillDefaultEditorContributions((IContributionManager)tb);
        ToolBar toolBar = tb.createControl(vqbHolder);
        toolBar.setLayoutData((Object)new GridData(128));
        this.getCommandStack().addCommandStackEventListener(commandStackEvent -> {
            switch (commandStackEvent.getDetail()) {
                case 8: 
                case 16: 
                case 32: {
                    Command command = commandStackEvent.getCommand();
                    if (command instanceof NodeMoveCommand || command instanceof BendpointCommand) break;
                    this.processQueryChangeCommand(command);
                }
            }
        });
        TextEditorUtils.enableHostEditorKeyBindingsSupport((IWorkbenchPartSite)this.getSite(), (Control)this.getGraphicalControl());
        EditorUtils.trackControlContext((IWorkbenchSite)this.getSite(), (Control)this.getGraphicalControl(), (String)"org.jkiss.dbeaver.ui.editors.sql.script.focused");
    }

    public void doSave(IProgressMonitor monitor) {
        log.error((Object)"Save not supported in VQB");
    }

    private void processQueryChangeCommand(Command command) {
        this.scheduleQueryGenerator();
    }

    public void scheduleQueryGenerator() {
        this.generatorJob.schedule(100L);
    }

    protected void registerDropTargetListeners(GraphicalViewer viewer) {
        super.registerDropTargetListeners(viewer);
    }

    protected ERDContentProvider createContentProvider() {
        return new VQBContentProvider(this);
    }

    protected ERDDecorator createDecorator() {
        return new VQBEditorDecorator(this);
    }

    protected void loadDiagram(boolean refreshMetadata) {
        if (this.queryInfo == null || this.queryInfo.getQuery() == null || CommonUtils.isEmpty((String)this.queryInfo.getQuery().getText())) {
            this.setErrorMessage("No Active Query.\nDrag-and-drop tables from the database navigator or use the palette.\nDrag-n-drop columns to join tables.");
        }
        this.loadDiagramFromQuery();
    }

    @NotNull
    public DBPProject getDiagramProject() {
        return this.getPresentation().getSQLEditor().getProject();
    }

    public void loadQuery(SQLQuery query) {
        if (this.queryInfo != null && this.queryInfo.getQuery() != null && this.queryInfo.getQuery().equals((Object)query) && this.queryInfo.getQuery().getOffset() == query.getOffset() && this.queryInfo.getQuery().getLength() == query.getLength()) {
            return;
        }
        if (this.isDirty() && !UIUtils.confirmAction((Shell)this.getSite().getShell(), (String)"Query Builder", (String)VQBMessages.editor_part_query_confirm_action_question_unsaved_changes)) {
            return;
        }
        DBCExecutionContext executionContext = this.presentation.getSQLEditor().getExecutionContext();
        Statement statement = null;
        if (!CommonUtils.isEmptyTrimmed((String)query.getText())) {
            statement = query.getStatement();
            if (statement == null) {
                Throwable error = query.getParseError();
                if (error != null) {
                    error = GeneralUtils.getRootCause((Throwable)error);
                    DBWorkbench.getPlatformUI().showError("Query parse failed", "Could not parse SQL query:\n" + query.getText(), error);
                }
            } else if (!(statement instanceof Select)) {
                this.setErrorMessage("Only SELECT queries are supported");
                query = new SQLQuery(query.getDataSource(), "");
                statement = null;
            } else {
                this.setErrorMessage(null);
            }
        }
        if (statement == null || !(statement instanceof Select)) {
            statement = VQBUtils.createEmptySelectStatement();
        } else {
            this.normalizeStatement((Select)statement);
        }
        this.queryInfo = new VQBQueryInfo(executionContext, query, (Select)statement);
        this.refreshDiagram(true, true);
    }

    private void normalizeStatement(Select select) {
        SelectBody body = select.getSelectBody();
        boolean cfr_ignored_0 = body instanceof PlainSelect;
    }

    private void loadDiagramFromQuery() {
        if (this.getDiagramPart() == null) {
            return;
        }
        this.getDiagramPart().getDiagram().clear();
        this.getDiagramPart().rearrangeDiagram();
        DatabaseLoadService<EntityDiagram> loadService = new DatabaseLoadService<EntityDiagram>("Parse query", this.queryInfo.getQuery().getDataSource()){

            public EntityDiagram evaluate(DBRProgressMonitor monitor) {
                EntityDiagram entityDiagram = new EntityDiagram(null, "Query Builder", VQBEditorPart.this.getContentProvider(), VQBEditorPart.this.getDecorator());
                entityDiagram.setLayoutManualAllowed(true);
                VQBQueryParser parser = new VQBQueryParser(VQBEditorPart.this.queryInfo, VQBEditorPart.this.presentation.getSQLEditor().getSyntaxManager());
                try {
                    parser.loadDiagramFromQuery(monitor, (ERDDiagram)entityDiagram, VQBUIActivator.getDefault().getPreferences());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError("Error in query", "SQL query can't be properly parsed", (Throwable)e);
                }
                return entityDiagram;
            }
        };
        this.diagramLoadingJob = LoadingJob.createService((ILoadService)loadService, (ILoadVisualizer)new ERDEditorPart.DiagramLoaderVisualizer(this, (ILoadService)loadService, (Composite)this.getGraphicalControl()){

            protected void finishLoading() {
                VQBEditorPart.this.presentation.refreshStatement();
                VQBEditorPart.this.resetDirtyFlag();
            }
        });
        this.diagramLoadingJob.schedule();
    }

    public VQBQueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    void resetDirtyFlag() {
        this.setDirty(false);
    }

    public void markEditorDirty() {
        this.setDirty(true);
    }

    private void refreshDiagramState() {
        for (EntityPart part : this.getDiagramPart().getEntityParts()) {
            for (Object ec : part.getChildren()) {
                if (!(ec instanceof QueryColumnPart)) continue;
                ((QueryColumnPart)((Object)ec)).updateCheckState();
            }
            for (Object ec : part.getSourceConnections()) {
                if (!(ec instanceof QueryJoinPart)) continue;
                ((QueryJoinPart)((Object)ec)).updateJoinType();
            }
        }
    }

    private class QueryGeneratorJob
    extends AbstractJob {
        QueryGeneratorJob() {
            super("Generate SQL query from diagram");
            this.setUser(false);
        }

        protected IStatus run(DBRProgressMonitor monitor) {
            if (VQBEditorPart.this.getDataSource() == null) {
                return GeneralUtils.makeErrorStatus((String)"Can't generate query - not connected to a database");
            }
            VQBQueryParser parser = new VQBQueryParser(VQBEditorPart.this.getQueryInfo());
            parser.updateDiagramFromQuery(monitor, (ERDDiagram)VQBEditorPart.this.getDiagram());
            UIUtils.asyncExec(() -> {
                VQBEditorPart.this.markEditorDirty();
                VQBEditorPart.this.refreshDiagramState();
                VQBEditorPart.this.presentation.refreshStatement();
            });
            return Status.OK_STATUS;
        }
    }
}

