/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.vqb.ui.commands;

import com.dbeaver.ee.vqb.VQBEditorUtils;
import com.dbeaver.ee.vqb.internal.ui.VQBUIActivator;
import com.dbeaver.model.sql.vqb.builder.VQBQueryInfo;
import com.dbeaver.model.sql.vqb.model.ERDJoin;
import com.dbeaver.model.sql.vqb.model.VQBUtils;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.gef3.EditPart;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDContainer;
import org.jkiss.dbeaver.erd.model.ERDDiagram;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.model.ERDEntity;
import org.jkiss.dbeaver.erd.ui.command.EntityAddCommand;
import org.jkiss.dbeaver.erd.ui.part.DiagramPart;
import org.jkiss.dbeaver.erd.ui.part.EntityPart;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class QueryTableAddCommand
extends EntityAddCommand {
    private final VQBQueryInfo queryInfo = VQBEditorUtils.getQueryInfo((EditPart)this.getDiagram());

    public QueryTableAddCommand(DiagramPart diagram, List<ERDEntity> entities, Point location) {
        super(diagram, entities, location);
    }

    protected void handleEntityChange(ERDEntity entity, boolean remove) {
        super.handleEntityChange(entity, remove);
        VQBUtils.handleEntityChange((ERDContainer)this.getDiagram().getDiagram(), (VQBQueryInfo)this.queryInfo, (ERDEntity)entity, (boolean)remove, (DBPPreferenceStore)VQBUIActivator.getDefault().getPreferences());
        if (!entity.isPrimary()) {
            for (EntityPart entityPart : this.getDiagram().getEntityParts()) {
                if (!entityPart.getEntity().isPrimary()) continue;
                if (!remove) {
                    if (entityPart.getEntity().hasAssociationsWith((ERDElement)entity)) continue;
                    ERDJoin erdJoin = new ERDJoin(entity, entityPart.getEntity(), true);
                    Join entityJoin = VQBUtils.findEntityJoin((ERDDiagram)this.getDiagram().getDiagram(), (PlainSelect)this.queryInfo.getPlainSelect(), (ERDEntity)entityPart.getEntity(), (ERDEntity)entity);
                    erdJoin.setUserData((Object)entityJoin);
                    continue;
                }
                for (ERDAssociation association : List.copyOf(entity.getReferences())) {
                    association.getSourceEntity().removeAssociation(association, true);
                    association.getTargetEntity().removeReferenceAssociation(association, true);
                    association.setSourceEntity(null);
                    association.setTargetEntity(null);
                }
                for (ERDAssociation association : List.copyOf(entity.getAssociations())) {
                    association.getSourceEntity().removeAssociation(association, true);
                    association.getTargetEntity().removeReferenceAssociation(association, true);
                    association.setSourceEntity(null);
                    association.setTargetEntity(null);
                }
            }
        }
    }

    public void execute() {
        DBPDataSource dataSource = this.queryInfo.getQuery().getDataSource();
        if (dataSource != null) {
            boolean isAliasAlways = VQBUIActivator.getDefault().getPreferences().getBoolean("vqb.add.aliases.always");
            for (ERDEntity entity : this.entities) {
                List diagramEntities;
                DBPDataSource eds = entity.getDataSource();
                if (eds == null && entity.getObject() != null) {
                    eds = ((DBSEntity)entity.getObject()).getDataSource();
                }
                if (eds != null && eds != dataSource) {
                    DBWorkbench.getPlatformUI().showError("Wrong connection", "You can't add table from another database connection (" + ((DBSEntity)entity.getObject()).getDataSource().getName() + ").\n" + "Please use only tables from '" + dataSource.getName() + "'.");
                    return;
                }
                if (this.queryInfo.getQuery() == null || CommonUtils.isEmpty((Collection)(diagramEntities = this.getDiagram().getDiagram().getEntities())) || isAliasAlways || !diagramEntities.contains(entity)) continue;
                DBWorkbench.getPlatformUI().showError("Same table without alias error", "You cannot use the same table in a query without an alias");
                return;
            }
        }
        super.execute();
    }
}

