/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.exceptions.Cesu8ConversionException;
import com.sap.db.jdbc.packet.ClientSideEncryptionVersion;
import com.sap.db.jdbc.packet.CommandOption;
import com.sap.db.jdbc.packet.ConnectOption;
import com.sap.db.jdbc.packet.DBConnectInfoOption;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.EngineFeatures;
import com.sap.db.jdbc.packet.FunctionCode;
import com.sap.db.jdbc.packet.HMultiLineOptionsPart;
import com.sap.db.jdbc.packet.HOptionsPart;
import com.sap.db.jdbc.packet.MessageType;
import com.sap.db.jdbc.packet.PacketOption;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.jdbc.packet.PartAttribute;
import com.sap.db.jdbc.packet.PartKind;
import com.sap.db.jdbc.packet.ProfileElement;
import com.sap.db.jdbc.packet.SessionContextOption;
import com.sap.db.jdbc.packet.StatementContextOption;
import com.sap.db.jdbc.packet.TopologyInformationOption;
import com.sap.db.jdbc.packet.TransactionFlag;
import com.sap.db.util.ByteUtils;
import com.sap.db.util.Cesu8Utils;
import com.sap.db.util.Dbg;
import com.sap.db.util.HexUtils;
import com.sap.db.util.UUIDUtils;
import java.util.UUID;

@NotThreadSafe
public class PacketAnalyzer {
    private static final int ALIGNMENT = 8;
    private byte[] _packet;
    private short _segmentCount;
    private int _segmentIndex;
    private int _segmentOffset;
    private int _segmentLength;
    private short _partCount;
    private int _partIndex;
    private int _partOffset;
    private int _partLength;

    public static int getArgumentCount(byte[] packet, int partOffset) {
        int argumentCount = ByteUtils.getShort(packet, partOffset + 2);
        if (argumentCount == -1) {
            argumentCount = ByteUtils.getInt(packet, partOffset + 4);
        }
        return argumentCount;
    }

    public static void putArgumentCount(int argumentCount, byte[] packet, int partOffset) {
        if (argumentCount < Short.MAX_VALUE) {
            ByteUtils.putShort(argumentCount, packet, partOffset + 2);
            ByteUtils.putInt(0, packet, partOffset + 4);
        } else {
            ByteUtils.putShort(-1, packet, partOffset + 2);
            ByteUtils.putInt(argumentCount, packet, partOffset + 4);
        }
    }

    public static int align(int value) {
        int mod = value % 8;
        return mod != 0 ? value + 8 - mod : value;
    }

    public short getSegmentCount() {
        return this._segmentCount;
    }

    public int getSegmentIndex() {
        return this._segmentIndex;
    }

    public int getSegmentOffset() {
        return this._segmentOffset;
    }

    public int getSegmentLength() {
        return this._segmentLength;
    }

    public short getPartCount() {
        return this._partCount;
    }

    public int getPartIndex() {
        return this._partIndex;
    }

    public int getPartOffset() {
        return this._partOffset;
    }

    public int getPartLength() {
        return this._partLength;
    }

    public void parse(byte[] packet) {
        this._packet = packet;
        try {
            this._segmentCount = ByteUtils.getShort(this._packet, 20);
        }
        catch (IndexOutOfBoundsException e) {
            this._segmentCount = (short)-1;
        }
        this._segmentIndex = -1;
        this._segmentOffset = -1;
        this._segmentLength = -1;
        this._partCount = (short)-1;
        this._partIndex = -1;
        this._partOffset = -1;
        this._partLength = -1;
    }

    public boolean nextSegment() {
        if (this._segmentIndex >= this._segmentCount - 1) {
            return false;
        }
        ++this._segmentIndex;
        this._segmentOffset = this._segmentIndex == 0 ? 32 : this._segmentOffset + ByteUtils.getInt(this._packet, this._segmentOffset + 0);
        this._segmentLength = ByteUtils.getInt(this._packet, this._segmentOffset + 0);
        this._partCount = ByteUtils.getShort(this._packet, this._segmentOffset + 8);
        this._partIndex = -1;
        this._partOffset = -1;
        this._partLength = -1;
        return true;
    }

    public boolean nextPart() {
        if (this._partIndex >= this._partCount - 1) {
            return false;
        }
        ++this._partIndex;
        this._partOffset = this._partIndex == 0 ? this._segmentOffset + 24 : this._partOffset + PacketAnalyzer.align(ByteUtils.getInt(this._packet, this._partOffset + 8) + 16);
        this._partLength = ByteUtils.getInt(this._packet, this._partOffset + 8);
        return true;
    }

    public String getDisplayPacketHeader() {
        String result;
        try {
            byte packetOptions = ByteUtils.getByte(this._packet, 22);
            result = "SessionID=" + ByteUtils.getLong(this._packet, 0) + " PacketCount=" + ByteUtils.getInt(this._packet, 8) + " VarpartLength=" + ByteUtils.getInt(this._packet, 12) + " VarpartSize=" + ByteUtils.getInt(this._packet, 16) + " NumberOfSegments=" + ByteUtils.getShort(this._packet, 20) + " PacketOptions=" + PacketOption.getDisplayString(packetOptions);
            if ((packetOptions & PacketOption.IsCompressed.getValue()) != 0) {
                result = result + " CompressionVarpartLength=" + ByteUtils.getInt(this._packet, 24);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = "Invalid packet header";
        }
        return result;
    }

    public String getDisplaySegmentHeader() {
        String result;
        try {
            byte segmentKind = ByteUtils.getByte(this._packet, this._segmentOffset + 12);
            result = (segmentKind == 1 ? "Request" : "Reply") + " SegmentLength=" + ByteUtils.getInt(this._packet, this._segmentOffset + 0) + " SegmentOffset=" + ByteUtils.getInt(this._packet, this._segmentOffset + 4) + " NumberOfParts=" + ByteUtils.getShort(this._packet, this._segmentOffset + 8) + " SegmentNumber=" + ByteUtils.getShort(this._packet, this._segmentOffset + 10) + " SegmentKind=" + segmentKind;
            result = segmentKind == 1 ? result + " MessageType=" + MessageType.getDisplayName(ByteUtils.getByte(this._packet, this._segmentOffset + 13)) + " CommitImmediately=" + ByteUtils.getByte(this._packet, this._segmentOffset + 14) + " CommandOptions=" + CommandOption.getDisplayString(ByteUtils.getByte(this._packet, this._segmentOffset + 15)) : result + " FunctionCode=" + FunctionCode.getDisplayName(ByteUtils.getShort(this._packet, this._segmentOffset + 14));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = "Invalid segment header";
        }
        return result;
    }

    public String getDisplayPartHeader() {
        String result;
        try {
            result = "PartKind=" + PartKind.getDisplayName(ByteUtils.getByte(this._packet, this._partOffset + 0)) + " PartAttributes=" + PartAttribute.getDisplayString(ByteUtils.getByte(this._packet, this._partOffset + 1)) + " ArgumentCount=" + ByteUtils.getShort(this._packet, this._partOffset + 2) + " BigArgumentCount=" + ByteUtils.getInt(this._packet, this._partOffset + 4) + " BufferLength=" + ByteUtils.getInt(this._packet, this._partOffset + 8) + " BufferSize=" + ByteUtils.getInt(this._packet, this._partOffset + 12);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            result = "Invalid part header";
        }
        return result;
    }

    public String getDisplayPartDataAsBinaryString() {
        return HexUtils.toDisplayHexString(this._packet, this._partOffset + 16, ByteUtils.getInt(this._packet, this._partOffset + 8));
    }

    public String getDisplayPartDataAsHexDump() {
        return Dbg.hexDump(this._packet, this._partOffset + 16, ByteUtils.getInt(this._packet, this._partOffset + 8));
    }

    public String getDisplayPartData(EngineFeatures engineFeatures) {
        String result;
        PartKind partKind = PartKind.decode(ByteUtils.getByte(this._packet, this._partOffset + 0));
        switch (partKind) {
            case Command: {
                result = this._getDisplayString(this._partOffset + 16, ByteUtils.getInt(this._packet, this._partOffset + 8));
                break;
            }
            case Error: {
                int offset = this._partOffset + 16;
                int length = ByteUtils.getInt(this._packet, offset + 8);
                result = " ErrorCode=" + ByteUtils.getInt(this._packet, offset + 0) + " SQLState=" + this._getDisplayString(offset + 13, 5) + " ErrorPos=" + ByteUtils.getInt(this._packet, offset + 4) + " ErrorText=" + this._getDisplayString(offset + 18, length) + " ErrorLevel=" + ByteUtils.getByte(this._packet, offset + 12);
                break;
            }
            case TopologyInformation: {
                StringBuilder builder = new StringBuilder();
                HMultiLineOptionsPart mop = new HMultiLineOptionsPart(this._packet, this._partOffset, 16 + this._partLength);
                if (mop.getArgumentCount() > 0) {
                    while (true) {
                        PacketAnalyzer._appendOption(builder, TopologyInformationOption.getDisplayName(mop.getOptionName()), mop.getOptionType().getDisplayName(), mop.getDisplayOptionValue());
                        if (mop.nextOption()) continue;
                        builder.append("\n        ");
                        if (!mop.nextLine()) break;
                    }
                }
                result = builder.toString();
                break;
            }
            case SessionContext: 
            case Profile: 
            case StatementContext: 
            case ConnectOptions: 
            case TransactionFlags: 
            case DBConnectInfo: {
                StringBuilder builder = new StringBuilder();
                HOptionsPart op = new HOptionsPart(this._packet, this._partOffset, 16 + this._partLength);
                if (op.getArgumentCount() > 0) {
                    do {
                        String optionName;
                        switch (partKind) {
                            case SessionContext: {
                                optionName = SessionContextOption.getDisplayName(op.getOptionName());
                                break;
                            }
                            case Profile: {
                                optionName = ProfileElement.getDisplayName(op.getOptionName());
                                break;
                            }
                            case StatementContext: {
                                optionName = StatementContextOption.getDisplayName(op.getOptionName());
                                break;
                            }
                            case ConnectOptions: {
                                optionName = ConnectOption.getDisplayName(op.getOptionName());
                                break;
                            }
                            case TransactionFlags: {
                                optionName = TransactionFlag.getDisplayName(op.getOptionName());
                                break;
                            }
                            case DBConnectInfo: {
                                optionName = DBConnectInfoOption.getDisplayName(op.getOptionName());
                                break;
                            }
                            default: {
                                optionName = "(unknown)";
                            }
                        }
                        PacketAnalyzer._appendOption(builder, optionName, op.getOptionType().getDisplayName(), op.getDisplayOptionValue());
                    } while (op.nextOption());
                }
                result = builder.toString();
                break;
            }
            case ParameterMetaData: {
                int i;
                StringBuilder builder = new StringBuilder();
                int argumentCount = PacketAnalyzer.getArgumentCount(this._packet, this._partOffset);
                int offset = this._partOffset + 16;
                int identOffset = offset + argumentCount * 16;
                boolean[] isEncrypted = null;
                boolean[] isDeterministic = null;
                UUID[] cekIds = null;
                if (engineFeatures != null && engineFeatures.getClientSideEncryptionVersion().getValue() >= ClientSideEncryptionVersion.Level1.getValue()) {
                    isEncrypted = new boolean[argumentCount];
                    isDeterministic = new boolean[argumentCount];
                    cekIds = new UUID[argumentCount];
                    int encryptionOffset = identOffset;
                    for (i = 0; i < argumentCount; ++i) {
                        byte encryptionOptions = ByteUtils.getByte(this._packet, encryptionOffset + 0);
                        if ((encryptionOptions & 1) != 0) {
                            isEncrypted[i] = true;
                            isDeterministic[i] = (encryptionOptions & 2) == 0;
                            cekIds[i] = UUIDUtils.newInstance(this._packet, encryptionOffset + 1);
                            encryptionOffset += 17;
                            continue;
                        }
                        ++encryptionOffset;
                    }
                    identOffset = encryptionOffset;
                }
                i = 0;
                while (i < argumentCount) {
                    boolean encrypted = isEncrypted != null && isEncrypted[i];
                    int nameOffset = ByteUtils.getInt(this._packet, offset + 4);
                    String name = nameOffset == -1 ? "" : this._getDisplayString(identOffset + nameOffset + 1, ByteUtils.getUByte(this._packet, identOffset + nameOffset));
                    builder.append(i + 1).append(".").append(" Type=").append(DataType.getDisplayName(ByteUtils.getByte(this._packet, offset + 1))).append(" Len=").append(ByteUtils.getShort(this._packet, offset + 8)).append(",").append(ByteUtils.getShort(this._packet, offset + 10)).append(" Mode=").append(ParameterMode.getDisplayName(ByteUtils.getByte(this._packet, offset + 2))).append(" Options=").append(ParameterOption.getDisplayString(ByteUtils.getByte(this._packet, offset + 0))).append(" Encrypted=").append(encrypted);
                    if (encrypted) {
                        builder.append(" Deterministic=").append(isDeterministic[i]).append(" ClientEncryptionKeyID=").append(cekIds[i]);
                    }
                    builder.append(" Name (Offset=").append(nameOffset).append(") ").append(name).append("\n        ");
                    ++i;
                    offset += 16;
                }
                result = builder.toString();
                break;
            }
            case ResultSetMetaData: {
                int i;
                StringBuilder builder = new StringBuilder();
                int argumentCount = PacketAnalyzer.getArgumentCount(this._packet, this._partOffset);
                int offset = this._partOffset + 16;
                int identOffset = offset + argumentCount * 24;
                boolean[] isEncrypted = null;
                boolean[] isDeterministic = null;
                UUID[] cekIds = null;
                if (engineFeatures != null && engineFeatures.getClientSideEncryptionVersion().getValue() >= ClientSideEncryptionVersion.Level1.getValue()) {
                    isEncrypted = new boolean[argumentCount];
                    isDeterministic = new boolean[argumentCount];
                    cekIds = new UUID[argumentCount];
                    int encryptionOffset = identOffset;
                    for (i = 0; i < argumentCount; ++i) {
                        byte encryptionOptions = ByteUtils.getByte(this._packet, encryptionOffset + 0);
                        if ((encryptionOptions & 1) != 0) {
                            isEncrypted[i] = true;
                            isDeterministic[i] = (encryptionOptions & 2) == 0;
                            cekIds[i] = UUIDUtils.newInstance(this._packet, encryptionOffset + 1);
                            encryptionOffset += 17;
                            continue;
                        }
                        ++encryptionOffset;
                    }
                    identOffset = encryptionOffset;
                }
                i = 0;
                while (i < argumentCount) {
                    boolean encrypted = isEncrypted != null && isEncrypted[i];
                    int tableNameOffset = ByteUtils.getInt(this._packet, offset + 8);
                    int schemaNameOffset = ByteUtils.getInt(this._packet, offset + 12);
                    int columnNameOffset = ByteUtils.getInt(this._packet, offset + 16);
                    int columnDisplayNameOffset = ByteUtils.getInt(this._packet, offset + 20);
                    String tableName = tableNameOffset == -1 ? "" : this._getDisplayString(identOffset + tableNameOffset + 1, ByteUtils.getUByte(this._packet, identOffset + tableNameOffset));
                    String schemaName = schemaNameOffset == -1 ? "" : this._getDisplayString(identOffset + schemaNameOffset + 1, ByteUtils.getUByte(this._packet, identOffset + schemaNameOffset));
                    String columnName = columnNameOffset == -1 ? "" : this._getDisplayString(identOffset + columnNameOffset + 1, ByteUtils.getUByte(this._packet, identOffset + columnNameOffset));
                    String columnDisplayName = columnDisplayNameOffset == -1 ? "" : this._getDisplayString(identOffset + columnDisplayNameOffset + 1, ByteUtils.getUByte(this._packet, identOffset + columnDisplayNameOffset));
                    builder.append(i + 1).append(".").append(" Type=").append(DataType.getDisplayName(ByteUtils.getByte(this._packet, offset + 1))).append(" Len=").append(ByteUtils.getShort(this._packet, offset + 4)).append(",").append(ByteUtils.getShort(this._packet, offset + 2)).append(" Options=").append(ParameterOption.getDisplayString(ByteUtils.getByte(this._packet, offset + 0))).append(" Encrypted=").append(encrypted);
                    if (encrypted) {
                        builder.append(" Deterministic=").append(isDeterministic[i]).append(" ClientEncryptionKeyID=").append(cekIds[i]);
                    }
                    builder.append(" TableName (Offset=").append(tableNameOffset).append(") ").append(tableName).append(" SchemaName (Offset=").append(schemaNameOffset).append(") ").append(schemaName).append(" ColumnName (Offset=").append(columnNameOffset).append(") ").append(columnName).append(" ColumnDisplayName (Offset=").append(columnDisplayNameOffset).append(") ").append(columnDisplayName).append("\n        ");
                    ++i;
                    offset += 24;
                }
                result = builder.toString();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    private static void _appendOption(StringBuilder builder, String name, String type, String value) {
        builder.append("Option=").append(name).append(" Type=").append(type).append(" Value=").append(value).append("\n        ");
    }

    private String _getDisplayString(int offset, int length) {
        try {
            return Cesu8Utils.getString(this._packet, offset, length, true);
        }
        catch (Cesu8ConversionException e) {
            return e.getMessage();
        }
    }
}

