/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

@ThreadSafe
abstract class ResultSetMetaDataSapDB
extends WrapperDummy
implements ResultSetMetaData {
    private final Tracer _tracer;
    private final DataFormatDescription _columnInfo;

    protected ResultSetMetaDataSapDB(Tracer tracer, DataFormatDescription columnInfo) {
        this._tracer = tracer;
        this._columnInfo = columnInfo;
    }

    @Override
    public int getColumnCount() throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnCount", new Object[0]);
            }
            int result = this._columnInfo.getResultSetColumnCount();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isAutoIncrement", column);
            }
            boolean result = this._getConverter(column).isAutoIncrement();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isCaseSensitive", column);
            }
            boolean result = this._getConverter(column).isCaseSensitive();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isSearchable", column);
            }
            boolean result = this._getConverter(column).isSearchable();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isCurrency", column);
            }
            boolean result = this._getConverter(column).isCurrency();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int isNullable(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isNullable", column);
            }
            int result = this._getConverter(column).isNullable();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isSigned", column);
            }
            boolean result = this._getConverter(column).isSigned();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnDisplaySize", column);
            }
            int result = this._getConverter(column).getColumnDisplaySize();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnLabel", column);
            }
            String result = this._getConverter(column).getColumnLabel();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnName", column);
            }
            String result = this._getConverter(column).getColumnName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getSchemaName", column);
            }
            String result = this._getConverter(column).getSchemaName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getPrecision", column);
            }
            int result = this._getConverter(column).getPrecision();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getScale(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getScale", column);
            }
            int result = this._getConverter(column).getScale();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getTableName(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getTableName", column);
            }
            String result = this._getConverter(column).getTableName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getCatalogName", column);
            }
            String result = this._getConverter(column).getCatalogName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnType", column);
            }
            int result = this._getConverter(column).getColumnType();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnTypeName", column);
            }
            String result = this._getConverter(column).getColumnTypeName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isReadOnly", column);
            }
            boolean result = this._getConverter(column).isReadOnly();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isWritable", column);
            }
            boolean result = this._getConverter(column).isWritable();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isDefinitelyWritable", column);
            }
            boolean result = this._getConverter(column).isDefinitelyWritable();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getColumnClassName", column);
            }
            String result = this._getConverter(column).getColumnClassName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    private AbstractConverter _getConverter(int columnIndex) throws SQLException {
        if (columnIndex < 1 || columnIndex > this._columnInfo.getResultSetColumnCount()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.column.index", String.valueOf(columnIndex));
        }
        return this._columnInfo.getResultSetConverter(columnIndex);
    }

    AbstractConverter getConverter(int parameterIndex) throws SQLException {
        return this._getConverter(parameterIndex);
    }
}

