/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.util.Cesu8Utils;

@ThreadSafe
final class Hash {
    private static final long MAX_VALUE = 0x100000000L;
    @GuardedBy(value="Hash.class")
    private static long _a;
    @GuardedBy(value="Hash.class")
    private static long _b;
    @GuardedBy(value="Hash.class")
    private static long _c;

    private Hash() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static synchronized long calculateHash(byte[] hashTheseBytes) {
        return Hash._OsHash(hashTheseBytes);
    }

    static synchronized long calculateHash(String hashThisString) {
        return Hash._OsHash(Cesu8Utils.getBytes(hashThisString));
    }

    private static long _OsHash(byte[] bytesToHash) {
        int i;
        long[] block = new long[12];
        int len = bytesToHash.length;
        int srcBegin = 0;
        _a = 2654435769L;
        _b = 2654435769L;
        _c = 0L;
        if (len >= 12) {
            for (i = 0; i < block.length; ++i) {
                block[i] = (long)bytesToHash[i] & 0xFFL;
            }
        } else {
            for (i = 0; i < bytesToHash.length; ++i) {
                block[i] = (long)bytesToHash[i] & 0xFFL;
            }
        }
        while (len >= 12) {
            _a = (_a += block[0] + (block[1] << 8 > 0x100000000L ? (block[1] << 8) % 0x100000000L : block[1] << 8) + (block[2] << 16 > 0x100000000L ? (block[2] << 16) % 0x100000000L : block[2] << 16) + (block[3] << 24 > 0x100000000L ? (block[3] << 24) % 0x100000000L : block[3] << 24)) > 0x100000000L ? _a % 0x100000000L : _a;
            _b = (_b += block[4] + (block[5] << 8 > 0x100000000L ? (block[5] << 8) % 0x100000000L : block[5] << 8) + (block[6] << 16 > 0x100000000L ? (block[6] << 16) % 0x100000000L : block[6] << 16) + (block[7] << 24 > 0x100000000L ? (block[7] << 24) % 0x100000000L : block[7] << 24)) > 0x100000000L ? _b % 0x100000000L : _b;
            _c = (_c += block[8] + (block[9] << 8 > 0x100000000L ? (block[9] << 8) % 0x100000000L : block[9] << 8) + (block[10] << 16 > 0x100000000L ? (block[10] << 16) % 0x100000000L : block[10] << 16) + (block[11] << 24 > 0x100000000L ? (block[11] << 24) % 0x100000000L : block[11] << 24)) > 0x100000000L ? _c % 0x100000000L : _c;
            Hash._OsMix();
            int srcEnd = (srcBegin += 12) + 12 > bytesToHash.length ? bytesToHash.length : srcBegin + 12;
            i = 0;
            for (int j = srcBegin; i < block.length && j < srcEnd; ++i, ++j) {
                block[i] = (long)bytesToHash[j] & 0xFFL;
            }
            len -= 12;
        }
        _c += (long)bytesToHash.length;
        switch (len) {
            case 11: {
                _c = (_c += block[10] << 24 > 0x100000000L ? (block[10] << 24) % 0x100000000L : block[10] << 24) > 0x100000000L ? _c % 0x100000000L : _c;
            }
            case 10: {
                _c = (_c += block[9] << 16 > 0x100000000L ? (block[9] << 16) % 0x100000000L : block[9] << 16) > 0x100000000L ? _c % 0x100000000L : _c;
            }
            case 9: {
                _c = (_c += block[8] << 8 > 0x100000000L ? (block[8] << 8) % 0x100000000L : block[8] << 8) > 0x100000000L ? _c % 0x100000000L : _c;
            }
            case 8: {
                _b = (_b += block[7] << 24 > 0x100000000L ? (block[7] << 24) % 0x100000000L : block[7] << 24) > 0x100000000L ? _b % 0x100000000L : _b;
            }
            case 7: {
                _b = (_b += block[6] << 16 > 0x100000000L ? (block[6] << 16) % 0x100000000L : block[6] << 16) > 0x100000000L ? _b % 0x100000000L : _b;
            }
            case 6: {
                _b = (_b += block[5] << 8 > 0x100000000L ? (block[5] << 8) % 0x100000000L : block[5] << 8) > 0x100000000L ? _b % 0x100000000L : _b;
            }
            case 5: {
                _b = (_b += block[4]) > 0x100000000L ? _b % 0x100000000L : _b;
            }
            case 4: {
                _a = (_a += block[3] << 24 > 0x100000000L ? (block[3] << 24) % 0x100000000L : block[3] << 24) > 0x100000000L ? _a % 0x100000000L : _a;
            }
            case 3: {
                _a = (_a += block[2] << 16 > 0x100000000L ? (block[2] << 16) % 0x100000000L : block[2] << 16) > 0x100000000L ? _a % 0x100000000L : _a;
            }
            case 2: {
                _a = (_a += block[1] << 8 > 0x100000000L ? (block[1] << 8) % 0x100000000L : block[1] << 8) > 0x100000000L ? _a % 0x100000000L : _a;
            }
            case 1: {
                _a = (_a += block[0]) > 0x100000000L ? _a % 0x100000000L : _a;
            }
        }
        Hash._OsMix();
        return _c;
    }

    private static void _OsMix() {
        _a = _a - _b > 0L ? _a - _b : 0x100000000L + (_a - _b);
        _a = _a > 0x100000000L ? _a % 0x100000000L : _a;
        _a = _a - _c > 0L ? _a - _c : 0x100000000L + (_a - _c);
        _a = _a > 0x100000000L ? _a % 0x100000000L : _a;
        _a = (_a ^= _c >> 13) > 0x100000000L ? _a % 0x100000000L : _a;
        _b = _b - _c > 0L ? _b - _c : 0x100000000L + (_b - _c);
        _b = _b > 0x100000000L ? _b % 0x100000000L : _b;
        _b = _b - _a > 0L ? _b - _a : 0x100000000L + (_b - _a);
        _b = _b > 0x100000000L ? _b % 0x100000000L : _b;
        _b = (_b ^= _a << 8 > 0x100000000L ? (_a << 8) % 0x100000000L : _a << 8) > 0x100000000L ? _b % 0x100000000L : _b;
        _c = _c - _a > 0L ? _c - _a : 0x100000000L + (_c - _a);
        _c = _c > 0x100000000L ? _c % 0x100000000L : _c;
        _c = _c - _b > 0L ? _c - _b : 0x100000000L + (_c - _b);
        _c = _c > 0x100000000L ? _c % 0x100000000L : _c;
        _c = (_c ^= _b >> 13) > 0x100000000L ? _c % 0x100000000L : _c;
        _a = _a - _b > 0L ? _a - _b : 0x100000000L + (_a - _b);
        _a = _a > 0x100000000L ? _a % 0x100000000L : _a;
        _a = _a - _c > 0L ? _a - _c : 0x100000000L + (_a - _c);
        _a = _a > 0x100000000L ? _a % 0x100000000L : _a;
        _a = (_a ^= _c >> 12) > 0x100000000L ? _a % 0x100000000L : _a;
        _b = _b - _c > 0L ? _b - _c : 0x100000000L + (_b - _c);
        _b = _b > 0x100000000L ? _b % 0x100000000L : _b;
        _b = _b - _a > 0L ? _b - _a : 0x100000000L + (_b - _a);
        _b = _b > 0x100000000L ? _b % 0x100000000L : _b;
        _b = (_b ^= _a << 16 > 0x100000000L ? (_a << 16) % 0x100000000L : _a << 16) > 0x100000000L ? _b % 0x100000000L : _b;
        _c = _c - _a > 0L ? _c - _a : 0x100000000L + (_c - _a);
        _c = _c > 0x100000000L ? _c % 0x100000000L : _c;
        _c = _c - _b > 0L ? _c - _b : 0x100000000L + (_c - _b);
        _c = _c > 0x100000000L ? _c % 0x100000000L : _c;
        _c = (_c ^= _b >> 5) > 0x100000000L ? _c % 0x100000000L : _c;
        _a = _a - _b > 0L ? _a - _b : 0x100000000L + (_a - _b);
        _a = _a > 0x100000000L ? _a % 0x100000000L : _a;
        _a = _a - _c > 0L ? _a - _c : 0x100000000L + (_a - _c);
        _a = _a > 0x100000000L ? _a % 0x100000000L : _a;
        _a = (_a ^= _c >> 3) > 0x100000000L ? _a % 0x100000000L : _a;
        _b = _b - _c > 0L ? _b - _c : 0x100000000L + (_b - _c);
        _b = _b > 0x100000000L ? _b % 0x100000000L : _b;
        _b = _b - _a > 0L ? _b - _a : 0x100000000L + (_b - _a);
        _b = _b > 0x100000000L ? _b % 0x100000000L : _b;
        _b = (_b ^= _a << 10 > 0x100000000L ? (_a << 10) % 0x100000000L : _a << 10) > 0x100000000L ? _b % 0x100000000L : _b;
        _c = _c - _a > 0L ? _c - _a : 0x100000000L + (_c - _a);
        _c = _c > 0x100000000L ? _c % 0x100000000L : _c;
        _c = _c - _b > 0L ? _c - _b : 0x100000000L + (_c - _b);
        _c = _c > 0x100000000L ? _c % 0x100000000L : _c;
        _c = (_c ^= _b >> 15) > 0x100000000L ? _c % 0x100000000L : _c;
    }
}

