/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.preferences;

import com.dbeaver.ee.runtime.core.EnterpriseProjectSecureStorage;
import com.dbeaver.ee.runtime.ui.security.EnterPasswordDialog;
import com.dbeaver.ee.runtime.ui.security.NewPasswordDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatformEclipse;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSecurity;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectSecurity
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private static final String DUMMY_PASSWORD = "dummypassword";
    private static final String BAD_PASSWORD = String.valueOf('\u0000');
    private IProject project;
    private Button useProjectSecurityCheck;
    private String projectPassword = "dummypassword";
    private String lastSavedPassword = BAD_PASSWORD;
    private boolean lastEncryptProject;
    private boolean passwordChanged = false;
    private Button clearProjectPasswordButton;
    private Button recoverPasswordButton;

    public PrefPageProjectSecurity() {
        this.setDescription("Project security settings");
    }

    private DBPProject getProjectMetadata() {
        DBPProject projectMeta = DBPPlatformEclipse.getInstance().getWorkspace().getProject(this.project);
        if (projectMeta == null) {
            DBWorkbench.getPlatformUI().showError("No project metadata", "No project metadata for " + this.project.getName());
            throw new IllegalStateException("No project metadata for " + this.project.getName());
        }
        return projectMeta;
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        Group projectPasswordGroup = UIUtils.createControlGroup((Composite)composite, (String)"Project password", (int)1, (int)0, (int)0);
        new Label((Composite)projectPasswordGroup, 0).setText("Setting project password will protect (encrypt) user credentials and project configuration with this password.\nYou will need to pass this password to other users in order to share project configuration.");
        Composite buttonsPanel = UIUtils.createComposite((Composite)projectPasswordGroup, (int)3);
        UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Set password", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (PrefPageProjectSecurity.this.validateCurrentPassword()) {
                    PrefPageProjectSecurity.this.setProjectPassword();
                    PrefPageProjectSecurity.this.updateButtons();
                    PrefPageProjectSecurity.this.passwordChanged = true;
                }
            }
        });
        this.clearProjectPasswordButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Clear password", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UIUtils.confirmAction((Shell)PrefPageProjectSecurity.this.getShell(), (String)"Clear project password", (String)"Are you sure you want to clear project password?")) {
                    PrefPageProjectSecurity.this.passwordChanged = true;
                    if (PrefPageProjectSecurity.this.validateCurrentPassword()) {
                        PrefPageProjectSecurity.this.projectPassword = null;
                        PrefPageProjectSecurity.this.updateButtons();
                    } else if (UIUtils.confirmAction((Shell)PrefPageProjectSecurity.this.getShell(), (String)"Wrong project password", (String)"Password doesn't match.\nYou still can clear project password but you will loose all your secure credentials (user names and passwords).\nDo you want to proceed?")) {
                        PrefPageProjectSecurity.this.projectPassword = null;
                        PrefPageProjectSecurity.this.updateButtons();
                    }
                }
            }
        });
        this.recoverPasswordButton = UIUtils.createDialogButton((Composite)buttonsPanel, (String)"Recover password", (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageProjectSecurity.this.recoverCurrentPassword();
                PrefPageProjectSecurity.this.updateButtons();
            }
        });
        Group encryptConfig = UIUtils.createControlGroup((Composite)composite, (String)"Encrypt configuration", (int)1, (int)0, (int)0);
        new Label((Composite)encryptConfig, 0).setText("By default project configuration (connections, hosts, ports, database names) stored as plain text.\nEnabling following option will encrypt connections configuration.\nNote: user credentials are always encrypted and stored separately.");
        this.useProjectSecurityCheck = UIUtils.createCheckbox((Composite)encryptConfig, (String)"Encrypt configuration", (String)"Encrypt project configuration.If enabled all project configuration files will be encrypted.", (boolean)false, (int)1);
        this.performDefaults();
        return composite;
    }

    private void updateButtons() {
        boolean hasPassword = this.projectPassword != null;
        this.clearProjectPasswordButton.setEnabled(hasPassword);
        this.recoverPasswordButton.setEnabled(hasPassword);
    }

    private void recoverCurrentPassword() {
        EnterPasswordDialog.recoverPassword();
    }

    private boolean validateCurrentPassword() {
        DBPProject projectMetadata = this.getProjectMetadata();
        UIServiceSecurity serviceSecurity = (UIServiceSecurity)DBWorkbench.getService(UIServiceSecurity.class);
        if (serviceSecurity != null) {
            return serviceSecurity.validatePassword(projectMetadata.getSecureStorage(), "Enter project password", "Enter current project password", false);
        }
        UIUtils.showMessageBox((Shell)this.getShell(), (String)"No security service", (String)"Cannot obtain security service", (int)1);
        return false;
    }

    private void setProjectPassword() {
        this.projectPassword = NewPasswordDialog.getNewPassword(this.getShell(), "Set project password", null, null);
    }

    protected void performDefaults() {
        DBPProject projectMetadata = this.getProjectMetadata();
        projectMetadata.ensureOpen();
        this.lastEncryptProject = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("secureProject"));
        this.useProjectSecurityCheck.setSelection(this.lastEncryptProject);
        boolean usePassword = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("useProjectPassword"));
        this.clearProjectPasswordButton.setEnabled(usePassword);
        this.recoverPasswordButton.setEnabled(usePassword);
        if (usePassword) {
            this.projectPassword = DUMMY_PASSWORD;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        boolean encryptProject;
        DBPProject projectMetadata = this.getProjectMetadata();
        DBPDataSourceRegistry dataSourceRegistry = projectMetadata.getDataSourceRegistry();
        dataSourceRegistry.refreshConfig();
        boolean configChanged = false;
        boolean oldUsePassword = CommonUtils.toBoolean((Object)projectMetadata.getProjectProperty("useProjectPassword"));
        Boolean newUsePassword = null;
        if (this.passwordChanged && !CommonUtils.equalObjects((Object)this.projectPassword, (Object)this.lastSavedPassword)) {
            if (CommonUtils.isEmpty((String)this.projectPassword)) {
                if (oldUsePassword && !UIUtils.confirmAction((Shell)this.getShell(), (String)"Project password remove", (String)("Are you sure you want to remove project '" + projectMetadata.getName() + "' password?\nProject settings will be saved in plaintext non-secure format."), (DBPImage)DBIcon.STATUS_WARNING)) {
                    return false;
                }
                newUsePassword = false;
            } else if (!this.projectPassword.equals(DUMMY_PASSWORD) && (oldUsePassword ? !UIUtils.confirmAction((Shell)this.getShell(), (String)"Project password change", (String)("Are you sure you want to change project '" + projectMetadata.getName() + "' password?\nProject settings will be re-encrypted.")) : !UIUtils.confirmAction((Shell)this.getShell(), (String)"Project password set", (String)("Are you sure you want to protect project '" + projectMetadata.getName() + "' settings with password?\nYou won't be able to access your project settings if you forget this password."), (DBPImage)DBIcon.STATUS_WARNING))) {
                return false;
            }
            if (!DUMMY_PASSWORD.equals(this.projectPassword)) {
                DBASecureStorage projectSecureStorage = projectMetadata.getSecureStorage();
                if (projectSecureStorage instanceof EnterpriseProjectSecureStorage) {
                    ((EnterpriseProjectSecureStorage)projectSecureStorage).setProjectPassword(this.projectPassword);
                }
                newUsePassword = this.projectPassword == null ? null : Boolean.valueOf(true);
            }
            this.lastSavedPassword = this.projectPassword;
            configChanged = true;
        }
        if (this.lastEncryptProject != (encryptProject = this.useProjectSecurityCheck.getSelection())) {
            configChanged = true;
        }
        if (configChanged) {
            Throwable lastLoadError = dataSourceRegistry.getLastError();
            if (lastLoadError != null) {
                DBWorkbench.getPlatformUI().showError("Project load error", "Can't load saved project datasources. Security changes can't be applied", lastLoadError);
                return false;
            }
            projectMetadata.setProjectProperty("useProjectPassword", (Object)newUsePassword);
            if (this.lastEncryptProject != encryptProject) {
                projectMetadata.setProjectProperty("secureProject", (Object)encryptProject);
                this.lastEncryptProject = encryptProject;
            }
            dataSourceRegistry.flushConfig();
        }
        this.passwordChanged = false;
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = element instanceof IProject ? (IProject)element : (element instanceof DBNNode ? ((DBNNode)element).getOwnerProject().getEclipseProject() : (IProject)DBUtils.getAdapter(IProject.class, (Object)element));
    }
}

