/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.internal.OracleConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.DriverConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

@DefaultLogger(value="oracle.ucp.jdbc.oracle")
@Supports(value={Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION})
public class OracleDriverConnectionFactoryAdapter
extends DriverConnectionFactoryAdapter {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public OracleDriverConnectionFactoryAdapter(Driver driver, String url, Properties connectionFactoryProperties, Properties connectionProperties) throws UniversalConnectionPoolException {
        super(driver, url, connectionFactoryProperties, connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        Connection connection;
        block12: {
            String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
            connection = null;
            try {
                if (null == instanceName || "".equals(instanceName)) {
                    ClioSupport.ilogFinest(null, null, null, null, "about to create connection without specifying instance");
                    connection = (Connection)super.createConnection(connectionRequestInfo);
                    break block12;
                }
                Properties props = (Properties)this.m_connectionProperties.clone();
                props.setProperty("oracle.jdbc.targetInstanceName", instanceName);
                ClioSupport.ilogFinest(null, null, null, null, "about to create connection to the instance " + instanceName);
                Driver driver = this.m_driver;
                synchronized (driver) {
                    connection = this.m_driver.connect(this.m_url, props);
                }
                if (connection instanceof OracleConnection) {
                    String in = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
                    assert (null != in);
                    assert (Util.equalsNormalized(in, instanceName)) : "internal error: got connection from the wrong instance";
                    if (!Util.equalsNormalized(in, instanceName)) {
                        ClioSupport.ilogFinest(null, null, null, null, "wrong conn opened, desired:" + instanceName + ", actual:" + in);
                    }
                } else {
                    ClioSupport.ilogFinest(null, null, null, null, "not an oracle connection");
                }
            }
            catch (Throwable e) {
                ClioSupport.ilogThrowing(null, null, null, null, e);
                if (null != connection) {
                    this.closeConnection(connection);
                }
                UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
            }
        }
        return connection;
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        OracleUniversalPooledConnection pooledConnection = new OracleUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
        return pooledConnection;
    }

    static {
        try {
            $$$methodRef$$$2 = OracleDriverConnectionFactoryAdapter.class.getDeclaredConstructor(Driver.class, String.class, Properties.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = OracleDriverConnectionFactoryAdapter.class.getDeclaredMethod("createPooledConnection", Object.class, ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = OracleDriverConnectionFactoryAdapter.class.getDeclaredMethod("createConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

