/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.model;

import com.dbeaver.db.redshift.model.RedshiftDatashare;
import com.dbeaver.db.redshift.model.RedshiftDatashareObject;
import com.dbeaver.db.redshift.model.RedshiftDatashareObjectType;
import com.dbeaver.db.redshift.model.RedshiftSharedDatabase;
import com.dbeaver.db.redshift.model.RedshiftSharedTable;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.ListCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;

public class RedshiftSharedSchema
implements DBSSchema,
DBPRefreshableObject {
    private static final Log log = Log.getLog(RedshiftSharedSchema.class);
    private final RedshiftSharedDatabase database;
    private final String name;
    private ListCache<RedshiftSharedSchema, RedshiftSharedTable> tableCache = null;

    public RedshiftSharedSchema(RedshiftSharedDatabase database, String name) {
        this.database = database;
        this.name = name;
    }

    @Nullable
    public RedshiftSharedDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public PostgreDataSource getDataSource() {
        return this.database.getDataSource();
    }

    public RedshiftSharedDatabase getDatabase() {
        return this.database;
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.tableCache = null;
        return this;
    }

    public ListCache<RedshiftSharedSchema, RedshiftSharedTable> getTableCache() {
        return this.tableCache;
    }

    public List<RedshiftSharedTable> getTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.readTables(monitor);
        return this.tableCache.getCachedObjects();
    }

    public void readTables(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.tableCache == null) {
            ArrayList<RedshiftSharedTable> tables = new ArrayList<RedshiftSharedTable>();
            RedshiftDatashare datashare = this.getDatabase().getDatashare(monitor);
            if (datashare != null) {
                String schemaPrefix = String.valueOf(this.getName()) + ".";
                for (RedshiftDatashareObject object : datashare.getObjects(monitor)) {
                    String tableFQN;
                    RedshiftDatashareObjectType objectType = object.getObjectType();
                    if (objectType != RedshiftDatashareObjectType.table && objectType != RedshiftDatashareObjectType.view || !(tableFQN = object.getObjectName()).startsWith(schemaPrefix)) continue;
                    tables.add(new RedshiftSharedTable(this, tableFQN.substring(schemaPrefix.length()), objectType == RedshiftDatashareObjectType.view));
                }
            }
            this.tableCache = new ListCache(tables);
        }
    }

    public List<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getTables(monitor);
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        this.readTables(monitor);
        return this.tableCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return RedshiftSharedTable.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.readTables(monitor);
    }
}

