/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.edit;

import com.dbeaver.db.redshift.model.RedshiftDataSource;
import com.dbeaver.db.redshift.model.RedshiftDatabase;
import com.dbeaver.db.redshift.model.RedshiftUser;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class RedshiftUserManager
extends SQLObjectEditor<RedshiftUser, RedshiftDatabase>
implements DBEObjectRenamer<RedshiftUser> {
    protected RedshiftUser createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) throws DBException {
        RedshiftDatabase database = (RedshiftDatabase)((RedshiftDataSource)((Object)container)).getDefaultInstance();
        return new RedshiftUser(database, "New User", "");
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) throws DBException {
        RedshiftUser user = (RedshiftUser)command.getObject();
        StringBuilder sql = new StringBuilder("CREATE USER " + DBUtils.getQuotedIdentifier((DBSObject)user));
        this.addUserOptions(sql, user, true);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create user", sql.toString()));
    }

    protected void addObjectModifyActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        RedshiftUser user = (RedshiftUser)command.getObject();
        StringBuilder sql = new StringBuilder("ALTER USER " + DBUtils.getQuotedIdentifier((DBSObject)user));
        this.addUserOptions(sql, user, false);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Alter user", sql.toString()));
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        RedshiftUser user = (RedshiftUser)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop user", "DROP USER " + DBUtils.getQuotedIdentifier((DBSObject)user)));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        RedshiftUser user = (RedshiftUser)command.getObject();
        RedshiftDataSource dataSource = user.getDataSource();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename user", "ALTER USER " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getOldName()) + " RENAME TO " + DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)command.getNewName())));
    }

    public long getMakerOptions(DBPDataSource dataSource) {
        return 4L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, RedshiftUser> getObjectsCache(RedshiftUser object) {
        return null;
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull RedshiftUser object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    private void addUserOptions(@NotNull StringBuilder sql, @NotNull RedshiftUser user, boolean create) {
        if (user.isCreateDatabase()) {
            sql.append(" CREATEDB");
        } else {
            sql.append(" NOCREATEDB");
        }
        if (user.isSuperUser()) {
            sql.append(" CREATEUSER");
        } else {
            sql.append(" NOCREATEUSER");
        }
        if (user.getConnLimit() >= 0) {
            sql.append(" CONNECTION LIMIT ").append(user.getConnLimit());
        } else {
            sql.append(" CONNECTION LIMIT UNLIMITED");
        }
        if (create && CommonUtils.isNotEmpty((String)user.getPassword())) {
            sql.append(" PASSWORD ").append(SQLUtils.quoteString((DBSObject)user, (String)user.getPassword()));
        }
    }
}

