/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redshift.auth;

import com.dbeaver.db.redshift.auth.RedshiftAuthFSPlugin;
import com.dbeaver.net.auth.aws.AWSIAMUtils;
import com.dbeaver.net.auth.aws.AuthModelAWSAbstract;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.List;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceURLProvider;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public class AuthModelAWSRedshift
extends AuthModelAWSAbstract
implements DBPDataSourceURLProvider {
    private static final Log log = Log.getLog(AuthModelAWSRedshift.class);
    public static final String ID = "redshift_iam";
    public static final String ATTR_REDSHIFT_DBUSER = "https://redshift.amazon.com/SAML/Attributes/DbUser";
    public static final String ATTR_REDSHIFT_DBGROUPS = "https://redshift.amazon.com/SAML/Attributes/DbGroups";
    public static final String ATTR_REDSHIFT_AUTOCREATE = "https://redshift.amazon.com/SAML/Attributes/AutoCreate";

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelAWSCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String userName = credentials.getUserName();
        String userPassword = credentials.getUserPassword();
        String dbUser = this.getSamlAttribute(credentials, ATTR_REDSHIFT_DBUSER);
        String dbGroups = this.getSamlAttribute(credentials, ATTR_REDSHIFT_DBGROUPS);
        String autoCreate = this.getSamlAttribute(credentials, ATTR_REDSHIFT_AUTOCREATE);
        if (dbUser != null) {
            userName = dbUser;
        }
        if (dbGroups != null) {
            connProperties.put("DbGroups", dbGroups);
        }
        if (autoCreate != null) {
            connProperties.put("AutoCreate", autoCreate);
        }
        AwsCredentialsProvider authCredentialsProvider = credentials.getAuthCredentialsProvider(monitor, configuration);
        connProperties.put("ssl", "true");
        if (!CommonUtils.isEmpty((String)userName)) {
            connProperties.put("user", userName);
        } else {
            connProperties.remove("user");
        }
        String pluginId = configuration.getAuthProperty("redshift.fs_plugin_name");
        if (!CommonUtils.isEmpty((String)pluginId)) {
            RedshiftAuthFSPlugin fsPlugin = RedshiftAuthFSPlugin.getById(pluginId);
            if (fsPlugin == null) {
                throw new DBCException("Invalid Redshift FS plugin: '" + pluginId + "'");
            }
            connProperties.put("plugin_name", fsPlugin.getProviderClassName());
            String[] stringArray = fsPlugin.getPluginProperties();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String prop = stringArray[n2];
                connProperties.put(prop, configuration.getAuthProperty(prop));
                ++n2;
            }
            if (fsPlugin.supportsCredentials() && credentials.getUserPassword() != null) {
                connProperties.put("password", credentials.getUserPassword());
            }
            return credentials;
        }
        if (!CommonUtils.isEmpty((String)userPassword)) {
            connProperties.put("password", userPassword);
        }
        AwsCredentialsProvider credentialsProvider = authCredentialsProvider;
        AwsCredentials awsCredentials = credentialsProvider.resolveCredentials();
        if (!CommonUtils.isEmpty((String)credentials.getSecretName())) {
            AWSIAMUtils.initSecretAuthentication((AuthModelAWSCredentials)credentials, (String)configuration.getAuthProperty("iam.region"), (String)credentials.getSecretName(), (AwsCredentialsProvider)credentialsProvider, (DBPConnectionConfiguration)configuration);
        }
        if (!CommonUtils.isEmpty((String)awsCredentials.accessKeyId())) {
            connProperties.put("AccessKeyID", awsCredentials.accessKeyId());
            connProperties.put("SecretAccessKey", awsCredentials.secretAccessKey());
        }
        if (awsCredentials instanceof AwsSessionCredentials) {
            connProperties.put("SessionToken", ((AwsSessionCredentials)awsCredentials).sessionToken());
        }
        return awsCredentials;
    }

    private String getSamlAttribute(AuthModelAWSCredentials credentials, String attr) {
        Object attribute = credentials.getAttribute(attr);
        if (attribute instanceof List && !((List)attribute).isEmpty()) {
            return (String)((List)attribute).get(0);
        }
        if (attribute != null) {
            return CommonUtils.toString((Object)attribute, null);
        }
        return null;
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
    }

    public String getConnectionURL(DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        String region = connectionInfo.getAuthProperty("iam.region");
        StringBuilder url = new StringBuilder();
        String hostName = connectionInfo.getHostName();
        url.append("jdbc:redshift:iam://").append(hostName).append(":");
        if (CommonUtils.isEmpty((String)hostName) || !hostName.contains(".") && !CommonUtils.isEmpty((String)region)) {
            url.append(region);
        } else {
            url.append(connectionInfo.getHostPort());
        }
        url.append("/");
        if (!CommonUtils.isEmpty((String)connectionInfo.getDatabaseName())) {
            url.append(connectionInfo.getDatabaseName());
        }
        return url.toString();
    }

    @NotNull
    public AuthModelAWSCredentials loadCredentials(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration) {
        AuthModelAWSCredentials credentials = super.loadCredentials(dataSource, configuration);
        String dbUser = this.getSamlAttribute(credentials, ATTR_REDSHIFT_DBUSER);
        if (dbUser != null) {
            credentials.setUserName(dbUser);
        }
        return credentials;
    }
}

