/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.edit;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisDatabase;
import com.dbeaver.db.redis.model.RedisKey;
import com.dbeaver.db.redis.model.RedisKeyWithValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import redis.clients.jedis.commands.JedisCommands;

public class RedisKeyManager
extends SQLObjectEditor<RedisKey, RedisDatabase> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    public boolean canCreateObject(Object container) {
        return container instanceof RedisDatabase;
    }

    public boolean canDeleteObject(RedisKey object) {
        return true;
    }

    protected RedisKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new RedisKeyWithValue((RedisDatabase)container, null, "new key", false, null);
    }

    public DBSObjectCache<? extends DBSObject, RedisKey> getObjectsCache(RedisKey object) {
        return object.getDatabase().getKeyCache();
    }

    protected void addObjectCreateActions(final DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, final SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        if (!(command.getObject() instanceof RedisKeyWithValue)) {
            return;
        }
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Add key"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                RedisKeyWithValue key = (RedisKeyWithValue)command.getObject();
                RedisSession redisSession = (RedisSession)session;
                RedisUtils.selectCurDatabase(redisSession, key.getDatabase());
                String name = key.getFullyQualifiedName(DBPEvaluationContext.DDL);
                Object value = key.getValue();
                if (!redisSession.supportsCommands(JedisCommands.class)) {
                    throw new DBCException("Jedis commands not supported");
                }
                JedisCommands commands = redisSession.getCommands(JedisCommands.class);
                switch (key.getKeyType(monitor)) {
                    case set: {
                        commands.sadd(name, RedisKeyManager.splitValue(value));
                        break;
                    }
                    case zset: {
                        commands.zadd(name, RedisKeyManager.splitMapValue(value, CommonUtils::toDouble));
                        break;
                    }
                    case string: {
                        commands.set(name, (String)value);
                        break;
                    }
                    case hash: {
                        commands.hset(name, RedisKeyManager.splitMapValue(value, Function.identity()));
                        break;
                    }
                    case list: {
                        commands.lpush(name, RedisKeyManager.splitValue(value));
                        break;
                    }
                    default: {
                        throw new DBCException("Unexpected value: " + (Object)((Object)key.getKeyType(monitor)));
                    }
                }
                Long ttl = key.getTTL();
                if (ttl != null && ttl < 0L && redisSession.supportsCommands(JedisCommands.class)) {
                    redisSession.getCommands(JedisCommands.class).expire(key.getFullyQualifiedName(DBPEvaluationContext.DDL), (long)ttl.intValue());
                }
            }
        });
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, final SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Delete key"){

            public String getScript() {
                return "DEL " + ((RedisKey)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL);
            }

            public void afterExecute(DBCSession session, Throwable error) {
                RedisKey key = (RedisKey)command.getObject();
                RedisSession redisSession = (RedisSession)session;
                RedisUtils.selectCurDatabase(redisSession, key.getDatabase());
                if (redisSession.supportsCommands(JedisCommands.class)) {
                    redisSession.getCommands(JedisCommands.class).del(key.getFullyQualifiedName(DBPEvaluationContext.DDL));
                }
            }
        });
    }

    @NotNull
    private static String[] splitValue(@NotNull Object value) {
        if (value instanceof String) {
            return (String[])RuntimeUtils.splitCommandLine((String)((String)value), (boolean)false).toArray(String[]::new);
        }
        return new String[0];
    }

    @NotNull
    private static <T> Map<String, T> splitMapValue(@NotNull Object value, @NotNull Function<String, T> mapper) throws DBCException {
        String[] values = RedisKeyManager.splitValue(value);
        HashMap<String, T> map = new HashMap<String, T>();
        int i = 0;
        while (i < values.length) {
            map.put(values[i], mapper.apply(values[i + 1]));
            i += 2;
        }
        return map;
    }
}

