/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.trace.TraceControl;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.transaction.xa.Xid;

class XATrace {
    static Hashtable xacodes = new Hashtable();
    TraceControl m_trcCtl = DriverSapDB.pptracer;

    XATrace() {
    }

    void trace(Xid xid, String message) {
        String time = new Timestamp(System.currentTimeMillis()).toString();
        String threadname = Thread.currentThread().getName();
        String xidString = xid == null ? "(null)" : xid.toString();
        StringBuffer sb = new StringBuffer(time);
        sb.append(" ");
        sb.append(threadname);
        sb.append(" ");
        sb.append(xidString);
        sb.append(" ");
        sb.append(message);
        this.m_trcCtl.tracer.println(sb.toString());
    }

    void trace(String message) {
        String time = new Timestamp(System.currentTimeMillis()).toString();
        String threadname = Thread.currentThread().getName();
        String xidString = "(none)";
        StringBuffer sb = new StringBuffer(time);
        sb.append(" ");
        sb.append(threadname);
        sb.append(" ");
        sb.append(xidString);
        sb.append(" ");
        sb.append(message);
        this.m_trcCtl.tracer.println(sb.toString());
    }

    void traceXAError(Xid xid, int code, Exception e) {
        this.trace(xid, "XA Error: " + xacodes.get(new Integer(code)) + (e != null ? " " + e.toString() : ""));
    }

    static {
        xacodes.put(new Integer(-5), "XAER_INVAL");
        xacodes.put(new Integer(7), "XA_HEURCOM");
        xacodes.put(new Integer(8), "XA_HEURHAZ");
        xacodes.put(new Integer(5), "XA_HEURMIX");
        xacodes.put(new Integer(6), "XA_HEURRB");
        xacodes.put(new Integer(9), "XA_NOMIGRATE");
        xacodes.put(new Integer(100), "XA_RBBASE");
        xacodes.put(new Integer(101), "XA_RBCOMMFAIL");
        xacodes.put(new Integer(102), "XA_RBDEADLOCK");
        xacodes.put(new Integer(107), "XA_RBEND");
        xacodes.put(new Integer(103), "XA_RBINTEGRITY");
        xacodes.put(new Integer(104), "XA_RBOTHER");
        xacodes.put(new Integer(105), "XA_RBPROTO");
        xacodes.put(new Integer(100), "XA_RBROLLBACK");
        xacodes.put(new Integer(106), "XA_RBTIMEOUT");
        xacodes.put(new Integer(107), "XA_RBTRANSIENT");
        xacodes.put(new Integer(3), "XA_RDONLY");
        xacodes.put(new Integer(4), "XA_RETRY");
        xacodes.put(new Integer(-2), "XAER_ASYNC");
        xacodes.put(new Integer(-8), "XAER_DUPID");
        xacodes.put(new Integer(-5), "XAER_INVAL");
        xacodes.put(new Integer(-4), "XAER_NOTA");
        xacodes.put(new Integer(-6), "XAER_PROTO");
        xacodes.put(new Integer(-3), "XAER_RMERR");
        xacodes.put(new Integer(-7), "XAER_RMFAIL");
    }
}

